/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\b\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\t2\n\u0010\f\u001a\u00060\nj\u0002`\u000b2\u0010\u0010\r\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u000eJ*\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u000e2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u0013J8\u0010\u0014\u001a\u00020\u00102\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\u00170\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/graph/impl/facade/ReachableNodes;", "", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "<init>", "(Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;)V", "visited", "Lcom/intellij/vcs/log/graph/utils/Flags;", "getContainingBranches", "", "", "Lcom/intellij/vcs/log/graph/api/permanent/VcsLogGraphNodeId;", "nodeId", "branchNodeIndexes", "", "walkDown", "", "headIds", "consumer", "Ljava/util/function/Consumer;", "walk", "startNodes", "goDown", "", "Lkotlin/Function1;", "intellij.platform.vcs.log.graph.impl"})
@ApiStatus.Internal
public final class ReachableNodes {
    @NotNull
    private final LiteLinearGraph graph;
    @NotNull
    private final Flags visited;

    public ReachableNodes(@NotNull LiteLinearGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
        this.visited = new BitSetFlags(this.graph.nodesCount());
    }

    @NotNull
    public final Set<Integer> getContainingBranches(int nodeId, @NotNull Collection<Integer> branchNodeIndexes) {
        Intrinsics.checkNotNullParameter(branchNodeIndexes, (String)"branchNodeIndexes");
        HashSet result = new HashSet();
        this.walk(CollectionsKt.listOf((Object)nodeId), false, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> ReachableNodes.getContainingBranches$lambda$0(branchNodeIndexes, result, arg_0)));
        return result;
    }

    public final void walkDown(@NotNull Collection<Integer> headIds, @NotNull Consumer<Integer> consumer) {
        Intrinsics.checkNotNullParameter(headIds, (String)"headIds");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.walk(headIds, true, (Function1<? super Integer, Boolean>)((Function1)arg_0 -> ReachableNodes.walkDown$lambda$1(consumer, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull Function1<? super Integer, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(startNodes, (String)"startNodes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Flags flags = this.visited;
        synchronized (flags) {
            boolean bl = false;
            this.visited.setAll(false);
            new DfsWalk(startNodes, this.graph, this.visited).walk(goDown, consumer);
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean getContainingBranches$lambda$0(Collection $branchNodeIndexes, HashSet $result, int node) {
        if ($branchNodeIndexes.contains(node)) {
            $result.add(node);
        }
        return true;
    }

    private static final boolean walkDown$lambda$1(Consumer $consumer, int node) {
        $consumer.accept(node);
        return true;
    }
}

