/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DateAndTimeFormatter<T, V extends TemporalAccessor>
extends FormatterImpl {
    private final DateTimeFormatter myFormatter;
    private final String myPattern;
    private final DateAndTimeFormatterDelegate<T, V> myDelegate;
    private final BoundaryValueResolver myBoundaryValuesResolver;
    private final DateTimeFormatter myDateFormatterForValueWithoutTime;

    public DateAndTimeFormatter(@NotNull String pattern, @NotNull DateTimeFormatter formatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (pattern == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(2);
        }
        this(pattern, formatter, delegate, BoundaryValueResolver.ALWAYS_NULL, null);
    }

    public DateAndTimeFormatter(@NotNull String pattern, @NotNull DateTimeFormatter formatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver, @Nullable DateTimeFormatter dateFormatterForValueWithoutTime) {
        if (pattern == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(5);
        }
        if (resolver == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(6);
        }
        this.myPattern = pattern;
        this.myFormatter = formatter;
        this.myDelegate = delegate;
        this.myBoundaryValuesResolver = resolver;
        this.myDateFormatterForValueWithoutTime = dateFormatterForValueWithoutTime;
    }

    @Override
    @Nls
    @NotNull
    protected String getErrorMessage() {
        String string = DataGridBundle.message("unexpected.data.format", new Object[0]);
        if (string == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(7);
        }
        return string;
    }

    private V query(TemporalAccessor parsed, TemporalQuery<V>[] queries) {
        if (parsed == null) {
            return null;
        }
        for (TemporalQuery<V> query : queries) {
            try {
                return (V)((TemporalAccessor)parsed.query(query));
            }
            catch (RuntimeException runtimeException) {
            }
        }
        return null;
    }

    @Nullable
    private TemporalAccessor parseValue(String value, @NotNull ParsePosition position) {
        if (position == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(8);
        }
        try {
            TemporalAccessor parsed = this.myFormatter.parse((CharSequence)value, position);
            if (position.getIndex() != value.length() || position.getErrorIndex() != -1) {
                return null;
            }
            return parsed;
        }
        catch (DateTimeParseException e) {
            position.setErrorIndex(e.getErrorIndex());
            return null;
        }
    }

    @Override
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        Object boundary;
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(9);
        }
        if (position == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(10);
        }
        if ((boundary = this.myBoundaryValuesResolver.createFromInfinityString(value)) != null) {
            return boundary;
        }
        TemporalAccessor parsed = this.parseValue(value, position);
        if (parsed == null) {
            return null;
        }
        V temporal = this.query(parsed, this.myDelegate.getQueries());
        if (temporal == null) {
            position.setErrorIndex(0);
            return null;
        }
        T result = this.myDelegate.createFromTemporal(temporal);
        String boundaryString = this.myBoundaryValuesResolver.resolve(result);
        return boundaryString != null ? this.myBoundaryValuesResolver.createFromInfinityString(boundaryString) : result;
    }

    @Override
    public String format(@NotNull Object value) {
        String boundary;
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(11);
        }
        if ((boundary = this.myBoundaryValuesResolver.resolve(value)) != null) {
            return boundary;
        }
        V temporalAccessor = this.myDelegate.toTemporalAccessor(value);
        if (this.myDateFormatterForValueWithoutTime != null && DataGridFormattersUtilCore.isEmptyTime(temporalAccessor)) {
            return this.myDateFormatterForValueWithoutTime.format((TemporalAccessor)temporalAccessor);
        }
        return this.myFormatter.format((TemporalAccessor)temporalAccessor);
    }

    public TemporalAccessor getTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            DateAndTimeFormatter.$$$reportNull$$$0(12);
        }
        return this.myDelegate.toTemporalAccessor(value);
    }

    public String toString() {
        return this.myPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTemporalAccessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

