/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import java.util.List;
import korlibs.crypto.Hasher;
import korlibs.crypto.HasherFactory;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\bH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkorlibs/crypto/MD4;", "Lkorlibs/crypto/Hasher;", "()V", "b", "", "o", "r", "coreDigest", "", "out", "", "corePadding", "totalWritten", "", "coreReset", "coreUpdate", "chunk", "Companion", "krypto"})
public final class MD4
extends Hasher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] r = new int[4];
    @NotNull
    private final int[] o = new int[4];
    @NotNull
    private final int[] b = new int[16];
    @NotNull
    private static final int[] S;
    @NotNull
    private static final List<Integer> R3;

    public MD4() {
        super(64, 16, "MD4");
        this.coreReset();
    }

    @Override
    protected void coreReset() {
        this.r[0] = 1732584193;
        this.r[1] = -271733879;
        this.r[2] = -1732584194;
        this.r[3] = 271733878;
    }

    @Override
    protected void coreUpdate(@NotNull byte[] chunk) {
        int j;
        for (j = 0; j < 64; ++j) {
            this.b[j >>> 2] = chunk[j] << 24 | this.b[j >>> 2] >>> 8;
        }
        for (j = 0; j < 4; ++j) {
            this.o[j] = this.r[j];
        }
        for (j = 0; j < 48; ++j) {
            int n;
            int n2;
            int n3;
            int d16 = j / 16;
            switch (d16) {
                case 0: {
                    n3 = this.r[1] & this.r[2] | ~this.r[1] & this.r[3];
                    break;
                }
                case 1: {
                    n3 = this.r[1] & this.r[2] | this.r[1] & this.r[3] | this.r[2] & this.r[3];
                    break;
                }
                case 2: {
                    n3 = this.r[1] ^ this.r[2] ^ this.r[3];
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            int f = n3;
            switch (d16) {
                case 0: {
                    n2 = j;
                    break;
                }
                case 1: {
                    n2 = j % 16 / 4 + j * 4 % 16;
                    break;
                }
                case 2: {
                    n2 = ((Number)R3.get(j % 16 / 4)).intValue() + 4 * ((Number)R3.get(j % 4)).intValue();
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            int bi = n2;
            switch (d16) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1518500249;
                    break;
                }
                case 2: {
                    n = 1859775393;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            int t = n;
            int temp = KryptoToolsKt.rotateLeft(this.r[0] + f + this.b[bi] + t, S[d16 << 2 | j & 3]);
            this.r[0] = this.r[3];
            this.r[3] = this.r[2];
            this.r[2] = this.r[1];
            this.r[1] = temp;
        }
        for (j = 0; j < 4; ++j) {
            int[] nArray = this.r;
            int n = j;
            nArray[n] = nArray[n] + this.o[j];
        }
    }

    @Override
    @NotNull
    protected byte[] corePadding(long totalWritten) {
        byte[] byArray;
        long numberOfBlocks = (totalWritten + (long)8) / (long)this.getChunkSize() + 1L;
        long totalWrittenBits = totalWritten * (long)8;
        byte[] $this$corePadding_u24lambda_u240 = byArray = new byte[(int)(numberOfBlocks * (long)this.getChunkSize() - totalWritten)];
        boolean bl = false;
        $this$corePadding_u24lambda_u240[0] = -128;
        for (int i = 0; i < 8; ++i) {
            $this$corePadding_u24lambda_u240[$this$corePadding_u24lambda_u240.length - 8 + i] = (byte)(totalWrittenBits >>> 8 * i);
        }
        return byArray;
    }

    @Override
    protected void coreDigest(@NotNull byte[] out) {
        for (int it = 0; it < 16; ++it) {
            out[it] = (byte)(this.r[it / 4] >>> it % 4 * 8);
        }
    }

    static {
        Object[] objectArray = new int[]{3, 7, 11, 19, 3, 5, 9, 13, 3, 9, 11, 15};
        S = objectArray;
        objectArray = new Integer[4];
        objectArray[0] = 0;
        objectArray[1] = 2;
        objectArray[2] = 1;
        objectArray[3] = 3;
        R3 = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkorlibs/crypto/MD4$Companion;", "Lkorlibs/crypto/HasherFactory;", "()V", "R3", "", "", "S", "", "krypto"})
    public static final class Companion
    extends HasherFactory {
        private Companion() {
            super("MD4", (Function0<? extends Hasher>)((Function0)1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

