/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.io;

import org.jetbrains.kotlin.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.org.apache.http.HttpResponseFactory;
import org.jetbrains.kotlin.org.apache.http.config.MessageConstraints;
import org.jetbrains.kotlin.org.apache.http.impl.DefaultHttpResponseFactory;
import org.jetbrains.kotlin.org.apache.http.impl.io.DefaultHttpResponseParser;
import org.jetbrains.kotlin.org.apache.http.io.HttpMessageParser;
import org.jetbrains.kotlin.org.apache.http.io.HttpMessageParserFactory;
import org.jetbrains.kotlin.org.apache.http.io.SessionInputBuffer;
import org.jetbrains.kotlin.org.apache.http.message.BasicLineParser;
import org.jetbrains.kotlin.org.apache.http.message.LineParser;

public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

