/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.clientConfiguration;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.mcpserver.StdioRunnerUtilKt;
import com.intellij.mcpserver.clientConfiguration.ExistingConfig;
import com.intellij.mcpserver.clientConfiguration.MCPClientNames;
import com.intellij.mcpserver.clientConfiguration.McpClient;
import com.intellij.mcpserver.clientConfiguration.McpServers;
import com.intellij.mcpserver.clientConfiguration.STDIOServerConfig;
import com.intellij.mcpserver.clientConfiguration.ServerConfig;
import com.intellij.mcpserver.impl.McpServerService;
import com.intellij.openapi.util.NlsContexts;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\u0016\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0014J\u000f\u0010 \u001a\u0004\u0018\u00010\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015J\u000f\u0010!\u001a\u0004\u0018\u00010\u0014H\u0004\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\"\u001a\u00020\u0014J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u001aH\u0004J\b\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0006\u0010(\u001a\u00020\u001aH\u0014J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\r8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Lcom/intellij/mcpserver/clientConfiguration/McpClient;", "", "name", "Lcom/intellij/mcpserver/clientConfiguration/MCPClientNames;", "configPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/mcpserver/clientConfiguration/MCPClientNames;Ljava/nio/file/Path;)V", "getName", "()Lcom/intellij/mcpserver/clientConfiguration/MCPClientNames;", "getConfigPath", "()Ljava/nio/file/Path;", "toString", "", "sseUrl", "getSseUrl", "()Ljava/lang/String;", "sseUrl$delegate", "Lkotlin/Lazy;", "isConfigured", "", "()Ljava/lang/Boolean;", "mcpServersKey", "configure", "", "getConfig", "Lcom/intellij/mcpserver/clientConfiguration/ServerConfig;", "getSSEConfig", "getStdioConfig", "readMcpServers", "", "Lcom/intellij/mcpserver/clientConfiguration/ExistingConfig;", "isStdIOConfigured", "isSSEConfigured", "isPortCorrect", "isPortMatching", "serverConfig", "targetPort", "", "updateServerConfig", "serverEntry", "readExistingConfig", "Lkotlinx/serialization/json/JsonObject;", "buildUpdatedConfig", "existingConfig", "writeConfigToFile", "config", "Companion", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nclients.kt\nKotlin\n*S Kotlin\n*F\n+ 1 clients.kt\ncom/intellij/mcpserver/clientConfiguration/McpClient\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 6 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,243:1\n80#2:244\n80#2:254\n42#2:276\n188#3,3:245\n188#3,3:248\n188#3,3:251\n216#3,2:267\n216#3,2:273\n1#4:255\n29#5,3:256\n29#5,3:259\n29#5,3:262\n29#5,2:265\n31#5:270\n29#5,2:271\n31#5:275\n324#6:269\n*S KotlinDebug\n*F\n+ 1 clients.kt\ncom/intellij/mcpserver/clientConfiguration/McpClient\n*L\n78#1:244\n137#1:254\n166#1:276\n85#1:245,3\n95#1:248,3\n105#1:251,3\n149#1:267,2\n154#1:273,2\n138#1:256,3\n141#1:259,3\n146#1:262,3\n148#1:265,2\n148#1:270\n153#1:271,2\n153#1:275\n150#1:269\n*E\n"})
public class McpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MCPClientNames name;
    @NotNull
    private final Path configPath;
    @NotNull
    private final Lazy sseUrl$delegate;
    @NotNull
    private static final Regex SSE_URL_REGEX = new Regex("http://localhost:(\\d+)/sse");
    @NotNull
    protected static final String JETBRAINS_SERVER_KEY = "jetbrains";
    @NotNull
    private static final Lazy<Json> json$delegate = LazyKt.lazy(McpClient::json_delegate$lambda$18);

    public McpClient(@NlsContexts.BorderTitle @NotNull MCPClientNames name, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        this.name = name;
        this.configPath = configPath;
        this.sseUrl$delegate = LazyKt.lazy(McpClient::sseUrl_delegate$lambda$0);
    }

    @NotNull
    public final MCPClientNames getName() {
        return this.name;
    }

    @NotNull
    public final Path getConfigPath() {
        return this.configPath;
    }

    @NotNull
    public String toString() {
        return this.name.getDisplayName();
    }

    @NotNull
    protected final String getSseUrl() {
        Lazy lazy = this.sseUrl$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public Boolean isConfigured() {
        return true;
    }

    @NotNull
    public String mcpServersKey() {
        return "mcpServers";
    }

    public void configure() {
        this.updateServerConfig(this.getConfig());
    }

    @NotNull
    public final ServerConfig getConfig() {
        ServerConfig serverConfig = this.getSSEConfig();
        if (serverConfig == null) {
            serverConfig = this.getStdioConfig();
        }
        return serverConfig;
    }

    @Nullable
    protected ServerConfig getSSEConfig() {
        return null;
    }

    private final ServerConfig getStdioConfig() {
        GeneralCommandLine cmd = StdioRunnerUtilKt.createStdioMcpServerCommandLine$default(McpServerService.Companion.getInstance().getPort(), null, null, 4, null);
        return new STDIOServerConfig(cmd.getExePath(), cmd.getParametersList().getParameters(), cmd.getEnvironment());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Map<String, ExistingConfig> readMcpServers() {
        Object object;
        Object object2 = this;
        try {
            void stream$iv;
            void $this$decodeFromStream$iv;
            McpClient $this$readMcpServers_u24lambda_u241 = object2;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists($this$readMcpServers_u24lambda_u241.configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return null;
            }
            Json json = Companion.getJson();
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream($this$readMcpServers_u24lambda_u241.configPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            InputStream inputStream2 = inputStream;
            boolean $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            object = Result.constructor-impl(((McpServers)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)McpServers.Companion.serializer()), (InputStream)stream$iv)).getMcpServers());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected final Boolean isStdIOConfigured() {
        boolean bl;
        boolean bl2;
        Map<String, ExistingConfig> mcpServers;
        Map<String, ExistingConfig> map = mcpServers = this.readMcpServers();
        if (map == null) return null;
        boolean bl3 = map.isEmpty();
        if (bl3) {
            return null;
        }
        Map<String, ExistingConfig> $this$any$iv = mcpServers;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            bl2 = false;
            return bl2;
        }
        Iterator<Map.Entry<String, ExistingConfig>> iterator = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, ExistingConfig> element$iv;
            if (!iterator.hasNext()) {
                bl2 = false;
                return bl2;
            }
            Map.Entry<String, ExistingConfig> entry = element$iv = iterator.next();
            boolean bl4 = false;
            ExistingConfig serverConfig = entry.getValue();
            String string = serverConfig.getCommand();
            boolean bl5 = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"java", (boolean)false, (int)2, null) : false;
            if (bl5) {
                Map<String, String> map2 = serverConfig.getEnv();
                boolean bl6 = map2 != null ? map2.containsKey("IJ_MCP_SERVER_PORT") : false;
                if (bl6) {
                    boolean bl7;
                    List<String> list = serverConfig.getArgs();
                    if (list != null) {
                        Method method = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)isStdIOConfigured.1.1.INSTANCE));
                        Intrinsics.checkNotNull((Object)method);
                        bl7 = list.contains(method.getDeclaringClass().getName());
                    } else {
                        bl7 = false;
                    }
                    if (bl7) {
                        bl = true;
                        continue;
                    }
                }
            }
            bl = false;
        } while (!bl);
        bl2 = true;
        return bl2;
    }

    @Nullable
    protected final Boolean isSSEConfigured() {
        boolean bl;
        block4: {
            Map<String, ExistingConfig> mcpServers;
            Map<String, ExistingConfig> map = mcpServers = this.readMcpServers();
            if (map != null ? map.isEmpty() : true) {
                return null;
            }
            Map<String, ExistingConfig> $this$any$iv = mcpServers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, ExistingConfig>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ExistingConfig> element$iv;
                    Map.Entry<String, ExistingConfig> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    ExistingConfig serverConfig = entry.getValue();
                    String string = serverConfig.getUrl();
                    boolean bl3 = string != null ? SSE_URL_REGEX.matches((CharSequence)string) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isPortCorrect() {
        boolean bl;
        Map<String, ExistingConfig> mcpServers;
        if (!McpServerService.Companion.getInstance().isRunning()) {
            return true;
        }
        int currentPort = McpServerService.Companion.getInstance().getPort();
        Map<String, ExistingConfig> map = mcpServers = this.readMcpServers();
        if (map != null ? map.isEmpty() : true) {
            return true;
        }
        Map<String, ExistingConfig> map2 = this.readMcpServers();
        if (map2 != null) {
            boolean bl2;
            block7: {
                Map<String, ExistingConfig> $this$any$iv = map2;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator<Map.Entry<String, ExistingConfig>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, ExistingConfig> element$iv;
                        Map.Entry<String, ExistingConfig> entry = element$iv = iterator.next();
                        boolean bl3 = false;
                        ExistingConfig serverConfig = entry.getValue();
                        if (!this.isPortMatching(serverConfig, currentPort)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isPortMatching(ExistingConfig serverConfig, int targetPort) {
        String string = serverConfig.getUrl();
        if (string != null) {
            String url = string;
            boolean bl = false;
            MatchResult matchResult = Regex.find$default((Regex)SSE_URL_REGEX, (CharSequence)url, (int)0, (int)2, null);
            Object object = matchResult;
            if (object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                int configuredPort = ((Number)object).intValue();
                boolean bl2 = false;
                return configuredPort == targetPort;
            }
            return false;
        }
        String string2 = serverConfig.getCommand();
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"java", (boolean)false, (int)2, null) : false;
        if (bl) {
            Map<String, String> map = serverConfig.getEnv();
            boolean bl3 = map != null ? map.containsKey("IJ_MCP_SERVER_PORT") : false;
            if (bl3) {
                boolean bl4;
                List<String> list = serverConfig.getArgs();
                if (list != null) {
                    Method method = ReflectJvmMapping.getJavaMethod((KFunction)((KFunction)isPortMatching.2.INSTANCE));
                    Intrinsics.checkNotNull((Object)method);
                    bl4 = list.contains(method.getDeclaringClass().getName());
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    Integer configuredPort;
                    String string3 = serverConfig.getEnv().get("IJ_MCP_SERVER_PORT");
                    Integer n = configuredPort = string3 != null ? StringsKt.toIntOrNull((String)string3) : null;
                    int n2 = targetPort;
                    return n != null && n == n2;
                }
            }
        }
        return true;
    }

    protected final void updateServerConfig(@NotNull ServerConfig serverEntry) {
        Intrinsics.checkNotNullParameter((Object)serverEntry, (String)"serverEntry");
        JsonObject existingConfig = this.readExistingConfig();
        JsonObject updatedConfig = this.buildUpdatedConfig(existingConfig, serverEntry);
        this.writeConfigToFile(updatedConfig);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject readExistingConfig() {
        JsonObject jsonObject;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object object;
            Object $this$readExistingConfig_u24lambda_u247;
            Object object2 = this;
            try {
                void stream$iv;
                void $this$decodeFromStream$iv;
                $this$readExistingConfig_u24lambda_u247 = object2;
                boolean bl = false;
                Json json = Companion.getJson();
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(((McpClient)$this$readExistingConfig_u24lambda_u247).configPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                InputStream inputStream2 = inputStream;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv.getSerializersModule();
                $this$readExistingConfig_u24lambda_u247 = Result.constructor-impl((Object)((JsonObject)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)JsonObject.Companion.serializer()), (InputStream)stream$iv)));
            }
            catch (Throwable bl) {
                $this$readExistingConfig_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$readExistingConfig_u24lambda_u247;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                JsonObjectBuilder builder$iv;
                Throwable it = throwable;
                boolean bl = false;
                boolean $i$f$buildJsonObject = false;
                JsonObjectBuilder $this$readExistingConfig_u24lambda_u249_u24lambda_u248 = builder$iv = new JsonObjectBuilder();
                boolean bl2 = false;
                object = builder$iv.build();
            }
            jsonObject = (JsonObject)object;
        } else {
            JsonObjectBuilder builder$iv;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$readExistingConfig_u24lambda_u2410 = builder$iv = new JsonObjectBuilder();
            boolean bl = false;
            jsonObject = builder$iv.build();
        }
        return jsonObject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JsonObject buildUpdatedConfig(@NotNull JsonObject existingConfig, @NotNull ServerConfig serverEntry) {
        void $this$encodeToJsonElement$iv;
        JsonElement value;
        String key;
        Map.Entry entry;
        Map.Entry element$iv;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)existingConfig, (String)"existingConfig");
        Intrinsics.checkNotNullParameter((Object)serverEntry, (String)"serverEntry");
        JsonElement jsonElement = (JsonElement)existingConfig.get((Object)this.mcpServersKey());
        if (jsonElement == null || (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) == null) {
            JsonObjectBuilder builder$iv2;
            boolean $i$f$buildJsonObject = false;
            JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u2411 = builder$iv2 = new JsonObjectBuilder();
            boolean bl = false;
            jsonElement = builder$iv2.build();
        }
        JsonElement existingServers = jsonElement;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u2413 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map $this$forEach$iv = (Map)existingServers;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl2 = false;
            key = (String)entry.getKey();
            value = (JsonElement)entry.getValue();
            $this$buildUpdatedConfig_u24lambda_u2413.put(key, value);
        }
        $this$forEach$iv = Companion.getJson();
        ServerConfig value$iv = serverEntry;
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        $this$buildUpdatedConfig_u24lambda_u2413.put(JETBRAINS_SERVER_KEY, $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)ServerConfig.Companion.serializer(), (Object)value$iv));
        JsonObject updatedServers = builder$iv.build();
        $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$buildUpdatedConfig_u24lambda_u2415 = builder$iv = new JsonObjectBuilder();
        boolean bl3 = false;
        $this$forEach$iv = (Map)existingConfig;
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl4 = false;
            key = (String)entry.getKey();
            value = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)this.mcpServersKey())) continue;
            $this$buildUpdatedConfig_u24lambda_u2415.put(key, value);
        }
        $this$buildUpdatedConfig_u24lambda_u2415.put(this.mcpServersKey(), (JsonElement)updatedServers);
        return builder$iv.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeConfigToFile(JsonObject config) {
        Path path = this.configPath.getParent();
        if (path != null) {
            PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(this.configPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            void value$iv;
            void $this$encodeToStream$iv;
            OutputStream outputStream2 = (OutputStream)closeable;
            boolean bl = false;
            Json json = Companion.getJson();
            JsonObject jsonObject = config;
            OutputStream stream$iv = outputStream2;
            boolean $i$f$encodeToStream = false;
            $this$encodeToStream$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)JsonObject.Companion.serializer()), (Object)value$iv, (OutputStream)stream$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final String sseUrl_delegate$lambda$0() {
        return "http://localhost:" + McpServerService.Companion.getInstance().getPort() + "/sse";
    }

    private static final Unit json_delegate$lambda$18$lambda$17(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setAllowComments(true);
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setPrettyPrint(true);
        $this$Json.setPrettyPrintIndent("  ");
        $this$Json.setClassDiscriminatorMode(ClassDiscriminatorMode.NONE);
        return Unit.INSTANCE;
    }

    private static final Json json_delegate$lambda$18() {
        return JsonKt.Json$default(null, McpClient::json_delegate$lambda$18$lambda$17, (int)1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0084T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/mcpserver/clientConfiguration/McpClient$Companion;", "", "<init>", "()V", "SSE_URL_REGEX", "Lkotlin/text/Regex;", "JETBRAINS_SERVER_KEY", "", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "json$delegate", "Lkotlin/Lazy;", "intellij.mcpserver"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Json getJson() {
            Lazy lazy = json$delegate;
            return (Json)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

