/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.VersionCatalogsModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmPropertiesFile;
import org.jetbrains.plugins.gradle.properties.GradleLocalPropertiesFile;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.service.project.GradleAutoReloadSettingsCollector;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleAutoImportAware
implements ExternalSystemAutoImportAware {
    private static final Logger LOG = Logger.getInstance(GradleAutoImportAware.class);

    @Nullable
    public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
        if (changedFileOrDirPath == null) {
            GradleAutoImportAware.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(1);
        }
        if (!changedFileOrDirPath.endsWith(".gradle") && !changedFileOrDirPath.endsWith(".gradle.kts")) {
            return null;
        }
        if (GradleAutoImportAware.isInsideCompileOutput(changedFileOrDirPath, project)) {
            return null;
        }
        File file = new File(changedFileOrDirPath);
        if (file.isDirectory()) {
            return null;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        assert (manager != null);
        AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
        Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return null;
        }
        HashMap<String, String> rootPaths = new HashMap<String, String>();
        for (ExternalProjectSettings setting : projectsSettings) {
            if (setting == null) continue;
            for (String path : setting.getModules()) {
                rootPaths.put(new File(path).getPath(), setting.getExternalProjectPath());
            }
        }
        for (File f = file.getParentFile(); f != null; f = f.getParentFile()) {
            String dirPath = f.getPath();
            if (!rootPaths.containsKey(dirPath)) continue;
            return (String)rootPaths.get(dirPath);
        }
        return null;
    }

    private static boolean isInsideCompileOutput(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            GradleAutoImportAware.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(3);
        }
        String url = VfsUtilCore.pathToUrl((String)path);
        boolean isInsideProjectCompile = Optional.ofNullable(CompilerProjectExtension.getInstance((Project)project)).map(CompilerProjectExtension::getCompilerOutputUrl).filter(outputUrl -> VfsUtilCore.isEqualOrAncestor((String)outputUrl, (String)url)).isPresent();
        if (isInsideProjectCompile) {
            return true;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).map(CompilerModuleExtension::getInstance).filter(Objects::nonNull).flatMap(ex -> Stream.of(ex.getCompilerOutputUrl(), ex.getCompilerOutputUrlForTests())).filter(Objects::nonNull).anyMatch(outputUrl -> VfsUtilCore.isEqualOrAncestor((String)outputUrl, (String)url));
    }

    @NotNull
    public List<File> getAffectedExternalProjectFiles(@NotNull String externalProjectPath2, @NotNull Project project) {
        GradleSettings settings;
        GradleProjectSettings projectSettings;
        if (externalProjectPath2 == null) {
            GradleAutoImportAware.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GradleAutoImportAware.$$$reportNull$$$0(5);
        }
        if ((projectSettings = (GradleProjectSettings)(settings = GradleSettings.getInstance(project)).getLinkedProjectSettings(externalProjectPath2)) == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                GradleAutoImportAware.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList result = new SmartList();
        GradleAutoReloadSettingsCollector.EP_NAME.forEachExtensionSafe(extension -> {
            List<Path> settingsFiles = extension.collectSettingsFiles(project, projectSettings);
            result.addAll((Collection)ContainerUtil.map(settingsFiles, it -> it.toFile()));
        });
        SmartList smartList = result;
        if (smartList == null) {
            GradleAutoImportAware.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    public boolean isApplicable(@Nullable ProjectResolverPolicy resolverPolicy) {
        return resolverPolicy == null || !resolverPolicy.isPartialDataResolveAllowed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFileOrDirPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedExternalProjectFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedExternalProjectPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInsideCompileOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedExternalProjectFiles";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    public static final class GradleScriptCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<Path> collectSettingsFiles(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
            if (project == null) {
                GradleScriptCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                GradleScriptCollector.$$$reportNull$$$0(1);
            }
            SmartList paths = new SmartList();
            for (String modulePath : projectSettings.getModules()) {
                ProgressManager.checkCanceled();
                try {
                    Files.walkFileTree(Paths.get(modulePath, new String[0]), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((List)paths){
                        final /* synthetic */ List val$paths;
                        {
                            this.val$paths = list;
                        }

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            String fileName = path.getFileName().toString();
                            if ((fileName.endsWith(".gradle") || fileName.endsWith(".gradle.kts")) && Files.isRegularFile(path, new LinkOption[0])) {
                                this.val$paths.add(path);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException | InvalidPathException e) {
                    LOG.debug((Throwable)e);
                }
            }
            SmartList smartList = paths;
            if (smartList == null) {
                GradleScriptCollector.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradleScriptCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradleScriptCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class WrapperConfigCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<Path> collectSettingsFiles(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
            if (project == null) {
                WrapperConfigCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                WrapperConfigCollector.$$$reportNull$$$0(1);
            }
            if (projectSettings.getDistributionType() == DistributionType.DEFAULT_WRAPPED) {
                Path projectPath = Path.of(projectSettings.getExternalProjectPath(), new String[0]);
                List<Path> list = Collections.singletonList(projectPath.resolve("gradle/wrapper/gradle-wrapper.properties"));
                if (list == null) {
                    WrapperConfigCollector.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<Path> list = Collections.emptyList();
            if (list == null) {
                WrapperConfigCollector.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$WrapperConfigCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$WrapperConfigCollector";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class VersionCatalogCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<Path> collectSettingsFiles(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
            String externalProjectPath2;
            DataNode projectNode;
            if (project == null) {
                VersionCatalogCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                VersionCatalogCollector.$$$reportNull$$$0(1);
            }
            if ((projectNode = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)(externalProjectPath2 = projectSettings.getExternalProjectPath()))) == null) {
                List<Path> list = Collections.emptyList();
                if (list == null) {
                    VersionCatalogCollector.$$$reportNull$$$0(2);
                }
                return list;
            }
            DataNode versionCatalogNode = ExternalSystemApiUtil.find((DataNode)projectNode, BuildScriptClasspathData.VERSION_CATALOGS);
            if (versionCatalogNode == null) {
                List<Path> list = Collections.emptyList();
                if (list == null) {
                    VersionCatalogCollector.$$$reportNull$$$0(3);
                }
                return list;
            }
            Map versionCatalogPaths = ((VersionCatalogsModel)versionCatalogNode.getData()).getCatalogsLocations();
            List list = ContainerUtil.map(versionCatalogPaths.values(), it -> Path.of(it, new String[0]));
            if (list == null) {
                VersionCatalogCollector.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$VersionCatalogCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$VersionCatalogCollector";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static final class GradlePropertiesCollector
    implements GradleAutoReloadSettingsCollector {
        @Override
        @NotNull
        public List<Path> collectSettingsFiles(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
            if (project == null) {
                GradlePropertiesCollector.$$$reportNull$$$0(0);
            }
            if (projectSettings == null) {
                GradlePropertiesCollector.$$$reportNull$$$0(1);
            }
            Path projectPath = Path.of(projectSettings.getExternalProjectPath(), new String[0]);
            SmartList paths = new SmartList();
            paths.addAll(GradlePropertiesFile.getPropertyPaths(project, projectPath));
            paths.add(GradleLocalPropertiesFile.getPropertyPath(projectPath));
            paths.add(GradleDaemonJvmPropertiesFile.getPropertyPath(projectPath));
            paths.add(GradleUserHomeUtil.gradleUserHomeDir().toPath().resolve("init.gradle"));
            SmartList smartList = paths;
            if (smartList == null) {
                GradlePropertiesCollector.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradlePropertiesCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/GradleAutoImportAware$GradlePropertiesCollector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSettingsFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSettingsFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

