/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.frameworkSupport.script;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.frameworkSupport.script.ScriptBuilder;
import org.jetbrains.plugins.gradle.frameworkSupport.script.ScriptElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/frameworkSupport/script/AbstractScriptBuilder;", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptBuilder;", "indent", "", "<init>", "(I)V", "lines", "Ljava/util/ArrayList;", "", "generate", "root", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptElement$Statement$Expression$BlockElement;", "add", "", "element", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptElement;", "isNewLine", "", "elements", "", "code", "hasTrailingBlock", "arguments", "Lorg/jetbrains/plugins/gradle/frameworkSupport/script/ScriptElement$ArgumentElement;", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nAbstractScriptBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScriptBuilder.kt\norg/jetbrains/plugins/gradle/frameworkSupport/script/AbstractScriptBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1869#2,2:118\n1869#2,2:120\n*S KotlinDebug\n*F\n+ 1 AbstractScriptBuilder.kt\norg/jetbrains/plugins/gradle/frameworkSupport/script/AbstractScriptBuilder\n*L\n14#1:118,2\n16#1:120,2\n*E\n"})
public abstract class AbstractScriptBuilder
implements ScriptBuilder {
    private final int indent;
    @NotNull
    private final ArrayList<String> lines;

    public AbstractScriptBuilder(int indent) {
        this.indent = indent;
        this.lines = new ArrayList();
    }

    public /* synthetic */ AbstractScriptBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    @Override
    @NotNull
    public String generate(@NotNull ScriptElement.Statement.Expression.BlockElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.lines.clear();
        Iterable $this$forEach$iv = root.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptElement.Statement it = (ScriptElement.Statement)element$iv;
            boolean bl = false;
            this.add(it, this.indent, true);
        }
        StringJoiner joiner = new StringJoiner("\n");
        Iterable $this$forEach$iv2 = this.lines;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CharSequence p0 = (CharSequence)element$iv;
            boolean bl = false;
            joiner.add(p0);
        }
        String string = joiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    protected void add(@NotNull ScriptElement element, int indent, boolean isNewLine) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ScriptElement scriptElement = element;
        if (scriptElement instanceof ScriptElement.ArgumentElement) {
            if (((ScriptElement.ArgumentElement)element).getName() != null) {
                this.add(((ScriptElement.ArgumentElement)element).getName(), indent, isNewLine);
                this.add(" = ", indent, false);
            }
            this.add(((ScriptElement.ArgumentElement)element).getValue(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.AssignElement) {
            this.add(((ScriptElement.Statement.AssignElement)element).getLeft(), indent, isNewLine);
            this.add(" = ", indent, false);
            this.add(((ScriptElement.Statement.AssignElement)element).getRight(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.PlusAssignElement) {
            this.add(((ScriptElement.Statement.PlusAssignElement)element).getName(), indent, isNewLine);
            this.add(" += ", indent, false);
            this.add(((ScriptElement.Statement.PlusAssignElement)element).getValue(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.BlockElement) {
            this.add("{", indent, isNewLine);
            for (ScriptElement.Statement statement : ((ScriptElement.Statement.Expression.BlockElement)element).getStatements()) {
                this.add(statement, indent + 1, true);
            }
            this.add("}", indent, true);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.CallElement) {
            this.add(((ScriptElement.Statement.Expression.CallElement)element).getName(), indent, isNewLine);
            if (this.hasTrailingBlock(((ScriptElement.Statement.Expression.CallElement)element).getArguments())) {
                if (((ScriptElement.Statement.Expression.CallElement)element).getArguments().size() > 1) {
                    this.add("(", indent, false);
                    this.add(CollectionsKt.dropLast(((ScriptElement.Statement.Expression.CallElement)element).getArguments(), (int)1), indent);
                    this.add(")", indent, false);
                }
                this.add(" ", indent, false);
                this.add(((ScriptElement.ArgumentElement)CollectionsKt.last(((ScriptElement.Statement.Expression.CallElement)element).getArguments())).getValue(), indent, false);
            } else {
                this.add("(", indent, false);
                this.add(((ScriptElement.Statement.Expression.CallElement)element).getArguments(), indent);
                this.add(")", indent, false);
            }
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.CodeElement) {
            for (String line : ((ScriptElement.Statement.Expression.CodeElement)element).getText()) {
                this.add(line, indent, isNewLine);
            }
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.InfixCall) {
            this.add(((ScriptElement.Statement.Expression.InfixCall)element).getLeft(), indent, isNewLine);
            this.add(" ", indent, false);
            this.add(((ScriptElement.Statement.Expression.InfixCall)element).getName(), indent, false);
            this.add(" ", indent, false);
            this.add(((ScriptElement.Statement.Expression.InfixCall)element).getRight(), indent, false);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.IntElement) {
            this.add(String.valueOf(((ScriptElement.Statement.Expression.IntElement)element).getValue()), indent, isNewLine);
        } else if (scriptElement instanceof ScriptElement.Statement.Expression.BooleanElement) {
            this.add(String.valueOf(((ScriptElement.Statement.Expression.BooleanElement)element).getValue()), indent, isNewLine);
        } else if (Intrinsics.areEqual((Object)scriptElement, (Object)ScriptElement.Statement.NewLineElement.INSTANCE)) {
            this.add("", indent, isNewLine);
        } else {
            throw new IllegalStateException(("Unsupported element: " + element.getClass()).toString());
        }
    }

    protected final void add(@NotNull List<? extends ScriptElement> elements, int indent) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterator iterator = ((Iterable)elements).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ScriptElement argument = (ScriptElement)iterator.next();
            if (i != 0) {
                this.add(", ", indent, false);
            }
            this.add(argument, indent, false);
        }
    }

    protected final void add(@NotNull String code, int indent, boolean isNewLine) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (isNewLine || this.lines.isEmpty()) {
            boolean bl = StringsKt.isBlank((CharSequence)code) ? this.lines.add(code) : this.lines.add(StringsKt.repeat((CharSequence)"    ", (int)indent) + code);
        } else {
            ArrayList<String> arrayList = this.lines;
            int n = CollectionsKt.getLastIndex((List)this.lines);
            arrayList.set(n, arrayList.get(n) + code);
        }
    }

    protected final boolean hasTrailingBlock(@NotNull List<ScriptElement.ArgumentElement> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        ScriptElement.ArgumentElement argumentElement = (ScriptElement.ArgumentElement)CollectionsKt.lastOrNull(arguments);
        if (argumentElement == null) {
            return false;
        }
        ScriptElement.ArgumentElement last = argumentElement;
        return last.getValue() instanceof ScriptElement.Statement.Expression.BlockElement && last.getName() == null;
    }

    public AbstractScriptBuilder() {
        this(0, 1, null);
    }
}

