/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.internal.markup;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.platform.internal.DumpAction;
import com.jetbrains.rdclient.daemon.util.HighlighterDumpUtilKt;
import com.jetbrains.rdclient.daemon.util.HighlighterTagPrinter;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/internal/markup/DumpAllHighlightersAction;", "Lcom/jetbrains/rd/platform/internal/DumpAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.rd.client"})
public final class DumpAllHighlightersAction
extends DumpAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> IsFrontendHighlighterKey = new Key("IsFrontendHighlighterKey");
    @NotNull
    private static final Key<Boolean> IsEditorHighlighterKey = new Key("IsEditorHighlighterKey");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        this.dump(project2, arg_0 -> DumpAllHighlightersAction.actionPerformed$lambda$0(e, project2, arg_0));
    }

    private static final Unit actionPerformed$lambda$0(AnActionEvent $e, Project $project, OutputStreamWriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataContext dataContext = $e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        it.append(Companion.createHighlightersDump(dataContext, $project));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdclient/internal/markup/DumpAllHighlightersAction$Companion;", "", "<init>", "()V", "IsFrontendHighlighterKey", "Lcom/intellij/openapi/util/Key;", "", "IsEditorHighlighterKey", "createHighlightersDump", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "getAdditionalText", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nDumpAllHighlightersAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpAllHighlightersAction.kt\ncom/jetbrains/rdclient/internal/markup/DumpAllHighlightersAction$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n13472#2,2:64\n13472#2,2:66\n13472#2,2:68\n*S KotlinDebug\n*F\n+ 1 DumpAllHighlightersAction.kt\ncom/jetbrains/rdclient/internal/markup/DumpAllHighlightersAction$Companion\n*L\n32#1:64,2\n37#1:66,2\n50#1:68,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String createHighlightersDump(@NotNull DataContext dataContext, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return "Error: couldn't find editor";
            }
            Editor editor2 = editor;
            Object[] objectArray = editor2.getMarkupModel().getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllHighlighters(...)");
            Object[] editorHighlighters = objectArray;
            Object[] objectArray2 = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)project, (boolean)true).getAllHighlighters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getAllHighlighters(...)");
            Object[] documentHighlighters = objectArray2;
            try {
                Object it;
                Object element$iv;
                int n;
                Object[] $this$forEach$iv = editorHighlighters;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    it.putUserData(IsEditorHighlighterKey, (Object)true);
                    Key key = IsFrontendHighlighterKey;
                    Intrinsics.checkNotNull((Object)it);
                    it.putUserData(key, (Object)(!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)it) ? 1 : 0));
                }
                $this$forEach$iv = documentHighlighters;
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    it.putUserData(IsEditorHighlighterKey, (Object)false);
                    Key key = IsFrontendHighlighterKey;
                    Intrinsics.checkNotNull((Object)it);
                    it.putUserData(key, (Object)(!HighlightersUtilKt.isBackendHighlighter((RangeHighlighter)it) ? 1 : 0));
                }
                String string = editor2.getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = HighlighterDumpUtilKt.annotateTextWithRangeHighlighters(string, ArraysKt.asIterable((Object[])ArraysKt.plus((Object[])editorHighlighters, (Object[])documentHighlighters)), (Function1<? super RangeHighlighter, String>)((Function1)Companion::createHighlightersDump$lambda$2), (Function1<? super RangeHighlighter, String>)((Function1)new Function1<RangeHighlighter, String>((Object)this){

                    public final String invoke(RangeHighlighter p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return com.jetbrains.rdclient.internal.markup.DumpAllHighlightersAction$Companion.access$getAdditionalText((Companion)this.receiver, p0);
                    }
                }));
                return string2;
            }
            finally {
                Object[] $this$forEach$iv = ArraysKt.plus((Object[])editorHighlighters, (Object[])documentHighlighters);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)it), (Key)IsEditorHighlighterKey);
                    RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)it), (Key)IsFrontendHighlighterKey);
                }
            }
        }

        private final String getAdditionalText(RangeHighlighter highlighter) {
            Object object = highlighter.getUserData(IsFrontendHighlighterKey);
            Intrinsics.checkNotNull((Object)object);
            String string = (Boolean)object != false ? "FRONTEND" : "BACKEND";
            Object object2 = highlighter.getUserData(IsEditorHighlighterKey);
            Intrinsics.checkNotNull((Object)object2);
            return string + " " + ((Boolean)object2 != false ? "EDITOR" : "DOCUMENT");
        }

        private static final String createHighlightersDump$lambda$2(RangeHighlighter it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = HighlighterTagPrinter.INSTANCE.getTagName(it);
            if (string == null) {
                string = "unknown";
            }
            return string;
        }

        public static final /* synthetic */ String access$getAdditionalText(Companion $this, RangeHighlighter highlighter) {
            return $this.getAdditionalText(highlighter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

