/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Set;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldNotContainCharSequence
extends BasicErrorMessageFactory {
    private ShouldNotContainCharSequence(String format, CharSequence actual, CharSequence sequence, ComparisonStrategy comparisonStrategy) {
        super(format, actual, sequence, comparisonStrategy);
    }

    private ShouldNotContainCharSequence(String format, CharSequence actual, CharSequence[] values, Set<? extends CharSequence> found, ComparisonStrategy comparisonStrategy) {
        super(format, actual, values, found, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldNotContain(CharSequence actual, CharSequence sequence, ComparisonStrategy comparisonStrategy) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain:%n  %s%n%s", actual, sequence, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldNotContain(CharSequence actual, CharSequence sequence) {
        return ShouldNotContainCharSequence.shouldNotContain(actual, sequence, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContain(Throwable actual, CharSequence sequence) {
        String format = "%nExpecting throwable message:%n  %s%nnot to contain:%n  %s%nbut did:%n%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual));
        return new ShouldNotContainCharSequence(format, actual.getMessage(), sequence, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContain(Throwable actual, CharSequence[] sequence, Set<? extends CharSequence> found) {
        String format = "%nExpecting throwable message:%n  %s%nnot to contain:%n  %s%nbut found:%n  %s%n%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual));
        return new ShouldNotContainCharSequence(format, actual.getMessage(), sequence, found, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContain(CharSequence actual, CharSequence[] values, Set<? extends CharSequence> found, ComparisonStrategy comparisonStrategy) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain:%n  %s%nbut found:%n  %s%n%s", actual, values, found, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldNotContainIgnoringCase(CharSequence actual, CharSequence sequence) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain (ignoring case):%n  %s%n%s", actual, sequence, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldNotContainIgnoringCase(CharSequence actual, CharSequence[] sequences, Set<CharSequence> foundSequences) {
        return new ShouldNotContainCharSequence("%nExpecting actual:%n  %s%nnot to contain (ignoring case):%n  %s%nbut found:%n  %s%n%s", actual, sequences, foundSequences, StandardComparisonStrategy.instance());
    }
}

