/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.python.correctness;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.ml.inline.completion.python.correctness.PythonParserErrorMessages;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.psi.PyFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/inline/completion/python/correctness/PythonSyntaxErrorEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "<init>", "()V", "run", "", "Lcom/intellij/ml/inline/completion/features/correctness/SpecialRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "fileWithSuggestion", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "toCorrectnessError", "Lcom/intellij/ml/inline/completion/features/correctness/CorrectnessError;", "Lcom/intellij/psi/PsiErrorElement;", "rangeInFile", "intellij.fullLine.python"})
@SourceDebugExtension(value={"SMAP\nPythonInspectionBasedSemanticCheckers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonInspectionBasedSemanticCheckers.kt\ncom/intellij/ml/inline/completion/python/correctness/PythonSyntaxErrorEnrichmentTool\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n183#2,2:196\n808#3,11:198\n1617#3,9:209\n1869#3:218\n1870#3:220\n1626#3:221\n1#4:219\n*S KotlinDebug\n*F\n+ 1 PythonInspectionBasedSemanticCheckers.kt\ncom/intellij/ml/inline/completion/python/correctness/PythonSyntaxErrorEnrichmentTool\n*L\n170#1:196,2\n175#1:198,11\n175#1:209,9\n175#1:218\n175#1:220\n175#1:221\n175#1:219\n*E\n"})
public final class PythonSyntaxErrorEnrichmentTool
extends RawEnrichmentTool {
    @NotNull
    public static final PythonSyntaxErrorEnrichmentTool INSTANCE = new PythonSyntaxErrorEnrichmentTool();

    private PythonSyntaxErrorEnrichmentTool() {
        super(EnrichmentTool.Aspect.RED_CODE_ANALYSIS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SpecialRange> run(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull PsiFile fileWithSuggestion, @NotNull TextRange suggestionRange) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        PsiElement prevLeaf;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)fileWithSuggestion, (String)"fileWithSuggestion");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        if (!(originalFile instanceof PyFile)) {
            return CollectionsKt.emptyList();
        }
        PsiElement startBoundaryElement = fileWithSuggestion.findElementAt(suggestionRange.getStartOffset());
        PsiElement psiElement = startBoundaryElement;
        if (psiElement != null && (psiElement = PsiTreeUtilKt.getPrevLeafs((PsiElement)psiElement)) != null) {
            Object v1;
            block8: {
                PsiElement $this$firstOrNull$iv = psiElement;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof PsiWhiteSpace) && !(it instanceof PsiComment))) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            v2 = v1;
        } else {
            v2 = prevLeaf = null;
        }
        if (prevLeaf instanceof PsiErrorElement) {
            return CollectionsKt.listOfNotNull((Object)this.toCorrectnessError((PsiErrorElement)prevLeaf, suggestionRange, suggestionRange, suggestion2));
        }
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)fileWithSuggestion)).onRange(suggestionRange);
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"onRange(...)");
        Iterable $this$filterIsInstance$iv = (Iterable)syntaxTraverser;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$firstOrNull = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiErrorElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CorrectnessError it$iv$iv;
            TextRange range;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiErrorElement it = (PsiErrorElement)element$iv$iv;
            boolean bl2 = false;
            TextRange textRange = suggestionRange.intersection(new TextRange(it.getTextOffset(), Integer.MAX_VALUE));
            if (textRange == null) {
                textRange = suggestionRange;
            }
            if (INSTANCE.toCorrectnessError(it, range = textRange, suggestionRange, suggestion2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final CorrectnessError toCorrectnessError(PsiErrorElement $this$toCorrectnessError, TextRange rangeInFile, TextRange suggestionRange, String suggestion2) {
        TextRange textRange = this.getLocationInSuggestion(rangeInFile, suggestionRange.getStartOffset(), suggestion2);
        if (textRange == null) {
            textRange = new TextRange(0, suggestion2.length());
        }
        TextRange range = textRange;
        String string = $this$toCorrectnessError.getErrorDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorDescription(...)");
        PythonParserErrorMessages message = PythonParserErrorMessages.Companion.fromMessage(string);
        if (message == PythonParserErrorMessages.PPE_UNKNOWN) {
            return null;
        }
        return new CorrectnessError(range, Severity.CRITICAL, message.name());
    }
}

