/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.conpty;

import com.pty4j.util.PtyUtil;
import com.pty4j.windows.conpty.WinEx;
import com.pty4j.windows.conpty.WindowsVersionImpl;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012J0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0013"}, d2={"Lcom/pty4j/windows/conpty/ConPtyLibrary;", "Lcom/sun/jna/Library;", "CreatePseudoConsole", "Lcom/sun/jna/platform/win32/WinNT$HRESULT;", "size", "Lcom/pty4j/windows/conpty/WinEx$COORDByValue;", "hInput", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "hOutput", "dwFlags", "Lcom/sun/jna/platform/win32/WinDef$DWORD;", "phPC", "Lcom/pty4j/windows/conpty/WinEx$HPCONByReference;", "ClosePseudoConsole", "", "hPC", "Lcom/pty4j/windows/conpty/WinEx$HPCON;", "ResizePseudoConsole", "Companion", "pty4j"})
public interface ConPtyLibrary
extends Library {
    @NotNull
    public static final Companion Companion = com.pty4j.windows.conpty.ConPtyLibrary$Companion.$$INSTANCE;

    @NotNull
    public WinNT.HRESULT CreatePseudoConsole(@NotNull WinEx.COORDByValue var1, @NotNull WinNT.HANDLE var2, @NotNull WinNT.HANDLE var3, @NotNull WinDef.DWORD var4, @NotNull WinEx.HPCONByReference var5);

    public void ClosePseudoConsole(@NotNull WinEx.HPCON var1);

    @NotNull
    public WinNT.HRESULT ResizePseudoConsole(@NotNull WinEx.HPCON var1, @NotNull WinEx.COORDByValue var2);

    @NotNull
    public static ConPtyLibrary getInstance() {
        return Companion.getInstance();
    }

    public static boolean isBundled() {
        return Companion.isBundled();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u000f\u0010\u0012R'\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/pty4j/windows/conpty/ConPtyLibrary$Companion;", "", "<init>", "()V", "CONPTY", "", "KERNEL32", "DISABLE_BUNDLED_CONPTY_PROP_NAME", "BUNDLED_CONPTY_OS_MIN_BUILD_NUMBER", "", "instance", "Lcom/pty4j/windows/conpty/ConPtyLibrary;", "getInstance$annotations", "getInstance", "()Lcom/pty4j/windows/conpty/ConPtyLibrary;", "isBundled", "", "isBundled$annotations", "()Z", "libraryWithName", "Lkotlin/Pair;", "getLibraryWithName", "()Lkotlin/Pair;", "libraryWithName$delegate", "Lkotlin/Lazy;", "loadLibrary", "name", "pty4j"})
    @SourceDebugExtension(value={"SMAP\nConPtyLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConPtyLibrary.kt\ncom/pty4j/windows/conpty/ConPtyLibrary$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/pty4j/util/LoggerKt\n*L\n1#1,76:1\n1#2:77\n6#3:78\n6#3:79\n6#3:80\n6#3:81\n*S KotlinDebug\n*F\n+ 1 ConPtyLibrary.kt\ncom/pty4j/windows/conpty/ConPtyLibrary$Companion\n*L\n71#1:78\n50#1:79\n55#1:80\n63#1:81\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String CONPTY = "conpty.dll";
        @NotNull
        private static final String KERNEL32 = "kernel32";
        @NotNull
        private static final String DISABLE_BUNDLED_CONPTY_PROP_NAME = "com.pty4j.windows.disable.bundled.conpty";
        private static final int BUNDLED_CONPTY_OS_MIN_BUILD_NUMBER = 19041;
        @NotNull
        private static final Lazy<Pair<ConPtyLibrary, String>> libraryWithName$delegate;

        private Companion() {
        }

        @NotNull
        public final ConPtyLibrary getInstance() {
            return (ConPtyLibrary)this.getLibraryWithName().getFirst();
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public final boolean isBundled() {
            Object object;
            Object object2 = this;
            try {
                Companion $this$_get_isBundled__u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)(!Intrinsics.areEqual((Object)$this$_get_isBundled__u24lambda_u240.getLibraryWithName().getSecond(), (Object)KERNEL32) ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = false;
            return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
        }

        @JvmStatic
        public static /* synthetic */ void isBundled$annotations() {
        }

        private final Pair<ConPtyLibrary, String> getLibraryWithName() {
            Lazy<Pair<ConPtyLibrary, String>> lazy = libraryWithName$delegate;
            return (Pair)lazy.getValue();
        }

        private final Pair<ConPtyLibrary, String> loadLibrary(String name) {
            ConPtyLibrary library = (ConPtyLibrary)Native.load((String)name, ConPtyLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
            String type = Intrinsics.areEqual((Object)name, (Object)KERNEL32) ? "system" : "bundled";
            boolean $i$f$logger = false;
            Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
            logger.info("Loaded " + type + " ConPTY from " + name);
            return TuplesKt.to((Object)library, (Object)name);
        }

        private static final Pair libraryWithName_delegate$lambda$1() {
            Pair<ConPtyLibrary, String> pair;
            if (Boolean.parseBoolean(System.getProperty(DISABLE_BUNDLED_CONPTY_PROP_NAME))) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.warn("Bundled conpty.dll is disabled by 'com.pty4j.windows.disable.bundled.conpty'");
                return $$INSTANCE.loadLibrary(KERNEL32);
            }
            WindowsVersionImpl osVersion = new WindowsVersionImpl();
            if (!osVersion.isGreaterThanOrEqualTo(19041)) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.info("Bundled conpty.dll is disabled: OS build number requirement not met " + osVersion);
                return $$INSTANCE.loadLibrary(KERNEL32);
            }
            try {
                File file = PtyUtil.resolveNativeFile(CONPTY);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveNativeFile(...)");
                File bundledConptyDll = file;
                String string = bundledConptyDll.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                pair = $$INSTANCE.loadLibrary(string);
            }
            catch (Throwable e) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(ConPtyLibrary.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.warn("Failed to load bundled conpty.dll, fallback to kernel32", e);
                pair = $$INSTANCE.loadLibrary(KERNEL32);
            }
            return pair;
        }

        static {
            $$INSTANCE = new Companion();
            libraryWithName$delegate = LazyKt.lazy(Companion::libraryWithName_delegate$lambda$1);
        }
    }
}

