/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtil;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.PythonUiService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/editor/inspections/quickfix/StatementEffectSplitCellQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "startInWriteAction", "", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.jupyter.py"})
public final class StatementEffectSplitCellQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return JupyterPyBundle.message("QFIX.split.cell", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return (PsiElement)currentFile;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> StatementEffectSplitCellQuickFix.applyFix$lambda$0(descriptor, project));
    }

    private static final Unit applyFix$lambda$0(ProblemDescriptor $descriptor, Project $project) {
        PsiElement element = $descriptor.getPsiElement();
        Editor editor = PythonUiService.getInstance().openTextEditor($project, element);
        Editor editor2 = PythonUiService.getInstance().openTextEditor($project, element);
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"openTextEditor(...)");
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(editor2);
        NotebookCellLines.Interval cell = (NotebookCellLines.Interval)cellLines.intervalsIterator(editor.getCaretModel().getLogicalPosition().line).next();
        Intrinsics.checkNotNull((Object)editor);
        NotebookCellLinesEditHelper helper = NotebookCellLinesEditHelper.Companion.getOrNull(editor);
        Intrinsics.checkNotNull((Object)element);
        NotebookCellLinesActionUtil.INSTANCE.trySplitCellAtOffset(editor, cell, PsiTreeUtilKt.getEndOffset((PsiElement)element), cellLines, helper);
        return Unit.INSTANCE;
    }
}

