/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUtils;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.CustomRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogServerMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataPersistence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ValidationRulesPersistedStorage
implements IntellijValidationRulesStorage {
    private static final Logger LOG = Logger.getInstance(ValidationRulesPersistedStorage.class);
    protected volatile Map<String, EventGroupRules> eventsValidators;
    @NotNull
    private final Semaphore mySemaphore;
    @NotNull
    private final String myRecorderId;
    @Nullable
    private String myVersion;
    @NotNull
    private final EventLogMetadataPersistence myMetadataPersistence;
    @NotNull
    private final EventLogMetadataLoader myMetadataLoader;
    @NotNull
    private final AtomicBoolean myIsInitialized;
    @NotNull
    private final EventLogSystemCollector eventLogSystemCollector;

    ValidationRulesPersistedStorage(@NotNull String recorderId) {
        if (recorderId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(0);
        }
        this.eventsValidators = Map.of();
        this.myIsInitialized = new AtomicBoolean(false);
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myMetadataPersistence = new EventLogMetadataPersistence(recorderId);
        this.myMetadataLoader = new EventLogServerMetadataLoader(recorderId);
        this.eventLogSystemCollector = StatisticsEventLogProviderUtil.getEventLogProvider(this.myRecorderId).getEventLogSystemLogger$intellij_platform_statistics();
        this.myVersion = this.loadValidatorsFromLocalCache();
    }

    @TestOnly
    protected ValidationRulesPersistedStorage(@NotNull String recorderId, @NotNull EventLogMetadataPersistence persistence, @NotNull EventLogMetadataLoader loader) {
        if (recorderId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(1);
        }
        if (persistence == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(2);
        }
        if (loader == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(3);
        }
        this.eventsValidators = Map.of();
        this.myIsInitialized = new AtomicBoolean(false);
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myMetadataPersistence = persistence;
        this.myMetadataLoader = loader;
        this.eventLogSystemCollector = StatisticsEventLogProviderUtil.getEventLogProvider(this.myRecorderId).getEventLogSystemLogger$intellij_platform_statistics();
        this.myVersion = this.loadValidatorsFromLocalCache();
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        if (groupId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(4);
        }
        return this.eventsValidators.get(groupId);
    }

    @Nullable
    private String loadValidatorsFromLocalCache() {
        String rawEventsScheme = this.myMetadataPersistence.getCachedEventsScheme();
        if (rawEventsScheme != null) {
            try {
                String newVersion = this.updateValidators(rawEventsScheme);
                this.eventLogSystemCollector.logMetadataLoaded(newVersion);
                return newVersion;
            }
            catch (EventLogMetadataParseException e) {
                this.eventLogSystemCollector.logMetadataLoadFailed((EventLogMetadataUpdateError)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String updateValidators(@NotNull String rawEventsScheme) throws EventLogMetadataParseException {
        if (rawEventsScheme == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(5);
        }
        this.mySemaphore.down();
        try {
            EventGroupRemoteDescriptors groups = EventLogMetadataUtils.parseGroupRemoteDescriptors(rawEventsScheme);
            EventLogBuild build = EventLogBuild.fromString((String)EventLogConfiguration.getInstance().getBuild());
            Map<String, EventGroupRules> result = this.createValidators(build, groups);
            this.myIsInitialized.set(false);
            this.eventsValidators = Map.copyOf(result);
            this.myIsInitialized.set(true);
            String string = groups.version;
            return string;
        }
        finally {
            this.mySemaphore.up();
        }
    }

    @Override
    public void update() {
        EventLogConfigOptionsService.getInstance().updateOptions(this.myRecorderId, this.myMetadataLoader);
        long lastModifiedLocally = this.myMetadataPersistence.getLastModified();
        long lastModifiedOnServer = this.myMetadataLoader.getLastModifiedOnServer();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading events scheme, last modified cached=" + lastModifiedLocally + ", last modified on the server=" + lastModifiedOnServer);
        }
        try {
            if (lastModifiedOnServer <= 0L || lastModifiedOnServer > lastModifiedLocally || this.isUnreachable()) {
                String rawEventsSchemeFromServer = this.myMetadataLoader.loadMetadataFromServer();
                String version = this.updateValidators(rawEventsSchemeFromServer);
                this.myMetadataPersistence.cacheEventsScheme(rawEventsSchemeFromServer, lastModifiedOnServer);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update local events scheme, last modified cached=" + this.myMetadataPersistence.getLastModified());
                }
                if (version != null && !StringUtil.equals((CharSequence)version, (CharSequence)this.myVersion)) {
                    this.myVersion = version;
                    this.eventLogSystemCollector.logMetadataUpdated(this.myVersion);
                }
            }
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            this.eventLogSystemCollector.logMetadataUpdateFailed((EventLogMetadataUpdateError)e);
        }
    }

    @Override
    public void reload() {
        this.myVersion = this.loadValidatorsFromLocalCache();
    }

    public boolean isUnreachable() {
        return !this.myIsInitialized.get();
    }

    @NotNull
    protected Map<String, EventGroupRules> createValidators(@Nullable EventLogBuild build, @NotNull EventGroupRemoteDescriptors groups) {
        if (groups == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(6);
        }
        GlobalRulesHolder globalRulesHolder = new GlobalRulesHolder(groups.rules);
        return ValidationRulesPersistedStorage.createValidators(build, groups, globalRulesHolder, this.myRecorderId);
    }

    @NotNull
    public static Map<String, EventGroupRules> createValidators(@Nullable EventLogBuild build, @NotNull EventGroupRemoteDescriptors groups, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull String recorderId) {
        if (groups == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(7);
        }
        if (globalRulesHolder == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(8);
        }
        if (recorderId == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(9);
        }
        ValidationSimpleRuleFactory ruleFactory = new ValidationSimpleRuleFactory((UtilRuleProducer)new CustomRuleProducer(recorderId));
        Map<String, EventGroupRules> map = groups.groups.stream().filter(group -> EventGroupFilterRules.create((EventGroupRemoteDescriptors.EventGroupRemoteDescriptor)group, (EventLogBuildParser)EventLogBuild.EVENT_LOG_BUILD_PRODUCER).accepts((Comparable)build)).collect(Collectors.toMap(group -> group.id, group -> EventGroupRules.create((EventGroupRemoteDescriptors.EventGroupRemoteDescriptor)group, (GlobalRulesHolder)globalRulesHolder, (ValidationSimpleRuleFactory)ruleFactory, FeatureUsageData.Companion.getPlatformDataKeys())));
        if (map == null) {
            ValidationRulesPersistedStorage.$$$reportNull$$$0(10);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawEventsScheme";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalRulesHolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/ValidationRulesPersistedStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/ValidationRulesPersistedStorage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGroupRules";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateValidators";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createValidators";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

