/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFieldName;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0005\r\u000e\u000f\u0010\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "name", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "ValidatedByAllowedValues", "ValidatedByEnum", "ValidatedByCustomValidationRule", "ValidatedByRegexp", "ValidatedByInlineRegexp", "intellij.platform.statistics"})
public abstract class StringEventField
extends PrimitiveEventField<String> {
    @NotNull
    private final String name;

    public StringEventField(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null, 1, null);
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        if (value != null) {
            fuData.addData(this.getName(), value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J/\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/StringEventField$ValidatedByAllowedValues;", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "name", "", "allowedValues", "", "description", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getAllowedValues", "()Ljava/util/List;", "getDescription", "validationRule", "getValidationRule", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class ValidatedByAllowedValues
    extends StringEventField {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> allowedValues;
        @Nullable
        private final String description;

        public ValidatedByAllowedValues(@EventFieldName @NonNls @NotNull String name, @NotNull List<String> allowedValues, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
            super(name);
            this.name = name;
            this.allowedValues = allowedValues;
            this.description = description;
        }

        public /* synthetic */ ValidatedByAllowedValues(String string, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, list, string2);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        public ValidatedByAllowedValues(@NotNull String name, @NotNull List<String> allowedValues) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
            this(name, allowedValues, null);
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{enum:" + CollectionsKt.joinToString$default((Iterable)this.allowedValues, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + "}"));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<String> component2() {
            return this.allowedValues;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ValidatedByAllowedValues copy(@EventFieldName @NonNls @NotNull String name, @NotNull List<String> allowedValues, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(allowedValues, (String)"allowedValues");
            return new ValidatedByAllowedValues(name, allowedValues, description);
        }

        public static /* synthetic */ ValidatedByAllowedValues copy$default(ValidatedByAllowedValues validatedByAllowedValues, String string, List list, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByAllowedValues.name;
            }
            if ((n & 2) != 0) {
                list = validatedByAllowedValues.allowedValues;
            }
            if ((n & 4) != 0) {
                string2 = validatedByAllowedValues.description;
            }
            return validatedByAllowedValues.copy(string, list, string2);
        }

        @NotNull
        public String toString() {
            return "ValidatedByAllowedValues(name=" + this.name + ", allowedValues=" + this.allowedValues + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.allowedValues).hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByAllowedValues)) {
                return false;
            }
            ValidatedByAllowedValues validatedByAllowedValues = (ValidatedByAllowedValues)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByAllowedValues.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allowedValues, validatedByAllowedValues.allowedValues)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)validatedByAllowedValues.description);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0001\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/StringEventField$ValidatedByCustomValidationRule;", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "name", "", "customValidationRule", "Ljava/lang/Class;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "description", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getCustomValidationRule", "()Ljava/lang/Class;", "getDescription", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class ValidatedByCustomValidationRule
    extends StringEventField {
        @NotNull
        private final String name;
        @NotNull
        private final Class<? extends CustomValidationRule> customValidationRule;
        @Nullable
        private final String description;

        @JvmOverloads
        public ValidatedByCustomValidationRule(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull Class<? extends CustomValidationRule> customValidationRule, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(customValidationRule, (String)"customValidationRule");
            super(name);
            this.name = name;
            this.customValidationRule = customValidationRule;
            this.description = description;
        }

        public /* synthetic */ ValidatedByCustomValidationRule(String string, Class clazz, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(string, clazz, string2);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final Class<? extends CustomValidationRule> getCustomValidationRule() {
            return this.customValidationRule;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{util#" + CustomValidationRule.getRuleId(this.customValidationRule) + "}"));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Class<? extends CustomValidationRule> component2() {
            return this.customValidationRule;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ValidatedByCustomValidationRule copy(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull Class<? extends CustomValidationRule> customValidationRule, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(customValidationRule, (String)"customValidationRule");
            return new ValidatedByCustomValidationRule(name, customValidationRule, description);
        }

        public static /* synthetic */ ValidatedByCustomValidationRule copy$default(ValidatedByCustomValidationRule validatedByCustomValidationRule, String string, Class clazz, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByCustomValidationRule.name;
            }
            if ((n & 2) != 0) {
                clazz = validatedByCustomValidationRule.customValidationRule;
            }
            if ((n & 4) != 0) {
                string2 = validatedByCustomValidationRule.description;
            }
            return validatedByCustomValidationRule.copy(string, clazz, string2);
        }

        @NotNull
        public String toString() {
            return "ValidatedByCustomValidationRule(name=" + this.name + ", customValidationRule=" + this.customValidationRule + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.customValidationRule.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByCustomValidationRule)) {
                return false;
            }
            ValidatedByCustomValidationRule validatedByCustomValidationRule = (ValidatedByCustomValidationRule)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByCustomValidationRule.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.customValidationRule, validatedByCustomValidationRule.customValidationRule)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)validatedByCustomValidationRule.description);
        }

        @JvmOverloads
        public ValidatedByCustomValidationRule(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull Class<? extends CustomValidationRule> customValidationRule) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(customValidationRule, (String)"customValidationRule");
            this(name, customValidationRule, null, 4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/StringEventField$ValidatedByEnum;", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "name", "", "enumRef", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getEnumRef", "getDescription", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class ValidatedByEnum
    extends StringEventField {
        @NotNull
        private final String name;
        @NotNull
        private final String enumRef;
        @Nullable
        private final String description;

        public ValidatedByEnum(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String enumRef, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)enumRef, (String)"enumRef");
            super(name);
            this.name = name;
            this.enumRef = enumRef;
            this.description = description;
        }

        public /* synthetic */ ValidatedByEnum(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String getEnumRef() {
            return this.enumRef;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{enum#" + this.enumRef + "}"));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.enumRef;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ValidatedByEnum copy(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String enumRef, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)enumRef, (String)"enumRef");
            return new ValidatedByEnum(name, enumRef, description);
        }

        public static /* synthetic */ ValidatedByEnum copy$default(ValidatedByEnum validatedByEnum, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByEnum.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByEnum.enumRef;
            }
            if ((n & 4) != 0) {
                string3 = validatedByEnum.description;
            }
            return validatedByEnum.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByEnum(name=" + this.name + ", enumRef=" + this.enumRef + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.enumRef.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByEnum)) {
                return false;
            }
            ValidatedByEnum validatedByEnum = (ValidatedByEnum)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByEnum.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.enumRef, (Object)validatedByEnum.enumRef)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)validatedByEnum.description);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/StringEventField$ValidatedByInlineRegexp;", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "name", "", "regexp", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRegexp", "getDescription", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class ValidatedByInlineRegexp
    extends StringEventField {
        @NotNull
        private final String name;
        @NotNull
        private final String regexp;
        @Nullable
        private final String description;

        @JvmOverloads
        public ValidatedByInlineRegexp(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String regexp, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            super(name);
            this.name = name;
            this.regexp = regexp;
            this.description = description;
        }

        public /* synthetic */ ValidatedByInlineRegexp(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String getRegexp() {
            return this.regexp;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{regexp:" + this.regexp + "}"));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.regexp;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ValidatedByInlineRegexp copy(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String regexp, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            return new ValidatedByInlineRegexp(name, regexp, description);
        }

        public static /* synthetic */ ValidatedByInlineRegexp copy$default(ValidatedByInlineRegexp validatedByInlineRegexp, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByInlineRegexp.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByInlineRegexp.regexp;
            }
            if ((n & 4) != 0) {
                string3 = validatedByInlineRegexp.description;
            }
            return validatedByInlineRegexp.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByInlineRegexp(name=" + this.name + ", regexp=" + this.regexp + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.regexp.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByInlineRegexp)) {
                return false;
            }
            ValidatedByInlineRegexp validatedByInlineRegexp = (ValidatedByInlineRegexp)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByInlineRegexp.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.regexp, (Object)validatedByInlineRegexp.regexp)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)validatedByInlineRegexp.description);
        }

        @JvmOverloads
        public ValidatedByInlineRegexp(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String regexp) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            this(name, regexp, null, 4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/StringEventField$ValidatedByRegexp;", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "name", "", "regexpRef", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRegexpRef", "getDescription", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class ValidatedByRegexp
    extends StringEventField {
        @NotNull
        private final String name;
        @NotNull
        private final String regexpRef;
        @Nullable
        private final String description;

        @JvmOverloads
        public ValidatedByRegexp(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String regexpRef, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
            super(name);
            this.name = name;
            this.regexpRef = regexpRef;
            this.description = description;
        }

        public /* synthetic */ ValidatedByRegexp(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String getRegexpRef() {
            return this.regexpRef;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public List<String> getValidationRule() {
            return CollectionsKt.listOf((Object)("{regexp#" + this.regexpRef + "}"));
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.regexpRef;
        }

        @Nullable
        public final String component3() {
            return this.description;
        }

        @NotNull
        public final ValidatedByRegexp copy(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String regexpRef, @NonNls @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
            return new ValidatedByRegexp(name, regexpRef, description);
        }

        public static /* synthetic */ ValidatedByRegexp copy$default(ValidatedByRegexp validatedByRegexp, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = validatedByRegexp.name;
            }
            if ((n & 2) != 0) {
                string2 = validatedByRegexp.regexpRef;
            }
            if ((n & 4) != 0) {
                string3 = validatedByRegexp.description;
            }
            return validatedByRegexp.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ValidatedByRegexp(name=" + this.name + ", regexpRef=" + this.regexpRef + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.regexpRef.hashCode();
            result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValidatedByRegexp)) {
                return false;
            }
            ValidatedByRegexp validatedByRegexp = (ValidatedByRegexp)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)validatedByRegexp.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.regexpRef, (Object)validatedByRegexp.regexpRef)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)validatedByRegexp.description);
        }

        @JvmOverloads
        public ValidatedByRegexp(@EventFieldName @NonNls @NotNull String name, @NonNls @NotNull String regexpRef) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)regexpRef, (String)"regexpRef");
            this(name, regexpRef, null, 4, null);
        }
    }
}

