/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.memory.agent;

import com.intellij.memory.agent.AgentExtractor;
import com.intellij.memory.agent.AllocationListener;
import com.intellij.memory.agent.ArrayOfListeners;
import com.intellij.memory.agent.IdeaNativeAgentProxy;
import com.intellij.memory.agent.MemoryAgentExecutionException;
import java.io.File;
import java.lang.reflect.Array;
import java.util.concurrent.Callable;

public class MemoryAgent {
    private static final String allocationSamplingIsNotSupportedMessage = "Allocation sampling is not supported for this version of jdk";
    private static final String agentLibraryWasNotLoadedMessage = "Agent library wasn't loaded";
    private static final String failedToCallNativeMethodMessage = "Failed to call native method";
    private final IdeaNativeAgentProxy proxy = new IdeaNativeAgentProxy();
    private ArrayOfListeners listeners = null;

    private MemoryAgent() {
    }

    public static MemoryAgent get() {
        if (LazyHolder.loadingException != null) {
            return null;
        }
        return LazyHolder.INSTANCE;
    }

    public static Exception getLoadingException() {
        return LazyHolder.loadingException;
    }

    public synchronized <T> T getFirstReachableObject(Object object, Class<T> clazz) throws MemoryAgentExecutionException {
        return (T)MemoryAgent.getResult(MemoryAgent.callProxyMethod(() -> this.proxy.getFirstReachableObject(object, clazz)));
    }

    public synchronized <T> T[] getAllReachableObjects(Object object, Class<T> clazz) throws MemoryAgentExecutionException {
        Object[] objectArray = (Object[])MemoryAgent.getResult(MemoryAgent.callProxyMethod(() -> this.proxy.getAllReachableObjects(object, clazz)));
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        return objectArray2;
    }

    public synchronized void addAllocationListener(AllocationListener allocationListener, Class<?> ... classArray) throws MemoryAgentExecutionException {
        if (this.listeners == null) {
            this.listeners = new ArrayOfListeners();
            if (!MemoryAgent.callProxyMethod(() -> IdeaNativeAgentProxy.initArrayOfListeners(this.listeners)).booleanValue()) {
                throw new MemoryAgentExecutionException(allocationSamplingIsNotSupportedMessage);
            }
        }
        this.listeners.add(allocationListener, classArray);
    }

    public synchronized void addAllocationListener(Class<?> clazz, AllocationListener allocationListener) throws MemoryAgentExecutionException {
        this.addAllocationListener(allocationListener, clazz);
    }

    public synchronized void addAllocationListener(AllocationListener allocationListener) throws MemoryAgentExecutionException {
        this.addAllocationListener(allocationListener, new Class[0]);
    }

    public synchronized void removeAllocationListener(AllocationListener allocationListener) {
        if (this.listeners != null) {
            this.listeners.remove(allocationListener);
        }
    }

    public void setHeapSamplingInterval(long l) throws MemoryAgentExecutionException {
        if (!MemoryAgent.callProxyMethod(() -> IdeaNativeAgentProxy.setHeapSamplingInterval(l)).booleanValue()) {
            throw new MemoryAgentExecutionException(allocationSamplingIsNotSupportedMessage);
        }
    }

    public void enableAllocationSampling() throws MemoryAgentExecutionException {
        if (!MemoryAgent.callProxyMethod(IdeaNativeAgentProxy::enableAllocationSampling).booleanValue()) {
            throw new MemoryAgentExecutionException(allocationSamplingIsNotSupportedMessage);
        }
    }

    public void disableAllocationSampling() throws MemoryAgentExecutionException {
        MemoryAgent.callProxyMethod(IdeaNativeAgentProxy::disableAllocationSampling);
    }

    private static Object getResult(Object object) {
        return ((Object[])object)[1];
    }

    private static <T> T callProxyMethod(Callable<T> callable) throws MemoryAgentExecutionException {
        if (!IdeaNativeAgentProxy.isLoaded()) {
            throw new MemoryAgentExecutionException(agentLibraryWasNotLoadedMessage);
        }
        try {
            return callable.call();
        }
        catch (Exception exception) {
            throw new MemoryAgentExecutionException(failedToCallNativeMethodMessage, exception);
        }
    }

    private static class LazyHolder {
        static final MemoryAgent INSTANCE = new MemoryAgent();
        static Exception loadingException = null;

        private LazyHolder() {
        }

        static {
            try {
                File file = AgentExtractor.extract(new File(System.getProperty("java.io.tmpdir")));
                System.load(file.getAbsolutePath());
            }
            catch (Exception exception) {
                loadingException = exception;
            }
        }
    }
}

