/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace;

import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.collection.SimpleArray;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class StacktraceFrame {
    private final SimpleArray<IItem> items;
    private final IMCFrame frame;
    private final StacktraceModel.Branch branch;
    private final int indexInBranch;

    StacktraceFrame(IItem[] items, IMCFrame frame, StacktraceModel.Branch branch, int indexInBranch) {
        this(new SimpleArray<IItem>(items, items.length), frame, branch, indexInBranch);
    }

    StacktraceFrame(SimpleArray<IItem> items, IMCFrame frame, StacktraceModel.Branch branch, int indexInBranch) {
        this.items = items;
        this.frame = frame;
        this.branch = branch;
        this.indexInBranch = indexInBranch;
    }

    public SimpleArray<IItem> getItems() {
        return this.items;
    }

    public IMCFrame getFrame() {
        return this.frame;
    }

    public StacktraceModel.Branch getBranch() {
        return this.branch;
    }

    public int getIndexInBranch() {
        return this.indexInBranch;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.frame == null ? 0 : this.frame.hashCode());
        result = 31 * result + this.indexInBranch;
        result = 31 * result + (this.items == null ? 0 : this.items.size());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StacktraceFrame other = (StacktraceFrame)obj;
        if (this.branch == null && other.branch != null) {
            return false;
        }
        if (this.frame == null && other.frame != null) {
            return false;
        }
        if (this.indexInBranch != other.indexInBranch) {
            return false;
        }
        if (this.items == null || other.items == null) {
            return false;
        }
        return this.items.size() == other.items.size();
    }
}

