/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.widget;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.AttachProfilerUtilsKt;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.async.StartedExternallyProcess;
import com.intellij.profiler.ultimate.widget.JavaConsoleWithProfilerWidget;
import com.intellij.profiler.ultimate.widget.WidgetMode;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0017J\u0012\u0010\u001b\u001a\u00020\u001a2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015J\u0014\u0010\u001c\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\b\u0012\u00060\u000bR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "myBindings", "", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager$MyProcessWidgetBinding;", "addWidgetToConsole", "Lcom/intellij/execution/ui/ConsoleView;", "configuration", "console", "widgetMode", "Lcom/intellij/profiler/ultimate/widget/WidgetMode;", "registerProfilerProcess", "", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "findWidget", "Lcom/intellij/profiler/ultimate/widget/JavaConsoleWithProfilerWidget;", "process", "removeConsole", "", "processDetached", "checkProcess", "MyProcessWidgetBinding", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJavaProfilerConsoleWidgetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaProfilerConsoleWidgetManager.kt\ncom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n1#2:85\n14#3:86\n*S KotlinDebug\n*F\n+ 1 JavaProfilerConsoleWidgetManager.kt\ncom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager\n*L\n82#1:86\n*E\n"})
public final class JavaProfilerConsoleWidgetManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Map<RunConfigurationBase<?>, MyProcessWidgetBinding> myBindings;
    @NotNull
    private static final Logger LOG;

    public JavaProfilerConsoleWidgetManager(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.myBindings = new LinkedHashMap();
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @NotNull
    public final ConsoleView addWidgetToConsole(@NotNull RunConfigurationBase<?> configuration, @NotNull ConsoleView console, @NotNull WidgetMode widgetMode) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        Intrinsics.checkNotNullParameter((Object)((Object)widgetMode), (String)"widgetMode");
        JavaConsoleWithProfilerWidget consoleWithWidget = new JavaConsoleWithProfilerWidget(console, configuration, widgetMode, this.scope);
        MyProcessWidgetBinding myProcessWidgetBinding = this.myBindings.computeIfAbsent(configuration, arg_0 -> JavaProfilerConsoleWidgetManager.addWidgetToConsole$lambda$1(arg_0 -> JavaProfilerConsoleWidgetManager.addWidgetToConsole$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)myProcessWidgetBinding, (String)"computeIfAbsent(...)");
        MyProcessWidgetBinding binding = myProcessWidgetBinding;
        binding.setWidget(consoleWithWidget);
        return consoleWithWidget;
    }

    public final boolean registerProfilerProcess(@NotNull RunConfigurationBase<?> configuration, @NotNull JavaProfilerProcess<?> profilerProcess) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        MyProcessWidgetBinding myProcessWidgetBinding = this.myBindings.computeIfAbsent(configuration, arg_0 -> JavaProfilerConsoleWidgetManager.registerProfilerProcess$lambda$3(arg_0 -> JavaProfilerConsoleWidgetManager.registerProfilerProcess$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)myProcessWidgetBinding, (String)"computeIfAbsent(...)");
        MyProcessWidgetBinding binding = myProcessWidgetBinding;
        binding.setProfilerProcess(profilerProcess);
        if (profilerProcess.getTargetProcess() instanceof AttachableTargetProcess) {
            AttachProfilerUtilsKt.registerRunningProfilerProcess((ProfilerProcess)((ProfilerProcess)profilerProcess));
        }
        return this.checkProcess(profilerProcess);
    }

    @Nullable
    public final JavaConsoleWithProfilerWidget findWidget(@NotNull JavaProfilerProcess<?> process) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(process, (String)"process");
            Iterable iterable = this.myBindings.values();
            for (Object t : iterable) {
                MyProcessWidgetBinding it = (MyProcessWidgetBinding)t;
                boolean bl = false;
                if (!(it.getProfilerProcess() == process)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        MyProcessWidgetBinding myProcessWidgetBinding = v0;
        return myProcessWidgetBinding != null ? myProcessWidgetBinding.getWidget() : null;
    }

    public final void removeConsole(@NotNull JavaConsoleWithProfilerWidget console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        this.myBindings.values().removeIf(arg_0 -> JavaProfilerConsoleWidgetManager.removeConsole$lambda$6(arg_0 -> JavaProfilerConsoleWidgetManager.removeConsole$lambda$5(console, arg_0), arg_0));
    }

    public final void processDetached(@NotNull JavaProfilerProcess<?> process) {
        Intrinsics.checkNotNullParameter(process, (String)"process");
        this.myBindings.values().removeIf(arg_0 -> JavaProfilerConsoleWidgetManager.processDetached$lambda$8(arg_0 -> JavaProfilerConsoleWidgetManager.processDetached$lambda$7(process, arg_0), arg_0));
    }

    private final boolean checkProcess(JavaProfilerProcess<?> profilerProcess) {
        if (profilerProcess.getTargetProcess() instanceof StartedExternallyProcess) {
            LOG.info("Profiler widget for the external process is not available at the moment");
            return false;
        }
        return true;
    }

    private static final MyProcessWidgetBinding addWidgetToConsole$lambda$0(JavaProfilerConsoleWidgetManager this$0, RunConfigurationBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.new MyProcessWidgetBinding();
    }

    private static final MyProcessWidgetBinding addWidgetToConsole$lambda$1(Function1 $tmp0, Object p0) {
        return (MyProcessWidgetBinding)$tmp0.invoke(p0);
    }

    private static final MyProcessWidgetBinding registerProfilerProcess$lambda$2(JavaProfilerConsoleWidgetManager this$0, RunConfigurationBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.new MyProcessWidgetBinding();
    }

    private static final MyProcessWidgetBinding registerProfilerProcess$lambda$3(Function1 $tmp0, Object p0) {
        return (MyProcessWidgetBinding)$tmp0.invoke(p0);
    }

    private static final boolean removeConsole$lambda$5(JavaConsoleWithProfilerWidget $console, MyProcessWidgetBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $console == it.getWidget();
    }

    private static final boolean removeConsole$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean processDetached$lambda$7(JavaProfilerProcess $process, MyProcessWidgetBinding it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $process == it.getProfilerProcess();
    }

    private static final boolean processDetached$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JavaProfilerConsoleWidgetManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JavaProfilerConsoleWidgetManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nJavaProfilerConsoleWidgetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaProfilerConsoleWidgetManager.kt\ncom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,84:1\n30#2,2:85\n*S KotlinDebug\n*F\n+ 1 JavaProfilerConsoleWidgetManager.kt\ncom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager$Companion\n*L\n80#1:85,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JavaProfilerConsoleWidgetManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JavaProfilerConsoleWidgetManager> serviceClass$iv = JavaProfilerConsoleWidgetManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JavaProfilerConsoleWidgetManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R0\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager$MyProcessWidgetBinding;", "", "<init>", "(Lcom/intellij/profiler/ultimate/widget/JavaProfilerConsoleWidgetManager;)V", "process", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "profilerProcess", "getProfilerProcess", "()Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "setProfilerProcess", "(Lcom/intellij/profiler/ultimate/JavaProfilerProcess;)V", "consoleWithWidget", "Lcom/intellij/profiler/ultimate/widget/JavaConsoleWithProfilerWidget;", "widget", "getWidget", "()Lcom/intellij/profiler/ultimate/widget/JavaConsoleWithProfilerWidget;", "setWidget", "(Lcom/intellij/profiler/ultimate/widget/JavaConsoleWithProfilerWidget;)V", "intellij.profiler.ultimate"})
    private final class MyProcessWidgetBinding {
        @Nullable
        private JavaProfilerProcess<?> profilerProcess;
        @Nullable
        private JavaConsoleWithProfilerWidget widget;

        @Nullable
        public final JavaProfilerProcess<?> getProfilerProcess() {
            return this.profilerProcess;
        }

        public final void setProfilerProcess(@Nullable JavaProfilerProcess<?> process) {
            this.profilerProcess = process;
            JavaConsoleWithProfilerWidget consoleWithWidget = this.widget;
            if (process != null && JavaProfilerConsoleWidgetManager.this.checkProcess(process) && consoleWithWidget != null) {
                consoleWithWidget.initProcess(process);
            }
        }

        @Nullable
        public final JavaConsoleWithProfilerWidget getWidget() {
            return this.widget;
        }

        public final void setWidget(@Nullable JavaConsoleWithProfilerWidget consoleWithWidget) {
            this.widget = consoleWithWidget;
            JavaProfilerProcess<?> process = this.profilerProcess;
            if (consoleWithWidget != null && process != null && JavaProfilerConsoleWidgetManager.this.checkProcess(process)) {
                consoleWithWidget.initProcess(process);
            }
        }
    }
}

