/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.jmc;

import com.intellij.openapi.util.Predicates;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemConsumer;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.util.PredicateToolkit;

public final class ItemIterableToolkit {
    public static IItemIterable build(Supplier<Stream<IItem>> items, IType<IItem> type) {
        return new StreamBackedItemIterable(items, type);
    }

    public static Stream<IItemIterable> filter(Stream<? extends IItemIterable> items, IItemFilter on) {
        Function<IItemIterable, IItemIterable> streamMapper = itemStream -> {
            Predicate<IItem> predicate = on.getPredicate(itemStream.getType());
            if (PredicateToolkit.isTrueGuaranteed(predicate)) {
                return itemStream;
            }
            if (PredicateToolkit.isFalseGuaranteed(predicate)) {
                return null;
            }
            return itemStream.apply(predicate);
        };
        return items.map(streamMapper).filter(Predicates.nonNull());
    }

    public static <V, C extends IItemConsumer<C>> V aggregate(IAggregator<V, C> a, Stream<? extends IItemIterable> items) {
        Function<IItemIterable, IItemConsumer> itemsToValue = itemsStream -> (IItemConsumer)ItemIterableToolkit.parallelStream(itemsStream).collect(ItemIterableToolkit.valueCollector(a, itemsStream.getType()));
        Stream<IItemConsumer> consumers = items.filter(is -> a.acceptType(is.getType())).map(itemsToValue);
        return a.getValue(consumers.iterator());
    }

    private static <C extends IItemConsumer<C>> Collector<IItem, C, C> valueCollector(IAggregator<?, C> a, IType<IItem> type) {
        return Collector.of(() -> a.newItemConsumer(type), IItemConsumer::consume, IItemConsumer::merge, Collector.Characteristics.UNORDERED);
    }

    public static <V> Stream<? extends IItem> sorted(IItemIterable items, IAttribute<V> onAttribute, Comparator<? super V> valueComparator) {
        IMemberAccessor va = onAttribute.getAccessor(items.getType());
        return ItemIterableToolkit.stream(items).sorted((i1, i2) -> Objects.compare(va.getMember((IItem)i1), va.getMember((IItem)i2), valueComparator));
    }

    public static Stream<IItem> stream(IItemIterable items) {
        return StreamSupport.stream(items.spliterator(), false);
    }

    public static Stream<IItem> parallelStream(IItemIterable items) {
        return StreamSupport.stream(items.spliterator(), true);
    }

    private static class StreamBackedItemIterable
    implements IItemIterable {
        private final Supplier<Stream<IItem>> items;
        private final IType<IItem> type;

        StreamBackedItemIterable(Supplier<Stream<IItem>> items, IType<IItem> type) {
            this.items = items;
            this.type = type;
        }

        @Override
        public IType<IItem> getType() {
            return this.type;
        }

        @Override
        public boolean hasItems() {
            return this.items.get().findAny().isPresent();
        }

        @Override
        public long getItemCount() {
            long exactSizeIfKnown = this.spliterator().getExactSizeIfKnown();
            return exactSizeIfKnown >= 0L ? exactSizeIfKnown : this.items.get().count();
        }

        @Override
        public Iterator<IItem> iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        @Override
        public Spliterator<IItem> spliterator() {
            return this.items.get().spliterator();
        }

        @Override
        public IItemIterable apply(Predicate<IItem> filter) {
            return new StreamBackedItemIterable(() -> this.items.get().filter(filter), this.getType());
        }
    }
}

