/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.internal;

import java.util.List;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.log4testng.Logger;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class TestNamesMatcher {
    private static final Logger LOGGER = Logger.getLogger(TestNamesMatcher.class);
    private final List<XmlSuite> cloneSuites = Lists.newArrayList();
    private final List<String> matchedTestNames = Lists.newArrayList();
    private final List<XmlTest> matchedTests = Lists.newArrayList();
    private final List<String> testNames;
    private final boolean ignoreMissedTestNames;

    public TestNamesMatcher(XmlSuite xmlSuite, List<String> testNames) {
        this(xmlSuite, testNames, false);
    }

    public TestNamesMatcher(XmlSuite xmlSuite, List<String> testNames, boolean ignoreMissedTestNames) {
        this.testNames = testNames;
        this.ignoreMissedTestNames = ignoreMissedTestNames;
        this.cloneIfContainsTestsWithNamesMatchingAny(xmlSuite, this.testNames);
    }

    private void cloneIfContainsTestsWithNamesMatchingAny(XmlSuite xmlSuite, List<String> testNames) {
        if (Strings.isBlankStringList(testNames)) {
            throw new TestNGException("Please provide a valid list of names to check.");
        }
        this.addIfNotNull(this.cloneIfSuiteContainTestsWithNamesMatchingAny(xmlSuite));
        for (XmlSuite suite : xmlSuite.getChildSuites()) {
            this.cloneIfContainsTestsWithNamesMatchingAny(suite, testNames);
        }
    }

    public List<XmlSuite> getSuitesMatchingTestNames() {
        return this.cloneSuites;
    }

    public boolean validateMissMatchedTestNames() {
        List<String> missedTestNames = this.getMissedTestNames();
        if (!missedTestNames.isEmpty()) {
            String errMsg = "The test(s) <" + missedTestNames + "> cannot be found in suite.";
            if (this.ignoreMissedTestNames && !this.matchedTestNames.isEmpty()) {
                LOGGER.warn(errMsg);
                return true;
            }
            throw new TestNGException(errMsg);
        }
        return missedTestNames.isEmpty() && !this.matchedTestNames.isEmpty();
    }

    public List<String> getMissedTestNames() {
        List<String> missedTestNames = Lists.newArrayList();
        missedTestNames.addAll(this.testNames);
        missedTestNames.removeIf(this.matchedTestNames::contains);
        return missedTestNames;
    }

    public List<XmlTest> getMatchedTests() {
        return this.matchedTests;
    }

    private void addIfNotNull(XmlSuite xmlSuite) {
        if (xmlSuite != null) {
            this.cloneSuites.add(xmlSuite);
        }
    }

    private XmlSuite cloneIfSuiteContainTestsWithNamesMatchingAny(XmlSuite suite) {
        List<XmlTest> tests = Lists.newLinkedList();
        for (XmlTest xt : suite.getTests()) {
            if (!xt.nameMatchesAny(this.testNames)) continue;
            tests.add(xt);
            this.matchedTestNames.add(xt.getName());
            this.matchedTests.add(xt);
        }
        if (tests.isEmpty()) {
            return null;
        }
        return TestNamesMatcher.cleanClone(suite, tests);
    }

    private static XmlSuite cleanClone(XmlSuite xmlSuite, List<XmlTest> tests) {
        XmlSuite result = (XmlSuite)xmlSuite.clone();
        result.getTests().clear();
        result.getTests().addAll(tests);
        return result;
    }
}

