/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.IDynamicGraph;
import org.testng.IExecutionVisualiser;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;

public class DynamicGraph<T>
implements IDynamicGraph<T> {
    private final Set<T> m_nodesReady = Sets.newLinkedHashSet();
    private final Set<T> m_nodesRunning = Sets.newLinkedHashSet();
    private final Set<T> m_nodesFinished = Sets.newLinkedHashSet();
    private final Edges<T> m_edges = new Edges();
    private Set<IExecutionVisualiser> visualisers = Sets.newHashSet();

    @Override
    public boolean addNode(T node) {
        return this.m_nodesReady.add(node);
    }

    @Override
    public void addEdge(int weight, T from, T to) {
        this.m_edges.addEdge(weight, from, to, false);
    }

    @Override
    public void setVisualisers(Set<IExecutionVisualiser> listener) {
        this.visualisers = listener;
    }

    @Override
    public void addEdges(int weight, T from, Iterable<T> tos) {
        for (T to : tos) {
            this.addEdge(weight, from, to);
        }
    }

    @Override
    public List<T> getFreeNodes() {
        Set<T> free = Sets.newLinkedHashSet(this.m_nodesReady);
        free.removeAll(this.m_edges.fromNodes());
        if (free.isEmpty() && this.m_nodesRunning.isEmpty()) {
            int lowestWeight = this.m_edges.getLowestEdgeWeight(this.m_nodesReady);
            for (T node : this.m_nodesReady) {
                if (!this.m_edges.hasAllEdgesWithWeight(node, lowestWeight)) continue;
                free.add(node);
            }
        }
        List finalResult = Lists.newArrayList();
        for (T node : free) {
            Map<T, Integer> edges = this.m_edges.from(node);
            if (edges != null && !Collections.disjoint(edges.keySet(), free)) continue;
            finalResult.add(node);
        }
        return finalResult;
    }

    @Override
    public List<T> getUpstreamDependenciesFor(T node) {
        return this.dependencies(this.m_edges.from(node));
    }

    @Override
    public List<T> getDependenciesFor(T node) {
        return this.dependencies(this.m_edges.to(node));
    }

    private List<T> dependencies(Map<T, Integer> dependencies) {
        return Optional.ofNullable(dependencies).map(found -> Lists.newArrayList(found.keySet())).orElse(Lists.newArrayList());
    }

    @Override
    public void setStatus(Collection<T> nodes, IDynamicGraph.Status status) {
        for (T n : nodes) {
            this.setStatus(n, status);
        }
    }

    @Override
    public void setStatus(T node, IDynamicGraph.Status status) {
        switch (status) {
            case RUNNING: {
                this.m_nodesReady.remove(node);
                this.m_nodesRunning.add(node);
                break;
            }
            case FINISHED: {
                this.m_nodesReady.remove(node);
                this.m_nodesRunning.remove(node);
                this.m_nodesFinished.add(node);
                Map<T, Integer> outgoingEdges = this.m_edges.from(node);
                Map<T, Integer> incomingEdges = this.m_edges.to(node);
                if (outgoingEdges != null && incomingEdges != null) {
                    for (Map.Entry<T, Integer> out : outgoingEdges.entrySet()) {
                        for (Map.Entry<T, Integer> in : incomingEdges.entrySet()) {
                            if (in.getKey() == out.getKey() || in.getValue() > out.getValue()) continue;
                            int weight = Math.max(in.getValue(), out.getValue());
                            this.m_edges.addEdge(weight, in.getKey(), out.getKey(), true);
                        }
                    }
                }
                this.m_edges.removeNode(node);
                break;
            }
            case READY: {
                this.m_nodesReady.add(node);
                this.m_nodesRunning.remove(node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status: " + status);
            }
        }
        this.visualisers.forEach(visualiser -> visualiser.consumeDotDefinition(this.toDot()));
    }

    @Override
    public int getNodeCount() {
        return this.m_nodesReady.size() + this.m_nodesRunning.size() + this.m_nodesFinished.size();
    }

    @Override
    public int getNodeCountWithStatus(IDynamicGraph.Status status) {
        return this.getNodesWithStatus(status).size();
    }

    @Override
    public Set<T> getNodesWithStatus(IDynamicGraph.Status status) {
        switch (status) {
            case READY: {
                return this.m_nodesReady;
            }
            case RUNNING: {
                return this.m_nodesRunning;
            }
            case FINISHED: {
                return this.m_nodesFinished;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "[DynamicGraph \n  Ready:" + this.m_nodesReady + "\n  Running:" + this.m_nodesRunning + "\n  Finished:" + this.m_nodesFinished + "\n  Edges:\n" + this.m_edges + "]";
    }

    private static <T> String dotShortName(T t) {
        String s = t.toString();
        int n2 = s.indexOf(40);
        return s.substring(0, n2).replaceAll("\\Q.\\E", "_");
    }

    @Override
    public String toDot() {
        String color;
        String FREE = "[style=filled color=yellow]";
        String RUNNING = "[style=filled color=green]";
        String FINISHED = "[style=filled color=grey]";
        StringBuilder result = new StringBuilder("digraph g {\n");
        List<T> freeNodes = this.getFreeNodes();
        for (T n : this.m_nodesReady) {
            color = freeNodes.contains(n) ? FREE : "";
            result.append("  ").append(DynamicGraph.dotShortName(n)).append(color).append("\n");
        }
        for (T n : this.m_nodesRunning) {
            color = freeNodes.contains(n) ? FREE : RUNNING;
            result.append("  ").append(DynamicGraph.dotShortName(n)).append(color).append("\n");
        }
        for (T n : this.m_nodesFinished) {
            result.append("  ").append(DynamicGraph.dotShortName(n)).append(FINISHED).append("\n");
        }
        this.m_edges.appendDotEdges(result, this.m_nodesFinished);
        result.append("}\n");
        return result.toString();
    }

    Map<T, Map<T, Integer>> getEdges() {
        return this.m_edges.getEdges();
    }

    private static class Edges<T> {
        private final Map<T, Map<T, Integer>> m_incomingEdges = new ConcurrentHashMap<T, Map<T, Integer>>();
        private final Map<T, Map<T, Integer>> m_outgoingEdges = new ConcurrentHashMap<T, Map<T, Integer>>();

        private Edges() {
        }

        public void addEdge(int weight, T from, T to, boolean ignoreCycles) {
            if (from.equals(to)) {
                return;
            }
            Integer reversedEdgeWeight = this.findReversedEdge(from, to);
            if (reversedEdgeWeight != null && reversedEdgeWeight == weight) {
                if (!ignoreCycles) {
                    throw new IllegalStateException("Circular dependency: " + from + " <-> " + to);
                }
                return;
            }
            Edges.addEdgeToMap(this.m_incomingEdges, to, from, weight);
            Edges.addEdgeToMap(this.m_outgoingEdges, from, to, weight);
        }

        Set<T> fromNodes() {
            return this.m_outgoingEdges.keySet();
        }

        Map<T, Integer> from(T node) {
            Map<T, Integer> edges = this.m_outgoingEdges.get(node);
            return edges == null ? null : Collections.unmodifiableMap(edges);
        }

        Map<T, Integer> to(T node) {
            Map<T, Integer> edges = this.m_incomingEdges.get(node);
            return edges == null ? null : Collections.unmodifiableMap(edges);
        }

        private Integer findReversedEdge(T from, T to) {
            Map<T, Integer> edges = this.m_outgoingEdges.get(to);
            return edges == null ? null : edges.get(from);
        }

        void removeNode(T node) {
            Map<T, Integer> incomingEdges;
            Map<T, Integer> outgoingEdges = this.m_outgoingEdges.remove(node);
            if (outgoingEdges != null) {
                Edges.removeEdgesFromMap(this.m_incomingEdges, outgoingEdges.keySet(), node);
            }
            if ((incomingEdges = this.m_incomingEdges.remove(node)) != null) {
                Edges.removeEdgesFromMap(this.m_outgoingEdges, incomingEdges.keySet(), node);
            }
        }

        int getLowestEdgeWeight(Set<T> nodes) {
            if (nodes.isEmpty()) {
                return 0;
            }
            Set<T> intersection = Sets.newHashSet(nodes);
            intersection.retainAll(this.m_outgoingEdges.keySet());
            if (intersection.isEmpty()) {
                return 0;
            }
            int lowestWeight = Integer.MAX_VALUE;
            for (T node : intersection) {
                Map<T, Integer> weightMap = this.m_outgoingEdges.get(node);
                lowestWeight = Math.min(lowestWeight, Collections.min(weightMap.values()));
            }
            return lowestWeight;
        }

        boolean hasAllEdgesWithWeight(T node, int level) {
            Map<T, Integer> weights = this.m_outgoingEdges.get(node);
            if (weights == null) {
                return true;
            }
            for (int weight : weights.values()) {
                if (weight == level) continue;
                return false;
            }
            return true;
        }

        private static <T> void removeEdgesFromMap(Map<T, Map<T, Integer>> map, Collection<T> nodes, T node) {
            for (T k : nodes) {
                Map<T, Integer> edges = map.get(k);
                if (edges == null) {
                    throw new IllegalStateException("Edge not found in map.");
                }
                edges.remove(node);
                if (!edges.isEmpty()) continue;
                map.remove(k);
            }
        }

        private static <T> void addEdgeToMap(Map<T, Map<T, Integer>> map, T n1, T n2, int weight) {
            Map edges;
            Integer existingWeight = (Integer)(edges = map.computeIfAbsent(n1, k -> new ConcurrentHashMap())).get(n2);
            edges.put(n2, Math.max(weight, existingWeight != null ? existingWeight : Integer.MIN_VALUE));
        }

        Map<T, Map<T, Integer>> getEdges() {
            Map<T, Map<T, Integer>> edges = Maps.newHashMap();
            for (Map.Entry<T, Map<T, Integer>> es : this.m_outgoingEdges.entrySet()) {
                edges.put(es.getKey(), Collections.unmodifiableMap(es.getValue()));
            }
            return Collections.unmodifiableMap(edges);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<T, Map<T, Integer>> es : this.m_outgoingEdges.entrySet()) {
                sb.append("     ").append(es.getKey()).append("\n");
                for (Map.Entry<T, Integer> to : es.getValue().entrySet()) {
                    sb.append("        (").append(to.getValue()).append(") ").append(to.getKey()).append("\n");
                }
            }
            return sb.toString();
        }

        void appendDotEdges(StringBuilder sb, Set<T> finished) {
            for (Map.Entry<T, Map<T, Integer>> es : this.m_outgoingEdges.entrySet()) {
                T from = es.getKey();
                for (T to : es.getValue().keySet()) {
                    String dotted = finished.contains(from) ? "style=dotted" : "";
                    sb.append("  ").append(DynamicGraph.dotShortName(from)).append(" -> ").append(DynamicGraph.dotShortName(to)).append(" [dir=back ").append(dotted).append("]\n");
                }
            }
        }
    }
}

