/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class ClassHelper {
    private static final List<ClassLoader> classLoaders = new Vector<ClassLoader>();
    private static final String CLASS_HELPER = ClassHelper.class.getSimpleName();
    private static int lastGoodRootIndex = -1;

    private ClassHelper() {
    }

    public static void addClassLoader(ClassLoader loader) {
        classLoaders.add(loader);
    }

    static List<ClassLoader> appendContextualClassLoaders(List<ClassLoader> currentLoaders) {
        List<ClassLoader> allClassLoaders = Lists.newArrayList();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            allClassLoaders.add(contextClassLoader);
        }
        allClassLoaders.addAll(currentLoaders);
        return allClassLoaders;
    }

    public static Class<?> forName(String className) {
        List<ClassLoader> allClassLoaders = ClassHelper.appendContextualClassLoaders(classLoaders);
        for (ClassLoader classLoader : allClassLoaders) {
            if (null == classLoader) continue;
            try {
                return classLoader.loadClass(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                if (!classLoaders.isEmpty()) continue;
                ClassHelper.logClassNotFoundError(className, ex);
            }
        }
        if (RuntimeBehavior.shouldSkipUsingCallerClassLoader()) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            ClassHelper.logClassNotFoundError(className, cnfe);
            return null;
        }
    }

    private static void logClassNotFoundError(String className, Throwable ex) {
        Utils.log(CLASS_HELPER, 2, "Could not instantiate " + className + " : Class doesn't exist (" + ex.getMessage() + ")");
    }

    public static List<ConstructorOrMethod> findDeclaredFactoryMethods(Class<?> cls, IAnnotationFinder finder) {
        ArrayList<ConstructorOrMethod> result = new ArrayList<ConstructorOrMethod>();
        BiConsumer<IFactoryAnnotation, Executable> consumer = (f, executable) -> {
            if (f != null) {
                ConstructorOrMethod factory = new ConstructorOrMethod((Executable)executable);
                factory.setEnabled(f.getEnabled());
                result.add(factory);
            }
        };
        for (Method method : ClassHelper.getAvailableMethods(cls)) {
            IFactoryAnnotation f2 = finder.findAnnotation(method, IFactoryAnnotation.class);
            consumer.accept(f2, method);
        }
        for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
            IFactoryAnnotation f3 = finder.findAnnotation(constructor, IFactoryAnnotation.class);
            consumer.accept(f3, constructor);
        }
        return result;
    }

    public static Set<Method> getAvailableMethodsExcludingDefaults(Class<?> clazz) {
        Map<String, List<Method>> groups = ClassHelper.getAvailableMethods(clazz).stream().collect(Collectors.groupingBy(Method::getName));
        groups.values().stream().filter(group -> group.size() > 1).forEach(group -> group.removeIf(Method::isDefault));
        return groups.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<Method> getAvailableMethods(Class<?> clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return Sets.newHashSet();
        }
        Map<String, Set<Method>> methods = Maps.newHashMap();
        for (Method declaredMethod : ReflectionHelper.getLocalMethods(clazz)) {
            ClassHelper.appendMethod(methods, declaredMethod);
        }
        Class<?> parent = clazz.getSuperclass();
        if (null != parent) {
            while (!Object.class.equals(parent)) {
                Set<Map.Entry<String, Set<Method>>> extractedMethods = ClassHelper.extractMethods(clazz, parent, methods).entrySet();
                for (Map.Entry<String, Set<Method>> extractedMethod : extractedMethods) {
                    Set<Method> m = methods.get(extractedMethod.getKey());
                    if (m == null) {
                        methods.put(extractedMethod.getKey(), extractedMethod.getValue());
                        continue;
                    }
                    m.addAll((Collection<Method>)extractedMethod.getValue());
                }
                parent = parent.getSuperclass();
            }
        }
        Set<Method> returnValue = Sets.newHashSet();
        for (Set<Method> each : methods.values()) {
            returnValue.addAll(each);
        }
        return returnValue;
    }

    private static void appendMethod(Map<String, Set<Method>> methods, Method declaredMethod) {
        Set declaredMethods = methods.computeIfAbsent(declaredMethod.getName(), k -> Sets.newHashSet());
        declaredMethods.add(declaredMethod);
    }

    private static Map<String, Set<Method>> extractMethods(Class<?> childClass, Class<?> clazz, Map<String, Set<Method>> collected) {
        Map<String, Set<Method>> methods = Maps.newHashMap();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Package childPackage = childClass.getPackage();
        Package classPackage = clazz.getPackage();
        boolean isSamePackage = ClassHelper.isSamePackage(childPackage, classPackage);
        for (Method method : declaredMethods) {
            if (!ClassHelper.canInclude(isSamePackage, method, collected)) continue;
            ClassHelper.appendMethod(methods, method);
        }
        return methods;
    }

    private static boolean canInclude(boolean isSamePackage, Method method, Map<String, Set<Method>> collected) {
        int methodModifiers = method.getModifiers();
        boolean visible = Modifier.isPublic(methodModifiers) || Modifier.isProtected(methodModifiers) || isSamePackage && !Modifier.isPrivate(methodModifiers);
        boolean hasNoInheritanceTraits = !ClassHelper.isOverridden(method, collected) && !Modifier.isAbstract(methodModifiers);
        return visible && hasNoInheritanceTraits;
    }

    private static boolean isSamePackage(Package childPackage, Package classPackage) {
        boolean isSamePackage = false;
        if (null == childPackage && null == classPackage) {
            isSamePackage = true;
        }
        if (null != childPackage && null != classPackage) {
            isSamePackage = childPackage.getName().equals(classPackage.getName());
        }
        return isSamePackage;
    }

    private static boolean isOverridden(Method method, Map<String, Set<Method>> methodsByName) {
        Set<Method> collectedMethods = methodsByName.get(method.getName());
        if (collectedMethods == null) {
            return false;
        }
        Class<?> methodClass = method.getDeclaringClass();
        Class<?>[] methodParams = method.getParameterTypes();
        for (Method m : collectedMethods) {
            Class<?>[] paramTypes = m.getParameterTypes();
            if (!methodClass.isAssignableFrom(m.getDeclaringClass()) || methodParams.length != paramTypes.length) continue;
            boolean sameParameters = true;
            for (int i = 0; i < methodParams.length; ++i) {
                if (methodParams[i].equals(paramTypes[i])) continue;
                sameParameters = false;
                break;
            }
            if (!sameParameters) continue;
            return true;
        }
        return false;
    }

    public static Class<?> fileToClass(String file) {
        int i;
        Object className;
        Class<?> result = null;
        if (!file.endsWith(".class") && !file.endsWith(".java")) {
            if (file.startsWith("class ")) {
                file = file.substring("class ".length());
            }
            if (null == (result = ClassHelper.forName(file))) {
                throw new TestNGException("Cannot load class from file: " + file);
            }
            return result;
        }
        int classIndex = file.lastIndexOf(".class");
        if (-1 == classIndex) {
            classIndex = file.lastIndexOf(".java");
        }
        String shortFileName = file.substring(0, classIndex);
        String[] segments = shortFileName.split("[/\\\\]", -1);
        if (-1 != lastGoodRootIndex) {
            className = new StringBuilder(segments[lastGoodRootIndex]);
            for (i = lastGoodRootIndex + 1; i < segments.length; ++i) {
                ((StringBuilder)className).append(".").append(segments[i]);
            }
            result = ClassHelper.forName(((StringBuilder)className).toString());
            if (null != result) {
                return result;
            }
        }
        className = "";
        for (i = segments.length - 1; i >= 0; --i) {
            result = ClassHelper.forName((String)(className = ((String)className).length() == 0 ? segments[i] : segments[i] + "." + (String)className));
            if (null == result) continue;
            lastGoodRootIndex = i;
            break;
        }
        if (null == result) {
            throw new TestNGException("Cannot load class from file: " + file);
        }
        return result;
    }

    public static XmlClass[] findClassesInSameTest(Class<?> cls, XmlSuite suite) {
        Set vResult = Sets.newHashSet();
        for (XmlTest test : suite.getTests()) {
            vResult.addAll(ClassHelper.findClassesInSameTest(cls, test));
        }
        return vResult.toArray(new XmlClass[0]);
    }

    private static Collection<XmlClass> findClassesInSameTest(Class<?> cls, XmlTest xmlTest) {
        Set<XmlClass> vResult = Sets.newHashSet();
        String className = cls.getName();
        for (XmlClass testClass : xmlTest.getXmlClasses()) {
            if (!testClass.getName().equals(className)) continue;
            vResult.addAll(xmlTest.getXmlClasses());
            break;
        }
        return vResult;
    }
}

