/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.configurations;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.execution.ui.RunToolbarPopupKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemManager;
import com.intellij.platform.execution.frontend.split.configurations.RunConfigurationOverProtocol;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientConfigurationFactory;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientConfigurationStubs;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientConfigurationType;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientContextExecutionTargetHolder;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientExecutionTargetProvider;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientExternalRunConfiguration;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfiguration;
import com.intellij.platform.execution.frontend.split.configurations.ThinClientRunConfigurationsHost;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.codeWithMe.model.CodeWithMeConfigurationFactoryModel;
import com.jetbrains.codeWithMe.model.CodeWithMeConfigurationTypeModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationsModel;
import com.jetbrains.codeWithMe.model.CodeWithMeRunConfigurationsModel_GeneratedKt;
import com.jetbrains.codeWithMe.model.ExecutionTargetModel;
import com.jetbrains.codeWithMe.model.StartHistoryStateModel;
import com.jetbrains.rd.framework.base.RdReactiveBase;
import com.jetbrains.rd.framework.impl.RdProperty;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.services.IdeBackend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "modelKeyToUniqueId", "Lcom/intellij/util/containers/BidirectionalMap;", "", "bindWithModel", "", "model", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationsModel;", "syncRunHistoryAndPinned", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "adviseOnCurrentConfiguration", "getRemoteUniqueId", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "isRunningOnHost", "", "Listener", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientRunConfigurationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,269:1\n1#2:270\n30#3,2:271\n27#4,6:273\n1563#5:279\n1634#5,3:280\n1563#5:283\n1634#5,3:284\n13#6:287\n14#7:288\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost\n*L\n149#1:271,2\n150#1:273,6\n163#1:279\n163#1:280,3\n164#1:283\n164#1:284,3\n267#1:287\n267#1:288\n*E\n"})
public final class ThinClientRunConfigurationsHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BidirectionalMap<String, String> modelKeyToUniqueId;
    @NotNull
    private static final Logger logger;

    public ThinClientRunConfigurationsHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modelKeyToUniqueId = new BidirectionalMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void bindWithModel(CodeWithMeRunConfigurationsModel model) {
        model.getConfigurationTypes().view(this.getServiceLifetime(), ThinClientRunConfigurationsHost::bindWithModel$lambda$1);
        model.getRunConfigurations().view(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientRunConfigurationsHost.bindWithModel$lambda$6(model, this, arg_0, arg_1, arg_2));
        this.adviseOnCurrentConfiguration(model);
        MessageBusConnection connection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null));
        Topic topic = RunManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new RunManagerListener(this, model){
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            {
                this.this$0 = $receiver;
                this.$model = $model;
            }

            /*
             * WARNING - void declaration
             */
            public void runConfigurationSelected(RunnerAndConfigurationSettings settings) {
                String hostUniqueID;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object object = RunManager.Companion.getInstanceIfCreated(this.this$0.getProject());
                RunManagerImpl runManagerImpl = object instanceof RunManagerImpl ? (RunManagerImpl)object : null;
                if (runManagerImpl == null) {
                    return;
                }
                RunManagerImpl runManager = runManagerImpl;
                object = runManager.getAllSettings();
                boolean $i$f$filter = false;
                void var6_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
                    boolean bl = false;
                    if (!(it != settings && ThinClientConfigurationStubs.INSTANCE.getStubOriginalId(it) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List otherStubs = (List)destination$iv$iv;
                runManager.removeConfigurations((Collection)otherStubs);
                if (ThinClientConfigurationStubs.INSTANCE.getStubOriginalId(settings) != null) {
                    return;
                }
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
                String uniqueID = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getUniqueID() : null;
                List list = ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this.this$0).getKeysByValue((Object)uniqueID);
                String string = hostUniqueID = list != null ? (String)CollectionsKt.singleOrNull((List)list) : null;
                if (settings != null && hostUniqueID == null) {
                    ThinClientRunConfigurationsHost.Companion.getLogger().error("Failed to get a unique id from a run configuration, uniqueID = '" + uniqueID + "', hostUniqueID = '" + hostUniqueID + "'");
                }
                this.$model.getClientCurrentConfiguration().set((Object)hostUniqueID);
            }

            public void runConfigurationRemoved(RunnerAndConfigurationSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                RunConfiguration runConfiguration = settings.getConfiguration();
                RunConfigurationOverProtocol runConfigurationOverProtocol = runConfiguration instanceof RunConfigurationOverProtocol ? (RunConfigurationOverProtocol)runConfiguration : null;
                if (runConfigurationOverProtocol == null || (runConfigurationOverProtocol = runConfigurationOverProtocol.getModel()) == null) {
                    return;
                }
                RunConfigurationOverProtocol configurationModel = runConfigurationOverProtocol;
                configurationModel.getRemove().fire((Object)Unit.INSTANCE);
            }
        });
        this.syncRunHistoryAndPinned(model, connection);
        Topic topic2 = ExecutionTargetManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, arg_0 -> ThinClientRunConfigurationsHost.bindWithModel$lambda$7(model, arg_0));
        model.getActiveExecutionTarget().advise(this.getServiceLifetime(), arg_0 -> ThinClientRunConfigurationsHost.bindWithModel$lambda$9(model, this, arg_0));
        model.getExecutingConfigurations().adviseAddRemove(this.getServiceLifetime(), (arg_0, arg_1, arg_2) -> ThinClientRunConfigurationsHost.bindWithModel$lambda$10(this, arg_0, arg_1, arg_2));
    }

    private final void syncRunHistoryAndPinned(CodeWithMeRunConfigurationsModel model, MessageBusConnection connection) {
        model.getStartHistoryState().advise(this.getServiceLifetime(), arg_0 -> ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$lambda$14(this, arg_0));
        Ref.BooleanRef localStateChange = new Ref.BooleanRef();
        connection.subscribe(RunConfigurationStartHistory.Companion.getTOPIC(), (Object)new RunConfigurationStartHistory.Listener(this, model, localStateChange){
            final /* synthetic */ ThinClientRunConfigurationsHost this$0;
            final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
            final /* synthetic */ Ref.BooleanRef $localStateChange;
            {
                this.this$0 = $receiver;
                this.$model = $model;
                this.$localStateChange = $localStateChange;
            }

            public void togglePin(RunnerAndConfigurationSettings setting) {
                Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
                ThinClientRunConfigurationsHost.access$syncRunHistoryAndPinned$withLocalChange(this.$localStateChange, () -> syncRunHistoryAndPinned.2.togglePin$lambda$0(setting, this.this$0, this.$model));
            }

            private static final Unit togglePin$lambda$0(RunnerAndConfigurationSettings $setting, ThinClientRunConfigurationsHost this$0, CodeWithMeRunConfigurationsModel $model) {
                String hostUniqueID;
                String string = $setting.getUniqueID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueID(...)");
                String uniqueID = string;
                List list = ThinClientRunConfigurationsHost.access$getModelKeyToUniqueId$p(this$0).getKeysByValue((Object)uniqueID);
                String string2 = hostUniqueID = list != null ? (String)CollectionsKt.singleOrNull((List)list) : null;
                if (hostUniqueID == null) {
                    ThinClientRunConfigurationsHost.Companion.getLogger().error("Failed to get a unique id from a run configuration, uniqueID = '" + uniqueID + "'");
                } else {
                    IAsyncSignal iAsyncSignal = $model.getTogglePin();
                    String string3 = $setting.getUniqueID();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUniqueID(...)");
                    iAsyncSignal.fire((Object)string3);
                }
                return Unit.INSTANCE;
            }
        });
        model.getTogglePin().advise(this.getServiceLifetime(), arg_0 -> ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$lambda$17(this, localStateChange, arg_0));
        model.getRegisterStartedConfiguration().advise(this.getServiceLifetime(), arg_0 -> ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$lambda$19(this, arg_0));
    }

    private final void adviseOnCurrentConfiguration(CodeWithMeRunConfigurationsModel model) {
        if (!Intrinsics.areEqual((Object)RunManager.IS_RUN_MANAGER_INITIALIZED.get((UserDataHolder)this.project), (Object)true)) {
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, model, null){
                int label;
                final /* synthetic */ ThinClientRunConfigurationsHost this$0;
                final /* synthetic */ CodeWithMeRunConfigurationsModel $model;
                {
                    this.this$0 = $receiver;
                    this.$model = $model;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ThinClientRunConfigurationsHost.access$adviseOnCurrentConfiguration(this.this$0, this.$model);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        model.getClientCurrentConfiguration().advise(this.getServiceLifetime(), arg_0 -> ThinClientRunConfigurationsHost.adviseOnCurrentConfiguration$lambda$21(model, this, arg_0));
    }

    @Nullable
    public final String getRemoteUniqueId(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        List list = this.modelKeyToUniqueId.getKeysByValue((Object)settings.getUniqueID());
        if (list == null) {
            return null;
        }
        List remoteIds = list;
        if (!(remoteIds.size() <= 1)) {
            boolean bl = false;
            String string = "More than one remote unique id correspond to " + settings + " (" + settings.getUniqueID() + "): [" + CollectionsKt.joinToString$default((Iterable)remoteIds, null, null, null, (int)0, null, null, (int)63, null) + "]";
            throw new IllegalStateException(string.toString());
        }
        return (String)CollectionsKt.singleOrNull((List)remoteIds);
    }

    public final boolean isRunningOnHost(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String string = this.getRemoteUniqueId(settings);
        if (string == null) {
            return false;
        }
        String hostId = string;
        CodeWithMeRunConfigurationsModel model = CodeWithMeRunConfigurationsModel_GeneratedKt.getCodeWithMeRunConfigurationsModel((Solution)IdeBackend.Companion.getInstance(this.project).getSolution());
        Integer n = (Integer)model.getExecutingConfigurations().get((Object)hostId);
        if (n == null) {
            return false;
        }
        int runCount = n;
        return runCount > 0;
    }

    private static final Unit bindWithModel$lambda$1(Lifetime configurationTypeLifetime, String string, CodeWithMeConfigurationTypeModel configurationTypeModel) {
        Object v1;
        ExtensionPoint point;
        block2: {
            Intrinsics.checkNotNullParameter((Object)configurationTypeLifetime, (String)"configurationTypeLifetime");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)configurationTypeModel, (String)"configurationTypeModel");
            point = ConfigurationType.CONFIGURATION_TYPE_EP.getPoint();
            List list = point.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExtensionList(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                ConfigurationType it = (ConfigurationType)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)configurationTypeModel.getId())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if (v1 != null) {
            return Unit.INSTANCE;
        }
        point.registerExtension((Object)new ThinClientConfigurationType(configurationTypeModel), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)configurationTypeLifetime, null, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$6$lambda$4(ThinClientRunConfigurationsHost this$0, String $modelUniqueId, RunnerAndConfigurationSettingsImpl $settings, RunManagerImpl $runManagerImpl) {
        ((Map)this$0.modelKeyToUniqueId).put($modelUniqueId, $settings.getUniqueID());
        $runManagerImpl.addConfiguration((RunnerAndConfigurationSettings)$settings);
        String selectedStubId = ThinClientConfigurationStubs.INSTANCE.getStubOriginalId($runManagerImpl.getSelectedConfiguration());
        if (Intrinsics.areEqual((Object)selectedStubId, (Object)$modelUniqueId)) {
            $runManagerImpl.setSelectedConfiguration((RunnerAndConfigurationSettings)$settings);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$6$lambda$5(ThinClientRunConfigurationsHost this$0, String $modelUniqueId, RunManagerImpl $runManagerImpl, RunnerAndConfigurationSettingsImpl $settings, CodeWithMeRunConfigurationsModel $model) {
        if (RLifetimeKt.isAlive((Lifetime)this$0.getServiceLifetime())) {
            this$0.modelKeyToUniqueId.remove((Object)$modelUniqueId);
            $runManagerImpl.removeConfiguration((RunnerAndConfigurationSettings)$settings);
            if (Intrinsics.areEqual((Object)$model.getConfigurationIsChanging().getValueOrNull(), (Object)true)) {
                $runManagerImpl.setSelectedConfiguration(ThinClientConfigurationStubs.INSTANCE.createAndAddStubSettings($runManagerImpl, this$0.project, $modelUniqueId));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$6(CodeWithMeRunConfigurationsModel $model, ThinClientRunConfigurationsHost this$0, Lifetime runConfigurationLifetime, String modelUniqueId, CodeWithMeRunConfigurationModel configurationModel) {
        RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl;
        CodeWithMeConfigurationFactoryModel factoryModel;
        List factoryModels;
        Intrinsics.checkNotNullParameter((Object)runConfigurationLifetime, (String)"runConfigurationLifetime");
        Intrinsics.checkNotNullParameter((Object)modelUniqueId, (String)"modelUniqueId");
        Intrinsics.checkNotNullParameter((Object)configurationModel, (String)"configurationModel");
        CodeWithMeConfigurationTypeModel typeModel = (CodeWithMeConfigurationTypeModel)$model.getConfigurationTypes().get((Object)configurationModel.getTypeId());
        if (typeModel == null) {
            logger.error("ConfigurationType with id = " + configurationModel.getTypeId() + " was not found (run configuration: " + configurationModel.getName() + ", factory: " + configurationModel.getFactoryId() + ")");
            return Unit.INSTANCE;
        }
        List list = factoryModels = (List)$model.getConfigurationFactories().get((Object)configurationModel.getTypeId());
        if (list != null) {
            Object v1;
            block5: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    CodeWithMeConfigurationFactoryModel it = (CodeWithMeConfigurationFactoryModel)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)configurationModel.getFactoryId(), (Object)it.getId())) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            v2 = v1;
        } else {
            v2 = factoryModel = null;
        }
        if (factoryModel == null) {
            logger.error("ConfigurationFactory with id = " + configurationModel.getFactoryId() + " was not found (run configuration: " + configurationModel.getName() + ", type: " + configurationModel.getTypeId() + ")");
            return Unit.INSTANCE;
        }
        ThinClientConfigurationType type = new ThinClientConfigurationType(typeModel);
        ThinClientConfigurationFactory factory = new ThinClientConfigurationFactory(type, factoryModel);
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(this$0.project);
        RunConfigurationOverProtocol configuration = configurationModel.isExternalSystem() ? new ThinClientExternalRunConfiguration(runConfigurationLifetime, ThinClientExternalSystemManager.Companion.getSYSTEM_ID(), this$0.project, factory, configurationModel.getName(), type.getIcon(), configurationModel) : new ThinClientRunConfiguration(runConfigurationLifetime, this$0.project, factory, configurationModel);
        RunnerAndConfigurationSettingsImpl $this$bindWithModel_u24lambda_u246_u24lambda_u243 = runnerAndConfigurationSettingsImpl = new RunnerAndConfigurationSettingsImpl(runManagerImpl, (RunConfiguration)configuration, false, null, 12, null);
        boolean bl = false;
        $this$bindWithModel_u24lambda_u246_u24lambda_u243.setFolderName(configurationModel.getFolderName());
        $this$bindWithModel_u24lambda_u246_u24lambda_u243.setActivateToolWindowBeforeRun(configurationModel.isActivateToolWindowBeforeRun());
        $this$bindWithModel_u24lambda_u246_u24lambda_u243.setFocusToolWindowBeforeRun(configurationModel.isFocusToolWindowBeforeRun());
        RunnerAndConfigurationSettingsImpl settings = runnerAndConfigurationSettingsImpl;
        runConfigurationLifetime.bracketIfAlive(() -> ThinClientRunConfigurationsHost.bindWithModel$lambda$6$lambda$4(this$0, modelUniqueId, settings, runManagerImpl), () -> ThinClientRunConfigurationsHost.bindWithModel$lambda$6$lambda$5(this$0, modelUniqueId, runManagerImpl, settings, $model));
        return Unit.INSTANCE;
    }

    private static final void bindWithModel$lambda$7(CodeWithMeRunConfigurationsModel $model, ExecutionTarget newTarget) {
        Intrinsics.checkNotNullParameter((Object)newTarget, (String)"newTarget");
        IOptProperty iOptProperty = $model.getActiveExecutionTarget();
        String string = newTarget.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = newTarget.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        iOptProperty.set((Object)new ExecutionTargetModel(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit bindWithModel$lambda$9(CodeWithMeRunConfigurationsModel $model, ThinClientRunConfigurationsHost this$0, ExecutionTargetModel activeTarget) {
        void $this$usingValue$iv;
        Intrinsics.checkNotNullParameter((Object)activeTarget, (String)"activeTarget");
        IOptProperty iOptProperty = $model.getActiveExecutionTarget();
        Intrinsics.checkNotNull((Object)iOptProperty, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.base.RdReactiveBase");
        if (((RdReactiveBase)iOptProperty).isLocalChange()) {
            return Unit.INSTANCE;
        }
        ExecutionTargetManager executionTargetManager = ExecutionTargetManager.getInstance((Project)this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)executionTargetManager, (String)"getInstance(...)");
        ExecutionTargetManager targetManager = executionTargetManager;
        ExecutionTarget target = ThinClientExecutionTargetProvider.Companion.convertModelToTarget(activeTarget);
        ComponentManager $this$service$iv = (ComponentManager)this$0.project;
        boolean $i$f$service = false;
        Class<ThinClientContextExecutionTargetHolder> serviceClass$iv = ThinClientContextExecutionTargetHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ThinClientContextExecutionTargetHolder contextHolder = (ThinClientContextExecutionTargetHolder)object;
        $this$service$iv = (KMutableProperty0)new MutablePropertyReference0Impl(contextHolder){

            public Object get() {
                return ((ThinClientContextExecutionTargetHolder)this.receiver).getCurrentTarget();
            }

            public void set(Object value) {
                ((ThinClientContextExecutionTargetHolder)this.receiver).setCurrentTarget((ExecutionTarget)value);
            }
        };
        ExecutionTarget value$iv = target;
        boolean $i$f$usingValue = false;
        Object old$iv = $this$usingValue$iv.get();
        try {
            $this$usingValue$iv.set((Object)value$iv);
            boolean bl = false;
            targetManager.setActiveTarget(target);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$usingValue$iv.set(old$iv);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$10(ThinClientRunConfigurationsHost this$0, AddRemove addRemove, String string, int n) {
        Intrinsics.checkNotNullParameter((Object)addRemove, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        ((Runnable)this$0.project.getMessageBus().syncPublisher(RunToolbarPopupKt.getVOID_EXECUTION_TOPIC())).run();
        return Unit.INSTANCE;
    }

    private static final Unit syncRunHistoryAndPinned$lambda$14(ThinClientRunConfigurationsHost this$0, StartHistoryStateModel stateModel) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        RunConfigurationStartHistory.State state;
        Intrinsics.checkNotNullParameter((Object)stateModel, (String)"stateModel");
        RunConfigurationStartHistory.State $this$syncRunHistoryAndPinned_u24lambda_u2414_u24lambda_u2413 = state = new RunConfigurationStartHistory.State();
        boolean bl = false;
        Iterable iterable = stateModel.getHistory();
        RunConfigurationStartHistory.State state2 = $this$syncRunHistoryAndPinned_u24lambda_u2414_u24lambda_u2413;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new RunConfigurationStartHistory.Element(it));
        }
        state2.setHistory(CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv)));
        $this$map$iv = stateModel.getPinned();
        state2 = $this$syncRunHistoryAndPinned_u24lambda_u2414_u24lambda_u2413;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new RunConfigurationStartHistory.Element(it));
        }
        state2.setPinned(CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv)));
        RunConfigurationStartHistory.State state3 = state;
        RunConfigurationStartHistory.Companion.getInstance(this$0.project).loadState(state3);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void syncRunHistoryAndPinned$withLocalChange(Ref.BooleanRef localStateChange, Function0<Unit> block) {
        if (localStateChange.element) {
            return;
        }
        try {
            localStateChange.element = true;
            block.invoke();
        }
        finally {
            localStateChange.element = false;
        }
    }

    private static final Unit syncRunHistoryAndPinned$lambda$17$lambda$16(ThinClientRunConfigurationsHost this$0, String $hostUniqueId) {
        Object v1;
        block3: {
            String string = (String)this$0.modelKeyToUniqueId.get((Object)$hostUniqueId);
            if (string == null) {
                return Unit.INSTANCE;
            }
            String uniqueId = string;
            Iterable iterable = RunManager.Companion.getInstance(this$0.project).getAllSettings();
            for (Object t : iterable) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUniqueID(), (Object)uniqueId)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = v1;
        if (runnerAndConfigurationSettings == null) {
            return Unit.INSTANCE;
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        RunConfigurationStartHistory.Companion.getInstance(this$0.project).togglePin(settings);
        return Unit.INSTANCE;
    }

    private static final Unit syncRunHistoryAndPinned$lambda$17(ThinClientRunConfigurationsHost this$0, Ref.BooleanRef $localStateChange, String hostUniqueId) {
        Intrinsics.checkNotNullParameter((Object)hostUniqueId, (String)"hostUniqueId");
        ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$withLocalChange($localStateChange, (Function0<Unit>)((Function0)() -> ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$lambda$17$lambda$16(this$0, hostUniqueId)));
        return Unit.INSTANCE;
    }

    private static final Unit syncRunHistoryAndPinned$lambda$19(ThinClientRunConfigurationsHost this$0, String hostUniqueId) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)hostUniqueId, (String)"hostUniqueId");
            String string = (String)this$0.modelKeyToUniqueId.get((Object)hostUniqueId);
            if (string == null) {
                return Unit.INSTANCE;
            }
            String uniqueId = string;
            List list = RunManager.Companion.getInstance(this$0.project).getAllSettings();
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUniqueID(), (Object)uniqueId)) continue;
                v1 = e;
                break block3;
            }
            v1 = null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = v1;
        if (runnerAndConfigurationSettings == null) {
            return Unit.INSTANCE;
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        RunConfigurationStartHistory.Companion.getInstance(this$0.project).register(settings);
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnCurrentConfiguration$lambda$21(CodeWithMeRunConfigurationsModel $model, ThinClientRunConfigurationsHost this$0, String modelConfigurationId) {
        IProperty iProperty = $model.getClientCurrentConfiguration();
        RdProperty rdProperty = iProperty instanceof RdProperty ? (RdProperty)iProperty : null;
        boolean bl = rdProperty != null ? rdProperty.isLocalChange() : false;
        if (bl) {
            return Unit.INSTANCE;
        }
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(this$0.project);
        if (modelConfigurationId == null) {
            runManagerImpl.setSelectedConfiguration(null);
            return Unit.INSTANCE;
        }
        String realUniqueId = (String)this$0.modelKeyToUniqueId.get((Object)modelConfigurationId);
        RunnerAndConfigurationSettings settings = null;
        if (realUniqueId != null) {
            Object v2;
            block6: {
                logger.info("Settings found for modelConfigurationId='" + modelConfigurationId + "'");
                Iterable iterable = runManagerImpl.getAllSettings();
                for (Object t : iterable) {
                    RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUniqueID(), (Object)realUniqueId)) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            settings = v2;
            if (settings == null) {
                logger.error("Can't set new selected configuration: configuration with id = " + realUniqueId + " was not found");
                return Unit.INSTANCE;
            }
        } else {
            logger.info("Settings for modelConfigurationId='" + modelConfigurationId + "' are not found in unique id map, creating stub");
            settings = ThinClientConfigurationStubs.INSTANCE.createAndAddStubSettings(runManagerImpl, this$0.project, modelConfigurationId);
        }
        runManagerImpl.setSelectedConfiguration(settings);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ BidirectionalMap access$getModelKeyToUniqueId$p(ThinClientRunConfigurationsHost $this) {
        return $this.modelKeyToUniqueId;
    }

    public static final /* synthetic */ void access$syncRunHistoryAndPinned$withLocalChange(Ref.BooleanRef localStateChange, Function0 block) {
        ThinClientRunConfigurationsHost.syncRunHistoryAndPinned$withLocalChange(localStateChange, (Function0<Unit>)block);
    }

    public static final /* synthetic */ void access$adviseOnCurrentConfiguration(ThinClientRunConfigurationsHost $this, CodeWithMeRunConfigurationsModel model) {
        $this.adviseOnCurrentConfiguration(model);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientRunConfigurationsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientRunConfigurationsHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientRunConfigurationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,269:1\n30#2,2:270\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Companion\n*L\n265#1:270,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThinClientRunConfigurationsHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ThinClientRunConfigurationsHost> serviceClass$iv = ThinClientRunConfigurationsHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ThinClientRunConfigurationsHost)((Object)object);
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/CodeWithMeRunConfigurationsModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientRunConfigurationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Listener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,269:1\n30#2,2:270\n*S KotlinDebug\n*F\n+ 1 ThinClientRunConfigurationsHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientRunConfigurationsHost$Listener\n*L\n40#1:270,2\n*E\n"})
    public static final class Listener
    implements SolutionExtListener<CodeWithMeRunConfigurationsModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session2, @NotNull CodeWithMeRunConfigurationsModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            ComponentManager $this$service$iv = (ComponentManager)session2.getProject();
            boolean $i$f$service = false;
            Class<ThinClientRunConfigurationsHost> serviceClass$iv = ThinClientRunConfigurationsHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ThinClientRunConfigurationsHost)((Object)object)).bindWithModel(model);
        }
    }
}

