/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.html.actions;

import com.intellij.htmltools.html.actions.TableUtil;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TableColumnAdder {
    public static boolean isActionAvailable(Editor editor, PsiFile file) {
        return TableUtil.isInsideTag(editor, file, new String[]{"td", "th"});
    }

    private static void addCellToTag(@NonNls Project project, TableUtil.TableCell cell, boolean toPlaceBefore, boolean insideHeader) throws IncorrectOperationException {
        if (toPlaceBefore) {
            XmlTag newCell = TableColumnAdder.createTableCellXmlTag(project, insideHeader);
            cell.tag.getParent().addBefore((PsiElement)newCell, (PsiElement)cell.tag);
        } else {
            XmlTag newCell = TableColumnAdder.createTableCellXmlTag(project, insideHeader);
            cell.tag.getParent().addAfter((PsiElement)newCell, (PsiElement)cell.tag);
        }
    }

    private static void addColumnToTable(@NotNull Project project, List<TableUtil.TableRow> table, int columnNumber) {
        if (project == null) {
            TableColumnAdder.$$$reportNull$$$0(0);
        }
        block2: for (int i = 0; i < table.size(); ++i) {
            TableUtil.TableRow row = table.get(i);
            if (row.isEmpty()) {
                XmlTag element = TableColumnAdder.createTableCellXmlTag(project, row.insideHeader);
                row.rowTag.add((PsiElement)element);
                continue;
            }
            if (columnNumber < 0) {
                TableUtil.TableCell cell = null;
                for (int j = 0; j < row.size(); ++j) {
                    TableUtil.TableCell currentCell = row.get(j);
                    if (currentCell.startRow != i) continue;
                    cell = currentCell;
                    break;
                }
                if (cell == null) continue;
                TableColumnAdder.addCellToTag(project, cell, true, row.insideHeader);
                continue;
            }
            for (int j = Math.min(columnNumber, row.size() - 1); j >= 0; --j) {
                TableUtil.TableCell cell = row.get(j);
                for (XmlAttribute attribute : cell.tag.getAttributes()) {
                    if (!"colspan".equals(StringUtil.toLowerCase((String)attribute.getLocalName()))) continue;
                    if (cell.startRow != i) continue block2;
                    try {
                        cell.tag.setAttribute("colspan", String.valueOf(Integer.parseInt(cell.tag.getAttributeValue("colspan")) + 1));
                        continue block2;
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                if (cell.startRow != i) continue;
                TableColumnAdder.addCellToTag(project, cell, false, row.insideHeader);
                continue block2;
            }
        }
    }

    private static XmlTag createTableCellXmlTag(@NotNull Project project, boolean inHeader) {
        if (project == null) {
            TableColumnAdder.$$$reportNull$$$0(1);
        }
        String filetext = "<root>" + (inHeader ? "<th></th>" : "<td></td>") + "</root";
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)filetext);
        XmlTag tag = xmlFile.getDocument().getRootTag();
        for (PsiElement element : tag.getChildren()) {
            if (!(element instanceof XmlTag)) continue;
            tag = (XmlTag)element;
        }
        return tag;
    }

    private static boolean moveCaretToFirstEmptyCell(@NotNull Editor editor, PsiElement element) {
        if (editor == null) {
            TableColumnAdder.$$$reportNull$$$0(2);
        }
        if (element instanceof XmlTag && ("td".equals(StringUtil.toLowerCase((String)((XmlTag)element).getName())) || "th".equals(StringUtil.toLowerCase((String)((XmlTag)element).getName()))) && ("<td></td>".equals(element.getText()) || "<th></th>".equals(element.getText()))) {
            PsiElement closingToken = element.getChildren()[3];
            TableUtil.moveCaretTo(editor, closingToken);
            return true;
        }
        for (PsiElement child : element.getChildren()) {
            if (!TableColumnAdder.moveCaretToFirstEmptyCell(editor, child)) continue;
            return true;
        }
        return false;
    }

    public static void addColumn(@NotNull Project project, Editor editor, PsiFile file, boolean toInsertBefore) throws IncorrectOperationException {
        if (project == null) {
            TableColumnAdder.$$$reportNull$$$0(3);
        }
        PsiElement element = TableUtil.getCurrentPsiElement(editor, file);
        element = TableUtil.getParentWithName(element, new String[]{"td", "th"});
        assert (element != null);
        PsiElement root = TableUtil.getTablePsiElement(element);
        Pair<List<TableUtil.TableRow>, TableUtil.TableCell> pair = TableUtil.getTableAndPosition(root, element);
        List table = (List)pair.first;
        int columnNumber = ((TableUtil.TableCell)pair.second).startColumn;
        if (!toInsertBefore) {
            columnNumber += TableUtil.getColumnsNumber((XmlTag)element);
        }
        TableColumnAdder.addColumnToTable(project, table, columnNumber - 1);
        TableColumnAdder.moveCaretToFirstEmptyCell(editor, root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/htmltools/html/actions/TableColumnAdder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addColumnToTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTableCellXmlTag";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretToFirstEmptyCell";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addColumn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

