/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/resolve/AbstractNativeAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "requiredAnnotation", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "<init>", "(Lorg/jetbrains/kotlin/js/PredefinedAnnotation;)V", "additionalCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "check", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "js.frontend"})
public abstract class AbstractNativeAnnotationsChecker
implements DeclarationChecker {
    @NotNull
    private final PredefinedAnnotation requiredAnnotation;

    public AbstractNativeAnnotationsChecker(@NotNull PredefinedAnnotation requiredAnnotation) {
        Intrinsics.checkNotNullParameter((Object)requiredAnnotation, (String)"requiredAnnotation");
        this.requiredAnnotation = requiredAnnotation;
    }

    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(this.requiredAnnotation.getFqName());
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        if (!(declaration instanceof KtNamedFunction) || !(descriptor instanceof FunctionDescriptor)) {
            return;
        }
        boolean isMember = !DescriptorUtils.isTopLevelDeclaration(descriptor) && !Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getVisibility(), (Object)DescriptorVisibilities.LOCAL);
        boolean isExtension = DescriptorUtils.isExtension((CallableDescriptor)descriptor);
        if (isMember && (isExtension || !AnnotationsUtils.isNativeObject(descriptor)) || !isMember && !isExtension) {
            context.getTrace().report(ErrorsJs.NATIVE_ANNOTATIONS_ALLOWED_ONLY_ON_MEMBER_OR_EXTENSION_FUN.on((KtElement)((PsiElement)declaration), annotationDescriptor2.getType()));
        }
        this.additionalCheck((KtNamedFunction)declaration, (FunctionDescriptor)descriptor, context.getTrace());
    }
}

