/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.psi.PsiModifierList;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import javax.swing.Icon;

public final class VisibilityIcons {
    private VisibilityIcons() {
    }

    public static void setVisibilityIcon(PsiModifierList modifierList, RowIcon baseIcon) {
        if (modifierList != null) {
            if (modifierList.hasModifierProperty("public")) {
                VisibilityIcons.setVisibilityIcon(4, baseIcon);
            } else if (modifierList.hasModifierProperty("private")) {
                VisibilityIcons.setVisibilityIcon(1, baseIcon);
            } else if (modifierList.hasModifierProperty("protected")) {
                VisibilityIcons.setVisibilityIcon(3, baseIcon);
            } else if (modifierList.hasModifierProperty("packageLocal")) {
                VisibilityIcons.setVisibilityIcon(2, baseIcon);
            } else {
                Icon emptyIcon = IconManager.getInstance().createEmptyIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Public));
                baseIcon.setIcon(emptyIcon, 1);
            }
        } else {
            Icon emptyIcon = IconManager.getInstance().createEmptyIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Public));
            baseIcon.setIcon(emptyIcon, 1);
        }
    }

    public static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        IconManager iconManager = IconManager.getInstance();
        switch (accessLevel) {
            case 4: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Public);
                break;
            }
            case 3: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Protected);
                break;
            }
            case 2: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Local);
                break;
            }
            case 1: {
                icon = iconManager.getPlatformIcon(PlatformIcons.Private);
                break;
            }
            default: {
                icon = iconManager.createEmptyIcon(iconManager.getPlatformIcon(PlatformIcons.Public));
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

