/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNameHelperImpl
extends PsiNameHelper {
    private final LanguageLevelProjectExtension myLanguageLevelExtension;

    public PsiNameHelperImpl(Project project) {
        this.myLanguageLevelExtension = LanguageLevelProjectExtension.getInstance(project);
    }

    @Override
    public boolean isIdentifier(@Nullable String text) {
        return this.isIdentifier(text, this.getLanguageLevel());
    }

    @NotNull
    protected LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevelExtension.getLanguageLevel();
        if (languageLevel == null) {
            PsiNameHelperImpl.$$$reportNull$$$0(0);
        }
        return languageLevel;
    }

    @Override
    public boolean isIdentifier(@Nullable String text, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiNameHelperImpl.$$$reportNull$$$0(1);
        }
        return text != null && StringUtil.isJavaIdentifier((String)text) && !PsiUtil.isKeyword(text, languageLevel);
    }

    @Override
    public boolean isKeyword(@Nullable String text) {
        if (text == null) {
            return false;
        }
        @NotNull LanguageLevel level = this.getLanguageLevel();
        return PsiUtil.isKeyword(text, level);
    }

    @Override
    public boolean isQualifiedName(@Nullable String text) {
        if (text == null) {
            return false;
        }
        int index = 0;
        while (true) {
            int index1;
            if ((index1 = text.indexOf(46, index)) < 0) {
                index1 = text.length();
            }
            if (!this.isIdentifier(text.substring(index, index1))) {
                return false;
            }
            if (index1 == text.length()) {
                return true;
            }
            index = index1 + 1;
        }
    }

    public static PsiNameHelper getInstance() {
        return new PsiNameHelperImpl(){

            @Override
            @NotNull
            protected LanguageLevel getLanguageLevel() {
                LanguageLevel languageLevel = LanguageLevel.HIGHEST;
                if (languageLevel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return languageLevel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiNameHelperImpl$1", "getLanguageLevel"));
            }
        };
    }

    private PsiNameHelperImpl() {
        this.myLanguageLevelExtension = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiNameHelperImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiNameHelperImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

