/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class PsiJavaModuleModificationTracker
extends SimpleModificationTracker
implements Disposable {
    @NotNull
    private final Project myProject;

    public static PsiJavaModuleModificationTracker getInstance(Project project) {
        return (PsiJavaModuleModificationTracker)((Object)project.getService(PsiJavaModuleModificationTracker.class));
    }

    public long getModificationCount() {
        return super.getModificationCount() + DumbService.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
    }

    public PsiJavaModuleModificationTracker(Project project) {
        this.myProject = project;
        MessageBusConnection connect = project.getMessageBus().connect((Disposable)this);
        connect.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file = vFileEvent.getFile();
                    if (file == null || (file.isDirectory() || !PsiJavaModuleModificationTracker.isModuleFile(file.getName())) && !(vFileEvent instanceof VFileDeleteEvent) && (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName()))) continue;
                    PsiJavaModuleModificationTracker.this.incModificationCount();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/impl/PsiJavaModuleModificationTracker$1", "after"));
            }
        });
    }

    static boolean isModuleFile(String name) {
        return "module-info.java".equals(name) || "MANIFEST.MF".equalsIgnoreCase(name);
    }

    public void dispose() {
    }
}

