/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightClassReferenceExpression;
import com.intellij.psi.impl.light.LightClassTypeReference;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightKeyword;
import com.intellij.psi.impl.light.LightPackageReference;
import com.intellij.psi.impl.light.LightPackageReferenceExpression;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.CollectionFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementFactoryImpl
extends PsiJavaParserFacadeImpl
implements PsiElementFactory,
Disposable {
    private final ConcurrentMap<LanguageLevel, PsiClass> myArrayClasses;
    private final ConcurrentMap<GlobalSearchScope, PsiClassType> myCachedObjectType;
    private static final Key<Boolean> ARRAY_CLASS = Key.create((String)"JavaSyntheticArrayClass");
    private static final JavaParserUtil.ParserWrapper CATCH_SECTION = (builder, languageLevel) -> new JavaParser(languageLevel).getStatementParser().parseCatchBlock(builder);

    public PsiElementFactoryImpl(@NotNull Project project) {
        if (project == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myArrayClasses = new ConcurrentHashMap<LanguageLevel, PsiClass>();
        this.myCachedObjectType = CollectionFactory.createConcurrentSoftMap();
        project.getMessageBus().connect((Disposable)this).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    PsiElementFactoryImpl.this.myCachedObjectType.clear();
                }
            }
        });
    }

    @Override
    @NotNull
    public PsiClass getArrayClass(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = this.myArrayClasses.computeIfAbsent(languageLevel, this::createArrayClass);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    private PsiClass createArrayClass(LanguageLevel level) {
        String text = JavaFeature.GENERICS.isSufficient(level) ? "public static class __Array__<T> {\n public final int length;\n public T[] clone() {}\n}" : "public static class __Array__{\n public final int length;\n public Object clone() {}\n}";
        PsiClass psiClass = ((PsiExtensibleClass)this.createClassFromText(text, null)).getOwnInnerClasses().get(0);
        PsiElementFactoryImpl.ensureNonWritable(psiClass);
        PsiFile file = psiClass.getContainingFile();
        file.clearCaches();
        PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)file, (Object)level);
        ARRAY_CLASS.set((UserDataHolder)psiClass, (Object)true);
        return psiClass;
    }

    @Override
    public boolean isArrayClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(3);
        }
        return Boolean.TRUE.equals(ARRAY_CLASS.get((UserDataHolder)psiClass));
    }

    private static void ensureNonWritable(PsiClass arrayClass) {
        try {
            arrayClass.getContainingFile().getViewProvider().getVirtualFile().setWritable(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public PsiClassType getArrayClassType(@NotNull PsiType componentType, @NotNull LanguageLevel languageLevel) {
        if (componentType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(4);
        }
        if (languageLevel == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(5);
        }
        PsiClass arrayClass = this.getArrayClass(languageLevel);
        PsiTypeParameter[] typeParameters = arrayClass.getTypeParameters();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (typeParameters.length == 1) {
            substitutor = substitutor.put(typeParameters[0], componentType);
        }
        PsiClassType psiClassType = this.createType(arrayClass, substitutor);
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(6);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor) {
        if (resolve == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return new PsiImmediateClassType(resolve, substitutor);
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass resolve, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel languageLevel) {
        if (resolve == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(9);
        }
        if (substitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(10);
        }
        return new PsiImmediateClassType(resolve, substitutor, languageLevel);
    }

    @Override
    @NotNull
    public PsiClass createClass(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(11);
        }
        PsiClass psiClass = this.createClassInner("class", name);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(12);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createInterface(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(13);
        }
        PsiClass psiClass = this.createClassInner("interface", name);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(14);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createEnum(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(15);
        }
        PsiClass psiClass = this.createClassInner("enum", name);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(16);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createRecord(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(17);
        }
        PsiClass psiClass = this.createClassInner("record", name);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(18);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiClass createAnnotationType(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(19);
        }
        PsiClass psiClass = this.createClassInner("@interface", name);
        if (psiClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(20);
        }
        return psiClass;
    }

    private PsiClass createClassInner(String type, String name) {
        PsiUtil.checkIsIdentifier(this.myManager, name);
        PsiJavaFile aFile = this.createDummyJavaFile("public " + type + " " + name + ("record".equals(type) ? "()" : "") + " { }");
        PsiClass[] classes = aFile.getClasses();
        if (classes.length != 1) {
            throw new IncorrectOperationException("Incorrect " + type + " name \"" + name + "\".");
        }
        return classes[0];
    }

    @Override
    @NotNull
    public PsiTypeElement createTypeElement(@NotNull PsiType psiType) {
        if (psiType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(21);
        }
        LightTypeElement element = new LightTypeElement(this.myManager, psiType);
        CodeEditUtil.setNodeGenerated((ASTNode)element.getNode(), (boolean)true);
        LightTypeElement lightTypeElement = element;
        if (lightTypeElement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(22);
        }
        return lightTypeElement;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByType(@NotNull PsiClassType type) {
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(23);
        }
        return type instanceof PsiClassReferenceType ? ((PsiClassReferenceType)type).getReference() : new LightClassTypeReference(this.myManager, type);
    }

    @Override
    @NotNull
    public PsiTypeParameterList createTypeParameterList() {
        PsiTypeParameterList parameterList = this.createMethodFromText("void foo()", null).getTypeParameterList();
        assert (parameterList != null);
        PsiTypeParameterList psiTypeParameterList = parameterList;
        if (psiTypeParameterList == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(24);
        }
        return psiTypeParameterList;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameter(@NotNull String name, PsiClassType @NotNull [] superTypes) {
        PsiTypeParameter psiTypeParameter;
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(25);
        }
        if (superTypes == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(26);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("public <").append(name);
        if (superTypes.length > 1 || superTypes.length == 1 && !superTypes[0].equalsToText("java.lang.Object")) {
            builder.append(" extends ");
            for (PsiClassType type : superTypes) {
                if (type.equalsToText("java.lang.Object")) continue;
                builder.append(type.getCanonicalText(true)).append('&');
            }
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append("> void foo(){}");
        try {
            psiTypeParameter = this.createMethodFromText(builder.toString(), null).getTypeParameters()[0];
        }
        catch (RuntimeException e) {
            throw new IncorrectOperationException("type parameter text: " + builder, (Throwable)e);
        }
        if (psiTypeParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(27);
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiField createField(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(28);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(29);
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiTypes.nullType().equals(type)) {
            throw new IncorrectOperationException("Cannot create field with type \"null\".");
        }
        String text = "class _Dummy_ { private " + GenericsUtil.getVariableTypeByExpressionType(type).getCanonicalText(true) + " " + name + "; }";
        PsiJavaFile aFile = this.createDummyJavaFile(text);
        PsiClass[] classes = aFile.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException("Class was not created " + text);
        }
        PsiClass psiClass = classes[0];
        PsiField[] fields = psiClass.getFields();
        if (fields.length < 1) {
            throw new IncorrectOperationException("Field was not created " + text);
        }
        PsiField field = fields[0];
        field = (PsiField)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(field);
        PsiField psiField = (PsiField)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)field);
        if (psiField == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(30);
        }
        return psiField;
    }

    @Override
    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(31);
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiTypes.nullType().equals(returnType)) {
            throw new IncorrectOperationException("Cannot create method with type \"null\".");
        }
        String canonicalText = GenericsUtil.getVariableTypeByExpressionType(returnType).getCanonicalText(true);
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { public " + canonicalText + " " + name + "() {\n} }");
        PsiClass[] classes = aFile.getClasses();
        if (classes.length < 1) {
            throw new IncorrectOperationException("Class was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod[] methods = classes[0].getMethods();
        if (methods.length < 1) {
            throw new IncorrectOperationException("Method was not created. Method name: " + name + "; return type: " + canonicalText);
        }
        PsiMethod method = methods[0];
        method = (PsiMethod)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(method);
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(32);
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createMethod(@NotNull String name, PsiType returnType, PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(33);
        }
        PsiMethod psiMethod = this.createMethodFromText("public " + GenericsUtil.getVariableTypeByExpressionType(returnType).getCanonicalText(true) + " " + name + "() {}", context);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(34);
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor() {
        PsiMethod psiMethod = this.createConstructor("_Dummy_");
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(35);
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(36);
        }
        PsiJavaFile aFile = this.createDummyJavaFile("class " + name + " { public " + name + "() {} }");
        PsiMethod method = aFile.getClasses()[0].getMethods()[0];
        PsiMethod psiMethod = (PsiMethod)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)method);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(37);
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiMethod createConstructor(@NotNull String name, PsiElement context) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(38);
        }
        PsiMethod psiMethod = this.createMethodFromText(name + "() {}", context);
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(39);
        }
        return psiMethod;
    }

    @Override
    @NotNull
    public PsiClassInitializer createClassInitializer() throws IncorrectOperationException {
        PsiJavaFile aFile = this.createDummyJavaFile("class _Dummy_ { {} }");
        PsiClassInitializer classInitializer = aFile.getClasses()[0].getInitializers()[0];
        PsiClassInitializer psiClassInitializer = (PsiClassInitializer)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)classInitializer);
        if (psiClassInitializer == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(40);
        }
        return psiClassInitializer;
    }

    @Override
    @NotNull
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(41);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(42);
        }
        PsiUtil.checkIsIdentifier(this.myManager, name);
        if (PsiTypes.nullType().equals(type)) {
            throw new IncorrectOperationException("Cannot create parameter with type \"null\".");
        }
        String text = type.getCanonicalText(true) + " " + name;
        PsiParameter parameter = this.createParameterFromText(text, null);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myManager.getProject());
        PsiUtil.setModifierProperty(parameter, "final", JavaCodeStyleSettingsFacade.getInstance(this.myManager.getProject()).isGenerateFinalParameters());
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter);
        parameter = (PsiParameter)JavaCodeStyleManager.getInstance(this.myManager.getProject()).shortenClassReferences(parameter);
        PsiParameter psiParameter = (PsiParameter)codeStyleManager.reformat((PsiElement)parameter);
        if (psiParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(43);
        }
        return psiParameter;
    }

    @Override
    public PsiParameter createParameter(@NotNull String name, @NotNull PsiType type, PsiElement context) throws IncorrectOperationException {
        String text;
        PsiMethod psiMethod;
        PsiParameter[] parameters;
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(44);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(45);
        }
        if ((parameters = (psiMethod = this.createMethodFromText(text = "void f(" + type.getCanonicalText(true) + " " + name + ") {}", context)).getParameterList().getParameters()).length != 1) {
            throw new IncorrectOperationException("Incorrect method was created: " + psiMethod.getText());
        }
        return parameters[0];
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlock() {
        PsiCodeBlock block = this.createCodeBlockFromText("{}", null);
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)block);
        if (psiCodeBlock == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(46);
        }
        return psiCodeBlock;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(47);
        }
        return new PsiImmediateClassType(aClass, aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : this.createRawSubstitutor(aClass));
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiJavaCodeReferenceElement classReference) {
        if (classReference == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(48);
        }
        return new PsiClassReferenceType(classReference, null);
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType parameter) {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(49);
        }
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        assert (typeParameters.length == 1) : aClass;
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter));
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(50);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createType(@NotNull PsiClass aClass, PsiType ... parameters) {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(51);
        }
        PsiClassType psiClassType = this.createType(aClass, PsiSubstitutor.EMPTY.putAll(aClass, parameters));
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(52);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(53);
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(owner)) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.createSubstitutor(substitutorMap);
        if (psiSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(54);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor createRawSubstitutor(@NotNull PsiSubstitutor baseSubstitutor, PsiTypeParameter @NotNull [] typeParameters) {
        if (baseSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(55);
        }
        if (typeParameters == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(56);
        }
        HashMap<PsiTypeParameter, Object> substitutorMap = null;
        for (PsiTypeParameter parameter : typeParameters) {
            if (substitutorMap == null) {
                substitutorMap = new HashMap<PsiTypeParameter, Object>();
            }
            substitutorMap.put(parameter, null);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.createSubstitutor(substitutorMap).putAll(baseSubstitutor);
        if (psiSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(57);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiElement createDummyHolder(@NotNull String text, @NotNull IElementType type, @Nullable PsiElement context) {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(58);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(59);
        }
        DummyHolder result = DummyHolderFactory.createHolder((PsiManager)this.myManager, (PsiElement)context);
        FileElement holder = result.getTreeElement();
        Language language = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        assert (parserDefinition != null) : "No parser definition for language " + language;
        Project project = this.myManager.getProject();
        Lexer lexer = parserDefinition.createLexer(project);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, (ASTNode)holder, lexer, language, (CharSequence)text);
        ASTNode node = parserDefinition.createParser(project).parse(type, builder);
        holder.rawAddChildren((TreeElement)node);
        PsiElement psi = node.getPsi();
        assert (psi != null) : text;
        PsiElement psiElement = psi;
        if (psiElement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(60);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiSubstitutor createSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(61);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.createSubstitutor(map2);
        if (psiSubstitutor == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(62);
        }
        return psiSubstitutor;
    }

    @Override
    @Nullable
    public PsiPrimitiveType createPrimitiveType(@NotNull String text) {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(63);
        }
        return PsiJavaParserFacadeImpl.getPrimitiveType(text);
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(64);
        }
        PsiClassType psiClassType = this.createTypeByFQClassName(qName, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
        if (psiClassType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(65);
        }
        return psiClassType;
    }

    @Override
    @NotNull
    public PsiClassType createTypeByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(66);
        }
        if (resolveScope == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(67);
        }
        if ("java.lang.Object".equals(qName)) {
            PsiClassType cachedObjectType = (PsiClassType)this.myCachedObjectType.get(resolveScope);
            if (cachedObjectType != null) {
                PsiClassType psiClassType = cachedObjectType;
                if (psiClassType == null) {
                    PsiElementFactoryImpl.$$$reportNull$$$0(68);
                }
                return psiClassType;
            }
            PsiClass aClass = JavaPsiFacade.getInstance(this.myManager.getProject()).findClass("java.lang.Object", resolveScope);
            if (aClass != null) {
                cachedObjectType = new PsiImmediateClassType(aClass, PsiSubstitutor.EMPTY);
                PsiClassType psiClassType = cachedObjectType = (PsiClassType)ConcurrencyUtil.cacheOrGet(this.myCachedObjectType, (Object)resolveScope, (Object)cachedObjectType);
                if (psiClassType == null) {
                    PsiElementFactoryImpl.$$$reportNull$$$0(69);
                }
                return psiClassType;
            }
        }
        return new PsiClassReferenceType(this.createReferenceElementByFQClassName(qName, resolveScope), null);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createClassReferenceElement(@NotNull PsiClass aClass) {
        String text;
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(70);
        }
        if ((text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName()) == null) {
            throw new IncorrectOperationException("Invalid class: " + aClass);
        }
        return new LightClassReference(this.myManager, text, aClass);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createReferenceElementByFQClassName(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(71);
        }
        if (resolveScope == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(72);
        }
        String shortName = PsiNameHelper.getShortClassName(qName);
        return new LightClassReference(this.myManager, shortName, qName, resolveScope);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createFQClassNameReferenceElement(@NotNull String qName, @NotNull GlobalSearchScope resolveScope) {
        if (qName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(73);
        }
        if (resolveScope == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(74);
        }
        return new LightClassReference(this.myManager, qName, qName, resolveScope);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(75);
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReference(this.myManager, aPackage);
    }

    @Override
    @NotNull
    public PsiPackageStatement createPackageStatement(@NotNull String name) throws IncorrectOperationException {
        PsiJavaFile aFile;
        PsiPackageStatement stmt;
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(76);
        }
        if ((stmt = (aFile = this.createDummyJavaFile("package " + name + ";")).getPackageStatement()) == null) {
            throw new IncorrectOperationException("Incorrect package name: " + name);
        }
        PsiPackageStatement psiPackageStatement = stmt;
        if (psiPackageStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(77);
        }
        return psiPackageStatement;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement createImportStaticStatement(@NotNull PsiClass aClass, @NotNull String memberName) throws IncorrectOperationException {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(78);
        }
        if (memberName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(79);
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + aClass.getQualifiedName() + "." + memberName + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStaticStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(80);
        }
        return psiImportStaticStatement;
    }

    @Override
    @NotNull
    public PsiImportStaticStatement createImportStaticStatementFromText(@NotNull String classFullyQualifiedName, @NotNull String memberName) throws IncorrectOperationException {
        if (classFullyQualifiedName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(81);
        }
        if (memberName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(82);
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import static " + classFullyQualifiedName + "." + memberName + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, true);
        PsiImportStaticStatement psiImportStaticStatement = (PsiImportStaticStatement)CodeStyleManager.getInstance((Project)this.myManager.getProject()).reformat((PsiElement)statement);
        if (psiImportStaticStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(83);
        }
        return psiImportStaticStatement;
    }

    @Override
    @NotNull
    public PsiImportModuleStatement createImportModuleStatementFromText(@NotNull String moduleName) throws IncorrectOperationException {
        PsiJavaFile aFile;
        PsiImportList importList;
        if (moduleName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(84);
        }
        if ((importList = (aFile = this.createDummyJavaFile("import module " + moduleName + ";")).getImportList()) == null) {
            throw new IncorrectOperationException("Can't create module with name: " + moduleName);
        }
        PsiImportModuleStatement[] statements = importList.getImportModuleStatements();
        if (statements.length != 1) {
            throw new IncorrectOperationException("Created more than one module with name: " + moduleName);
        }
        PsiImportModuleStatement statement = statements[0];
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiImportModuleStatement psiImportModuleStatement = statement;
        if (psiImportModuleStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(85);
        }
        return psiImportModuleStatement;
    }

    @Override
    @NotNull
    public PsiParameterList createParameterList(String @NotNull [] names, PsiType @NotNull [] types) throws IncorrectOperationException {
        if (names == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(86);
        }
        if (types == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(87);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method(");
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(types[i].getCanonicalText(true)).append(' ').append(names[i]);
        }
        builder.append(");");
        PsiParameterList psiParameterList = this.createMethodFromText(builder.toString(), null).getParameterList();
        if (psiParameterList == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(88);
        }
        return psiParameterList;
    }

    @Override
    @NotNull
    public PsiReferenceList createReferenceList(PsiJavaCodeReferenceElement @NotNull [] references) throws IncorrectOperationException {
        if (references == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(89);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("void method()");
        if (references.length > 0) {
            builder.append(" throws ");
            for (int i = 0; i < references.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(references[i].getCanonicalText());
            }
        }
        builder.append(';');
        PsiReferenceList psiReferenceList = this.createMethodFromText(builder.toString(), null).getThrowsList();
        if (psiReferenceList == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(90);
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement createPackageReferenceElement(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(91);
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReference(this.myManager, packageName);
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(92);
        }
        if (aClass instanceof PsiImplicitClass) {
            throw new IncorrectOperationException("Cannot create reference to implicitly declared class");
        }
        String text = aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassType().getPresentableText() : aClass.getName();
        return new LightClassReferenceExpression(this.myManager, text, aClass);
    }

    @Override
    @NotNull
    public PsiReferenceExpression createReferenceExpression(@NotNull PsiPackage aPackage) throws IncorrectOperationException {
        if (aPackage == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(93);
        }
        if (aPackage.getQualifiedName().isEmpty()) {
            throw new IncorrectOperationException("Cannot create reference to default package.");
        }
        return new LightPackageReferenceExpression(this.myManager, aPackage);
    }

    @Override
    @NotNull
    public PsiIdentifier createIdentifier(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(94);
        }
        PsiUtil.checkIsIdentifier(this.myManager, text);
        return new LightIdentifier(this.myManager, text);
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(95);
        }
        if (!PsiNameHelper.getInstance(this.myManager.getProject()).isKeyword(text)) {
            throw new IncorrectOperationException("\"" + text + "\" is not a keyword.");
        }
        return new LightKeyword(this.myManager, text);
    }

    @Override
    @NotNull
    public PsiKeyword createKeyword(@NotNull String keyword, PsiElement context) throws IncorrectOperationException {
        LanguageLevel level;
        if (keyword == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(96);
        }
        if (!PsiUtil.isKeyword(keyword, level = PsiUtil.getLanguageLevel(context)) && !PsiUtil.isSoftKeyword(keyword, level)) {
            throw new IncorrectOperationException("\"" + keyword + "\" is not a keyword.");
        }
        return new LightKeyword(this.myManager, keyword);
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatement(@NotNull PsiClass aClass) throws IncorrectOperationException {
        if (aClass == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(97);
        }
        if (aClass instanceof PsiAnonymousClass) {
            throw new IncorrectOperationException("Cannot create import statement for anonymous class.");
        }
        if (aClass.getParent() instanceof PsiDeclarationStatement) {
            throw new IncorrectOperationException("Cannot create import statement for local class.");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + aClass.getQualifiedName() + ";");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiImportStatement psiImportStatement = (PsiImportStatement)statement;
        if (psiImportStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(98);
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiImportStatement createImportStatementOnDemand(@NotNull String packageName) throws IncorrectOperationException {
        if (packageName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(99);
        }
        if (packageName.isEmpty()) {
            throw new IncorrectOperationException("Cannot create import statement for default package.");
        }
        if (!PsiNameHelper.getInstance(this.myManager.getProject()).isQualifiedName(packageName)) {
            throw new IncorrectOperationException("Incorrect package name: \"" + packageName + "\".");
        }
        PsiJavaFile aFile = this.createDummyJavaFile("import " + packageName + ".*;");
        PsiImportStatementBase statement = PsiElementFactoryImpl.extractImport(aFile, false);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiImportStatement psiImportStatement = (PsiImportStatement)statement;
        if (psiImportStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(100);
        }
        return psiImportStatement;
    }

    @Override
    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name, @NotNull PsiType type, @Nullable PsiExpression initializer) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(101);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(102);
        }
        PsiDeclarationStatement psiDeclarationStatement = this.createVariableDeclarationStatement(name, type, initializer, null);
        if (psiDeclarationStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(103);
        }
        return psiDeclarationStatement;
    }

    @Override
    @NotNull
    public PsiDeclarationStatement createVariableDeclarationStatement(@NotNull String name, @NotNull PsiType type, @Nullable PsiExpression initializer, @Nullable PsiElement context) throws IncorrectOperationException {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(104);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(105);
        }
        if (!this.isIdentifier(name)) {
            throw new IncorrectOperationException("\"" + name + "\" is not an identifier.");
        }
        if (PsiTypes.nullType().equals(type)) {
            throw new IncorrectOperationException("Cannot create variable with type \"null\".");
        }
        String text = "X " + name + (initializer != null ? " = x" : "") + ";";
        PsiDeclarationStatement statement = (PsiDeclarationStatement)this.createStatementFromText(text, context);
        PsiVariable variable = (PsiVariable)statement.getDeclaredElements()[0];
        PsiElementFactoryImpl.replace(variable.getTypeElement(), this.createTypeElement(GenericsUtil.getVariableTypeByExpressionType(type)), text);
        boolean generateFinalLocals = context != null && JavaFileCodeStyleFacade.forContext(context.getContainingFile()).isGenerateFinalLocals();
        PsiUtil.setModifierProperty(variable, "final", generateFinalLocals);
        if (initializer != null) {
            PsiElementFactoryImpl.replace(variable.getInitializer(), initializer, text);
        }
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiDeclarationStatement psiDeclarationStatement = statement;
        if (psiDeclarationStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(106);
        }
        return psiDeclarationStatement;
    }

    @Override
    public PsiResourceVariable createResourceVariable(@NotNull String name, @NotNull PsiType type, @Nullable PsiExpression initializer, @Nullable PsiElement context) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(107);
        }
        if (type == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(108);
        }
        PsiTryStatement tryStatement = (PsiTryStatement)this.createStatementFromText("try (X x = null){}", context);
        PsiResourceList resourceList = tryStatement.getResourceList();
        assert (resourceList != null);
        PsiResourceVariable resourceVariable = (PsiResourceVariable)resourceList.iterator().next();
        resourceVariable.getTypeElement().replace(this.createTypeElement(type));
        PsiIdentifier nameIdentifier = resourceVariable.getNameIdentifier();
        assert (nameIdentifier != null);
        nameIdentifier.replace(this.createIdentifier(name));
        if (initializer != null) {
            resourceVariable.setInitializer(initializer);
        }
        return resourceVariable;
    }

    private static void replace(@Nullable PsiElement original, @NotNull PsiElement replacement, @NotNull String message) {
        if (replacement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(109);
        }
        if (message == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(110);
        }
        assert (original != null) : message;
        original.replace(replacement);
    }

    @Override
    @NotNull
    public PsiDocTag createParamTag(@NotNull String parameterName, String description) throws IncorrectOperationException {
        if (parameterName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(111);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" * @param ");
        builder.append(parameterName);
        builder.append(" ");
        String[] strings = description.split("\\n");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append("\n * ");
            }
            builder.append(strings[i]);
        }
        PsiDocTag psiDocTag = this.createDocTagFromText(builder.toString());
        if (psiDocTag == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(112);
        }
        return psiDocTag;
    }

    @Override
    @NotNull
    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context) throws IncorrectOperationException {
        if (annotationText == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(113);
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(114);
        }
        return psiAnnotation2;
    }

    public PsiAnnotation createAnnotationFromText(@NotNull String annotationText, @Nullable PsiElement context, boolean markGenerated) throws IncorrectOperationException {
        if (annotationText == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(115);
        }
        PsiAnnotation psiAnnotation = super.createAnnotationFromText(annotationText, context);
        if (markGenerated) {
            GeneratedMarkerVisitor.markGenerated((PsiElement)psiAnnotation);
        }
        return psiAnnotation;
    }

    @Override
    @NotNull
    public PsiCodeBlock createCodeBlockFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(116);
        }
        PsiCodeBlock psiCodeBlock = super.createCodeBlockFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiCodeBlock);
        PsiCodeBlock psiCodeBlock2 = psiCodeBlock;
        if (psiCodeBlock2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(117);
        }
        return psiCodeBlock2;
    }

    @Override
    @NotNull
    public PsiEnumConstant createEnumConstantFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(118);
        }
        PsiEnumConstant enumConstant = super.createEnumConstantFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)enumConstant);
        PsiEnumConstant psiEnumConstant = enumConstant;
        if (psiEnumConstant == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(119);
        }
        return psiEnumConstant;
    }

    @Override
    @NotNull
    public PsiExpression createExpressionFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(120);
        }
        PsiExpression expression = super.createExpressionFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)expression);
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(121);
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiField createFieldFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(122);
        }
        PsiField psiField = super.createFieldFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)psiField);
        PsiField psiField2 = psiField;
        if (psiField2 == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(123);
        }
        return psiField2;
    }

    @Override
    @NotNull
    public PsiParameter createParameterFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(124);
        }
        PsiParameter parameter = super.createParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)parameter);
        PsiParameter psiParameter = parameter;
        if (psiParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(125);
        }
        return psiParameter;
    }

    @Override
    @NotNull
    public PsiStatement createStatementFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(126);
        }
        PsiStatement statement = super.createStatementFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        PsiStatement psiStatement = statement;
        if (psiStatement == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(127);
        }
        return psiStatement;
    }

    @Override
    @NotNull
    public PsiType createTypeFromText(@NotNull String text, @Nullable PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(128);
        }
        PsiType psiType = this.createTypeInner(text, context, true);
        if (psiType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(129);
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiTypeParameter createTypeParameterFromText(@NotNull String text, PsiElement context) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(130);
        }
        PsiTypeParameter typeParameter = super.createTypeParameterFromText(text, context);
        GeneratedMarkerVisitor.markGenerated((PsiElement)typeParameter);
        PsiTypeParameter psiTypeParameter = typeParameter;
        if (psiTypeParameter == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(131);
        }
        return psiTypeParameter;
    }

    @Override
    @NotNull
    public PsiMethod createMethodFromText(@NotNull String text, PsiElement context, LanguageLevel level) throws IncorrectOperationException {
        if (text == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(132);
        }
        PsiMethod method = super.createMethodFromText(text, context, level);
        GeneratedMarkerVisitor.markGenerated((PsiElement)method);
        PsiMethod psiMethod = method;
        if (psiMethod == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(133);
        }
        return psiMethod;
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStatementBase[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        PsiImportStatementBase[] psiImportStatementBaseArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    @Override
    @NotNull
    public PsiCatchSection createCatchSection(@NotNull PsiType exceptionType, @NotNull String exceptionName, @Nullable PsiElement context) throws IncorrectOperationException {
        if (exceptionType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(134);
        }
        if (exceptionName == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(135);
        }
        if (!(exceptionType instanceof PsiClassType) && !(exceptionType instanceof PsiDisjunctionType)) {
            throw new IncorrectOperationException("Unexpected type:" + exceptionType);
        }
        String text = "catch (" + exceptionType.getCanonicalText(true) + " " + exceptionName + ") {}";
        DummyHolder holder = DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)new JavaDummyElement(text, CATCH_SECTION, PsiElementFactoryImpl.level(context)), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiCatchSection)) {
            throw new IncorrectOperationException("Incorrect catch section '" + text + "'. Parsed element: " + element);
        }
        Project project = this.myManager.getProject();
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(project);
        helper.setupCatchBlock(exceptionName, exceptionType, context, (PsiCatchSection)element);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        PsiCatchSection catchSection = (PsiCatchSection)styleManager.reformat(element);
        GeneratedMarkerVisitor.markGenerated((PsiElement)catchSection);
        PsiCatchSection psiCatchSection = catchSection;
        if (psiCatchSection == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(136);
        }
        return psiCatchSection;
    }

    @Override
    @NotNull
    public PsiFragment createStringTemplateFragment(@NotNull String newText, @NotNull IElementType tokenType, @Nullable PsiElement context) {
        int index;
        if (newText == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(137);
        }
        if (tokenType == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(138);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            newText = newText + "}\"\"\"";
            index = 0;
        } else if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
            newText = "\"\"\"\n\\{" + newText + "}\"\"\"";
            index = 1;
        } else if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
            newText = "\"\"\"\n\\{" + newText;
            index = 1;
        } else if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN) {
            newText = newText + "}\"";
            index = 0;
        } else if (tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
            newText = "\"\\{" + newText + "}\"";
            index = 1;
        } else if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
            newText = "\"\\{" + newText;
            index = 1;
        } else {
            throw new IllegalArgumentException();
        }
        PsiTemplateExpression expression = (PsiTemplateExpression)this.createExpressionFromText(newText, context);
        PsiTemplate template = expression.getTemplate();
        assert (template != null);
        PsiFragment fragment = template.getFragments().get(index);
        GeneratedMarkerVisitor.markGenerated((PsiElement)fragment);
        PsiFragment psiFragment = fragment;
        if (psiFragment == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(139);
        }
        return psiFragment;
    }

    @Override
    public boolean isValidClassName(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(140);
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(141);
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidParameterName(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(142);
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidFieldName(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(143);
        }
        return this.isIdentifier(name);
    }

    @Override
    public boolean isValidLocalVariableName(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(144);
        }
        return this.isIdentifier(name);
    }

    private boolean isIdentifier(@NotNull String name) {
        if (name == null) {
            PsiElementFactoryImpl.$$$reportNull$$$0(145);
        }
        return PsiNameHelper.getInstance(this.myManager.getProject()).isIdentifier(name);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 90: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 139: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 90: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 139: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 90: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiElementFactoryImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 44: 
            case 76: 
            case 101: 
            case 104: 
            case 107: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 23: 
            case 29: 
            case 42: 
            case 45: 
            case 59: 
            case 102: 
            case 105: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypes";
                break;
            }
            case 47: 
            case 49: 
            case 51: 
            case 70: 
            case 78: 
            case 92: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSubstitutor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 58: 
            case 63: 
            case 94: 
            case 95: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 64: 
            case 66: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 67: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 75: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFullyQualifiedName";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 91: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationText";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionName";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiElementFactoryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayClassType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createClass";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterface";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnum";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecord";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationType";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeElement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameter";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createField";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethod";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassInitializer";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlock";
                break;
            }
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 54: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyHolder";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutor";
                break;
            }
            case 65: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQClassName";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageStatement";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStaticStatement";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStaticStatementFromText";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportModuleStatementFromText";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceList";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatementOnDemand";
                break;
            }
            case 103: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableDeclarationStatement";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "createParamTag";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationFromText";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockFromText";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumConstantFromText";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldFromText";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterFromText";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatementFromText";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromText";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeParameterFromText";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodFromText";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "createCatchSection";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringTemplateFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArrayClass";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 90: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 139: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArrayClassType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 47: 
            case 48: 
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createInterface";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEnum";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRecord";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementByType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createTypeParameter";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createMethod";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createConstructor";
                break;
            }
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 53: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createDummyHolder";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutor";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveType";
                break;
            }
            case 64: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQClassName";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createClassReferenceElement";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceElementByFQClassName";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createFQClassNameReferenceElement";
                break;
            }
            case 75: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "createPackageReferenceElement";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createPackageStatement";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createImportStaticStatement";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createImportStaticStatementFromText";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createImportModuleStatementFromText";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceList";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceExpression";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createKeyword";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatementOnDemand";
                break;
            }
            case 101: 
            case 102: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "createVariableDeclarationStatement";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "createResourceVariable";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "createParamTag";
                break;
            }
            case 113: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationFromText";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockFromText";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "createEnumConstantFromText";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "createFieldFromText";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "createParameterFromText";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromText";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromText";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "createTypeParameterFromText";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "createMethodFromText";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "createCatchSection";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createStringTemplateFragment";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassName";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isValidMethodName";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameterName";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldName";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isValidLocalVariableName";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 50: 
            case 52: 
            case 54: 
            case 57: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 69: 
            case 77: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 90: 
            case 98: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 114: 
            case 117: 
            case 119: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 139: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

