/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.debugger.impl.shared;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.java.debugger.impl.shared.JavaDebuggerSharedBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.viewModel.extraction.ToolWindowContentExtractor;
import com.intellij.unscramble.MergeableDumpItem;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.util.text.DateFormatUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SharedDebuggerUtils {
    private static int myThreadDumpsCount = 0;

    public static String translateStringValue(String str) {
        int length = str.length();
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)length, (String)str, (StringBuilder)buffer);
        return buffer.toString();
    }

    @ApiStatus.Internal
    public static ThreadDumpPanel createThreadDumpPanel(Project project, RunnerLayoutUi ui, List<Filter> filters) {
        return SharedDebuggerUtils.createThreadDumpPanel(project, Collections.emptyList(), ui, filters);
    }

    @ApiStatus.Internal
    public static ThreadDumpPanel createThreadDumpPanel(Project project, List<MergeableDumpItem> dumpItems, RunnerLayoutUi ui, List<Filter> filters) {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(filters);
        ConsoleView consoleView = consoleBuilder.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel panel = ThreadDumpPanel.createFromDumpItems(project, consoleView, toolbarActions, dumpItems);
        String id = JavaDebuggerSharedBundle.message("thread.dump.name", DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis()));
        Content content = ui.createContent(id + " " + myThreadDumpsCount, (JComponent)panel, id, null, null);
        content.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
        content.setCloseable(true);
        content.setDescription(JavaDebuggerSharedBundle.message("thread.dump", new Object[0]));
        content.putUserData(ToolWindowContentExtractor.SYNC_TAB_TO_REMOTE_CLIENTS, (Object)true);
        ui.addContent(content);
        ui.selectAndFocus(content, true, true);
        ++myThreadDumpsCount;
        Disposer.register((Disposable)content, (Disposable)consoleView);
        ui.selectAndFocus(content, true, false);
        if (!dumpItems.isEmpty()) {
            panel.selectStackFrame(0);
        }
        return panel;
    }
}

