/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingArrayConstructorBracketFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingArrayConstructorBracketFixer.$$$reportNull$$$0(0);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_NEW_EXPRESSION)) {
            return;
        }
        int count = 0;
        for (ASTNode element = astNode.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (BasicJavaAstTreeUtil.is(element, JavaTokenType.LBRACKET)) {
                ++count;
                continue;
            }
            if (!BasicJavaAstTreeUtil.is(element, JavaTokenType.RBRACKET)) continue;
            --count;
        }
        if (count > 0) {
            editor.getDocument().insertString(astNode.getTextRange().getEndOffset(), (CharSequence)"]");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/MissingArrayConstructorBracketFixer", "apply"));
    }
}

