/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class JavaCatchBlockMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiCatchSection sibling;
        int endOffset;
        int startOffset;
        if (editor == null) {
            JavaCatchBlockMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaCatchBlockMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JavaCatchBlockMover.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            startOffset = selectionModel.getSelectionStart();
            endOffset = selectionModel.getSelectionEnd();
        } else {
            startOffset = document.getLineStartOffset(info.toMove.startLine);
            endOffset = JavaCatchBlockMover.getLineStartSafeOffset((Document)document, (int)info.toMove.endLine);
        }
        PsiElement element = file.findElementAt(startOffset);
        if (element == null) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        if (tryStatement == null) {
            return false;
        }
        PsiCatchSection firstToMove = null;
        PsiCatchSection lastToMove = null;
        for (PsiCatchSection catchSection : tryStatement.getCatchSections()) {
            int offset = catchSection.getTextOffset();
            PsiElement child = catchSection.getFirstChild();
            if (!(child instanceof PsiKeyword)) {
                return info.prohibitMove();
            }
            if ((offset < startOffset || offset >= endOffset) && !child.getTextRange().contains(startOffset)) continue;
            if (firstToMove == null) {
                firstToMove = catchSection;
            }
            lastToMove = catchSection;
        }
        if (firstToMove == null) {
            return false;
        }
        if (!JavaCatchBlockMover.sanityCheck(firstToMove)) {
            return info.prohibitMove();
        }
        if (element instanceof PsiWhiteSpace && element.getNextSibling() instanceof PsiStatement || PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) != tryStatement) {
            return info.prohibitMove();
        }
        PsiCatchSection psiCatchSection = sibling = down ? (PsiCatchSection)PsiTreeUtil.getNextSiblingOfType((PsiElement)lastToMove, PsiCatchSection.class) : (PsiCatchSection)PsiTreeUtil.getPrevSiblingOfType((PsiElement)firstToMove, PsiCatchSection.class);
        if (sibling == null) {
            return info.prohibitMove();
        }
        info.toMove = new LineRange((PsiElement)firstToMove, (PsiElement)lastToMove, document);
        info.toMove2 = new LineRange((PsiElement)sibling, (PsiElement)sibling, document);
        if (down ? info.toMove.endLine > info.toMove2.startLine : info.toMove2.endLine > info.toMove.startLine) {
            info.toMove = new LineRange(info.toMove.startLine, info.toMove.endLine - 1);
            info.toMove2 = new LineRange(info.toMove2.startLine, info.toMove2.endLine - 1);
        }
        info.indentSource = false;
        info.indentTarget = false;
        return true;
    }

    private static boolean sanityCheck(PsiCatchSection catchSection) {
        PsiCatchSection[] catchSections = catchSection.getTryStatement().getCatchSections();
        if (catchSections.length < 2) {
            return false;
        }
        boolean newLine = JavaCatchBlockMover.containsNewLine(catchSections[0].getPrevSibling());
        for (int i = 1; i < catchSections.length; ++i) {
            if (newLine == JavaCatchBlockMover.containsNewLine(catchSections[i].getPrevSibling())) continue;
            return false;
        }
        return true;
    }

    private static boolean containsNewLine(PsiElement element) {
        return element instanceof PsiWhiteSpace && element.getText().contains("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/moveUpDown/JavaCatchBlockMover";
        objectArray[2] = "checkAvailable";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

