/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.net.tcp;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import zmq.ZError;
import zmq.io.net.Address;
import zmq.util.Utils;

public class TcpUtils {
    public static final boolean WITH_EXTENDED_KEEPALIVE = SocketOptionsProvider.access$000();

    private TcpUtils() {
    }

    public static void tuneTcpSocket(Channel channel) throws IOException {
        TcpUtils.setOption(channel, StandardSocketOptions.TCP_NODELAY, true);
    }

    public static void tuneTcpKeepalives(Channel channel, int tcpKeepAlive, int tcpKeepAliveCnt, int tcpKeepAliveIdle, int tcpKeepAliveIntvl) {
        if (tcpKeepAlive != -1) {
            if (channel instanceof SocketChannel) {
                TcpUtils.setOption(channel, StandardSocketOptions.SO_KEEPALIVE, tcpKeepAlive == 1);
            }
            if (WITH_EXTENDED_KEEPALIVE && tcpKeepAlive == 1) {
                if (tcpKeepAliveCnt > 0) {
                    TcpUtils.setOption(channel, SocketOptionsProvider.TCP_KEEPCOUNT, tcpKeepAliveCnt);
                }
                if (tcpKeepAliveIdle > 0) {
                    TcpUtils.setOption(channel, SocketOptionsProvider.TCP_KEEPIDLE, tcpKeepAliveIdle);
                }
                if (tcpKeepAliveIntvl > 0) {
                    TcpUtils.setOption(channel, SocketOptionsProvider.TCP_KEEPINTERVAL, tcpKeepAliveIntvl);
                }
            }
        }
    }

    public static boolean setTcpReceiveBuffer(Channel channel, int rcvbuf) {
        TcpUtils.setOption(channel, StandardSocketOptions.SO_RCVBUF, rcvbuf);
        return true;
    }

    public static boolean setTcpSendBuffer(Channel channel, int sndbuf) {
        TcpUtils.setOption(channel, StandardSocketOptions.SO_SNDBUF, sndbuf);
        return true;
    }

    public static boolean setIpTypeOfService(Channel channel, int tos) {
        TcpUtils.setOption(channel, StandardSocketOptions.SO_SNDBUF, tos);
        return true;
    }

    public static boolean setReuseAddress(Channel channel, boolean reuse) {
        TcpUtils.setOption(channel, StandardSocketOptions.SO_REUSEADDR, reuse);
        return true;
    }

    private static <T> void setOption(Channel channel, SocketOption<T> option2, T value) {
        try {
            if (!(channel instanceof NetworkChannel)) {
                throw new IllegalArgumentException("Channel " + channel + " is not a network channel");
            }
            ((NetworkChannel)channel).setOption(option2, value);
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    public static void unblockSocket(SelectableChannel ... channels) throws IOException {
        for (SelectableChannel ch : channels) {
            ch.configureBlocking(false);
        }
    }

    public static void enableIpv4Mapping(SelectableChannel channel) {
    }

    @Deprecated
    public static Address getPeerIpAddress(SocketChannel channel) {
        return Utils.getPeerIpAddress(channel);
    }

    private static final class SocketOptionsProvider {
        private static final SocketOption<Integer> TCP_KEEPCOUNT;
        private static final SocketOption<Integer> TCP_KEEPIDLE;
        private static final SocketOption<Integer> TCP_KEEPINTERVAL;
        private static final boolean WITH_EXTENDED_KEEPALIVE;

        private SocketOptionsProvider() {
        }

        static /* synthetic */ boolean access$000() {
            return WITH_EXTENDED_KEEPALIVE;
        }

        static {
            SocketOption tryCount = null;
            SocketOption tryIdle = null;
            SocketOption tryInterval = null;
            boolean extendedKeepAlive = false;
            try {
                Class<?> eso = TcpUtils.class.getClassLoader().loadClass("jdk.net.ExtendedSocketOptions");
                tryCount = (SocketOption)eso.getField("TCP_KEEPCOUNT").get(null);
                tryIdle = (SocketOption)eso.getField("TCP_KEEPIDLE").get(null);
                tryInterval = (SocketOption)eso.getField("TCP_KEEPINTERVAL").get(null);
                extendedKeepAlive = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            TCP_KEEPCOUNT = tryCount;
            TCP_KEEPIDLE = tryIdle;
            TCP_KEEPINTERVAL = tryInterval;
            WITH_EXTENDED_KEEPALIVE = extendedKeepAlive;
        }
    }
}

