/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.testFramework.SkipInHeadlessEnvironment;
import com.intellij.testFramework.SkipSlowTestLocally;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.fixtures.BareTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/fixtures/TestFixtureRule;", "Lorg/junit/rules/ExternalResource;", "<init>", "()V", "value", "Lcom/intellij/testFramework/fixtures/BareTestFixture;", "fixture", "getFixture", "()Lcom/intellij/testFramework/fixtures/BareTestFixture;", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "before", "", "after", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nTestFixtureRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestFixtureRule.kt\ncom/intellij/testFramework/fixtures/TestFixtureRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class TestFixtureRule
extends ExternalResource {
    private BareTestFixture fixture;

    @NotNull
    public final BareTestFixture getFixture() {
        BareTestFixture bareTestFixture = this.fixture;
        if (bareTestFixture != null) {
            return bareTestFixture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fixture");
        return null;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        ApplicationManagerEx.setInStressTest((boolean)TestFrameworkUtil.isStressTest(description.getMethodName(), description.getClassName()));
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)statement2, (String)"apply(...)");
        return statement2;
    }

    /*
     * WARNING - void declaration
     */
    protected void before() {
        void it;
        BareTestFixture bareTestFixture;
        boolean headless = TestFrameworkUtil.SKIP_HEADLESS && ((Object)((Object)this)).getClass().getAnnotation(SkipInHeadlessEnvironment.class) != null;
        Assume.assumeFalse((String)("Class '" + ((Object)((Object)this)).getClass().getName() + "' is skipped because it requires working UI environment"), (boolean)headless);
        boolean slow = TestFrameworkUtil.SKIP_SLOW && ((Object)((Object)this)).getClass().getAnnotation(SkipSlowTestLocally.class) != null;
        Assume.assumeFalse((String)("Class '" + ((Object)((Object)this)).getClass().getName() + "' is skipped because it is dog slow"), (boolean)slow);
        BareTestFixture bareTestFixture2 = IdeaTestFixtureFactory.getFixtureFactory().createBareFixture();
        Intrinsics.checkNotNullExpressionValue((Object)bareTestFixture2, (String)"createBareFixture(...)");
        BareTestFixture bareTestFixture3 = bareTestFixture = bareTestFixture2;
        TestFixtureRule testFixtureRule = this;
        boolean bl = false;
        it.setUp();
        testFixtureRule.fixture = bareTestFixture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        try {
            this.getFixture().tearDown();
        }
        finally {
            ApplicationManagerEx.setInStressTest((boolean)false);
        }
    }
}

