/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.bucketing;

import com.intellij.TestCaseLoader;
import com.intellij.nastradamus.NastradamusClient;
import com.intellij.teamcity.TeamCityClient;
import com.intellij.testFramework.bucketing.BucketingScheme;
import com.intellij.testFramework.bucketing.HashingBucketingScheme;
import java.net.URI;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class NastradamusBucketingScheme
implements BucketingScheme {
    protected NastradamusClient myNastradamusClient;

    @Override
    public void initialize() {
        if (this.myNastradamusClient != null) {
            return;
        }
        this.myNastradamusClient = NastradamusBucketingScheme.initNastradamus();
    }

    @Nullable
    public NastradamusClient getNastradamusClient() {
        return this.myNastradamusClient;
    }

    @Override
    public boolean matchesCurrentBucket(@NotNull String testIdentifier) {
        if (testIdentifier == null) {
            NastradamusBucketingScheme.$$$reportNull$$$0(0);
        }
        return this.matchesBucketViaNastradamus(testIdentifier);
    }

    protected boolean matchesBucketViaNastradamus(@NotNull String testIdentifier) {
        if (testIdentifier == null) {
            NastradamusBucketingScheme.$$$reportNull$$$0(1);
        }
        try {
            return this.myNastradamusClient.isClassInBucket(testIdentifier, (Function1<? super String, Boolean>)((Function1)testClassName -> HashingBucketingScheme.matchesCurrentBucketViaHashing(testClassName)));
        }
        catch (Exception e) {
            return HashingBucketingScheme.matchesCurrentBucketViaHashing(testIdentifier);
        }
    }

    private static synchronized NastradamusClient initNastradamus() {
        List<Class<?>> testCaseClasses = TestCaseLoader.loadClassesForWarmup();
        NastradamusClient nastradamus = null;
        try {
            System.out.println("Caching data from Nastradamus and TeamCity ...");
            nastradamus = new NastradamusClient(new URI(System.getProperty("idea.nastradamus.url")).normalize(), testCaseClasses, new TeamCityClient());
            nastradamus.getRankedClasses();
            System.out.println("Caching data from Nastradamus and TeamCity finished");
        }
        catch (Exception e) {
            System.err.println("Unexpected exception during Nastradamus client instance initialization");
            e.printStackTrace();
        }
        return nastradamus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "testIdentifier";
        objectArray2[1] = "com/intellij/testFramework/bucketing/NastradamusBucketingScheme";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesCurrentBucket";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesBucketViaNastradamus";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

