/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.lang;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vcs.changes.ignore.lang.Syntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.util.ArrayUtilRt;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreLanguage
extends Language {
    public static final IgnoreLanguage INSTANCE = new IgnoreLanguage();
    @NonNls
    private static final String DOT = ".";
    @NotNull
    private final String myExtension;

    protected IgnoreLanguage() {
        this("IgnoreLang", "ignore");
    }

    protected IgnoreLanguage(@NotNull @NonNls String name, @NotNull @NonNls String extension) {
        if (name == null) {
            IgnoreLanguage.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            IgnoreLanguage.$$$reportNull$$$0(1);
        }
        super((Language)INSTANCE, name, ArrayUtilRt.EMPTY_STRING_ARRAY);
        this.myExtension = extension;
    }

    @NotNull
    public String getExtension() {
        String string = this.myExtension;
        if (string == null) {
            IgnoreLanguage.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFilename() {
        String string = DOT + this.getExtension();
        if (string == null) {
            IgnoreLanguage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getFilename() + " (" + this.getID() + ")";
        if (string == null) {
            IgnoreLanguage.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Vcs.Ignore_file;
    }

    @NotNull
    public IgnoreFileType getFileType() {
        IgnoreFileType ignoreFileType = IgnoreFileType.INSTANCE;
        if (ignoreFileType == null) {
            IgnoreLanguage.$$$reportNull$$$0(5);
        }
        return ignoreFileType;
    }

    @NotNull
    public final IgnoreFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            IgnoreLanguage.$$$reportNull$$$0(6);
        }
        return new IgnoreFile(viewProvider, this.getFileType());
    }

    public boolean isSyntaxSupported() {
        return false;
    }

    @NotNull
    public Syntax getDefaultSyntax() {
        Syntax syntax = Syntax.GLOB;
        if (syntax == null) {
            IgnoreLanguage.$$$reportNull$$$0(7);
        }
        return syntax;
    }

    @Nullable
    public VirtualFile getAffectedRoot(@NotNull Project project, @NotNull VirtualFile ignoreFile) {
        if (project == null) {
            IgnoreLanguage.$$$reportNull$$$0(8);
        }
        if (ignoreFile == null) {
            IgnoreLanguage.$$$reportNull$$$0(9);
        }
        return ignoreFile.getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/lang/IgnoreLanguage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/lang/IgnoreLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilename";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSyntax";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

