/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollections;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Set;

public final class ShortSets {
    public static final EmptySet EMPTY_SET = new EmptySet();
    static final ShortSet UNMODIFIABLE_EMPTY_SET = ShortSets.unmodifiable(new ShortArraySet(ShortArrays.EMPTY_ARRAY));

    public static ShortSet unmodifiable(ShortSet s) {
        return new UnmodifiableSet(s);
    }

    public static class EmptySet
    extends ShortCollections.EmptyCollection
    implements ShortSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public boolean remove(short ok) {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        @Override
        @Deprecated
        public boolean rem(short k) {
            return super.rem(k);
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    public static class UnmodifiableSet
    extends ShortCollections.UnmodifiableCollection
    implements ShortSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected UnmodifiableSet(ShortSet s) {
            super(s);
        }

        @Override
        public boolean remove(short k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.collection.equals(o);
        }

        @Override
        public int hashCode() {
            return this.collection.hashCode();
        }

        @Override
        @Deprecated
        public boolean rem(short k) {
            return super.rem(k);
        }
    }
}

