/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.relocated.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.jetbrains.relocated.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMRectElement;
import org.jetbrains.relocated.apache.batik.bridge.Bridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGShapeElementBridge;
import org.jetbrains.relocated.apache.batik.dom.svg.LiveAttributeException;
import org.jetbrains.relocated.apache.batik.gvt.ShapeNode;
import org.jetbrains.relocated.apache.batik.gvt.ShapePainter;
import org.w3c.dom.Element;

public class SVGRectElementBridge
extends SVGShapeElementBridge {
    @Override
    public String getLocalName() {
        return "rect";
    }

    @Override
    public Bridge getInstance() {
        return new SVGRectElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext ctx2, Element e, ShapeNode shapeNode) {
        try {
            AbstractSVGAnimatedLength _ry;
            float ry;
            SVGOMRectElement re = (SVGOMRectElement)e;
            AbstractSVGAnimatedLength _x = (AbstractSVGAnimatedLength)re.getX();
            float x2 = _x.getCheckedValue();
            AbstractSVGAnimatedLength _y = (AbstractSVGAnimatedLength)re.getY();
            float y2 = _y.getCheckedValue();
            AbstractSVGAnimatedLength _width = (AbstractSVGAnimatedLength)re.getWidth();
            float w = _width.getCheckedValue();
            AbstractSVGAnimatedLength _height = (AbstractSVGAnimatedLength)re.getHeight();
            float h = _height.getCheckedValue();
            AbstractSVGAnimatedLength _rx = (AbstractSVGAnimatedLength)re.getRx();
            float rx = _rx.getCheckedValue();
            if (rx > w / 2.0f) {
                rx = w / 2.0f;
            }
            if ((ry = (_ry = (AbstractSVGAnimatedLength)re.getRy()).getCheckedValue()) > h / 2.0f) {
                ry = h / 2.0f;
            }
            RectangularShape shape = rx == 0.0f || ry == 0.0f ? new Rectangle2D.Float(x2, y2, w, h) : new RoundRectangle2D.Float(x2, y2, w, h, rx * 2.0f, ry * 2.0f);
            shapeNode.setShape(shape);
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx2, ex);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        String ln;
        if (alav.getNamespaceURI() == null && ((ln = alav.getLocalName()).equals("x") || ln.equals("y") || ln.equals("width") || ln.equals("height") || ln.equals("rx") || ln.equals("ry"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    @Override
    protected ShapePainter createShapePainter(BridgeContext ctx2, Element e, ShapeNode shapeNode) {
        Shape shape = shapeNode.getShape();
        Rectangle2D r2d = shape.getBounds2D();
        if (r2d.getWidth() == 0.0 || r2d.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(ctx2, e, shapeNode);
    }
}

