/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.relocated.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.SVGUtilities;
import org.jetbrains.relocated.apache.batik.ext.awt.image.CompositeRule;
import org.jetbrains.relocated.apache.batik.ext.awt.image.PadMode;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.CompositeRable8Bit;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.Filter;
import org.jetbrains.relocated.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeBlendElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feBlend";
    }

    @Override
    public Filter createFilter(BridgeContext ctx2, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        CompositeRule rule = SVGFeBlendElementBridge.convertMode(filterElement, ctx2);
        Filter in = SVGFeBlendElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx2);
        if (in == null) {
            return null;
        }
        Filter in2 = SVGFeBlendElementBridge.getIn2(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx2);
        if (in2 == null) {
            return null;
        }
        Rectangle2D defaultRegion = (Rectangle2D)in.getBounds2D().clone();
        defaultRegion.add(in2.getBounds2D());
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx2);
        ArrayList<Filter> srcs = new ArrayList<Filter>(2);
        srcs.add(in2);
        srcs.add(in);
        AbstractRable filter2 = new CompositeRable8Bit(srcs, rule, true);
        SVGFeBlendElementBridge.handleColorInterpolationFilters(filter2, filterElement);
        filter2 = new PadRable8Bit(filter2, primitiveRegion, PadMode.ZERO_PAD);
        SVGFeBlendElementBridge.updateFilterMap(filterElement, filter2, filterMap);
        return filter2;
    }

    protected static CompositeRule convertMode(Element filterElement, BridgeContext ctx2) {
        String rule = filterElement.getAttributeNS(null, "mode");
        if (rule.length() == 0) {
            return CompositeRule.OVER;
        }
        if ("normal".equals(rule)) {
            return CompositeRule.OVER;
        }
        if ("multiply".equals(rule)) {
            return CompositeRule.MULTIPLY;
        }
        if ("screen".equals(rule)) {
            return CompositeRule.SCREEN;
        }
        if ("darken".equals(rule)) {
            return CompositeRule.DARKEN;
        }
        if ("lighten".equals(rule)) {
            return CompositeRule.LIGHTEN;
        }
        throw new BridgeException(ctx2, filterElement, "attribute.malformed", new Object[]{"mode", rule});
    }
}

