/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.random.RandomString;
import org.jetbrains.letsPlot.commons.logging.Logger;
import org.jetbrains.letsPlot.commons.logging.PortableLogging;
import org.jetbrains.letsPlot.core.commons.jsObject.JsObjectSupportCommon;
import org.jetbrains.letsPlot.core.spec.PlotConfigUtil;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002JJ\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u000eJ\u001a\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J:\u0010\u001b\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00132\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotHtmlHelper;", "", "()V", "ATT_SCRIPT_KIND", "", "LOG", "Lorg/jetbrains/letsPlot/commons/logging/Logger;", "SCRIPT_KIND_LIB_LOADING", "SCRIPT_KIND_PLOT", "getDisplayHtmlForProcessedSpecs", "plotSpecAsJsObjectInitializer", "sizingPolicy", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "dynamicScriptLoading", "", "forceImmediateRender", "responsive", "getDisplayHtmlForRawSpec", "plotSpec", "", "removeComputationMessages", "logComputationMessages", "getDynamicConfigureHtml", "scriptUrl", "verbose", "getDynamicDisplayHtmlForRawSpec", "getStaticConfigureHtml", "getStaticDisplayHtmlForRawSpec", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "version", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nPlotHtmlHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotHtmlHelper.kt\norg/jetbrains/letsPlot/core/util/PlotHtmlHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1855#2,2:263\n*S KotlinDebug\n*F\n+ 1 PlotHtmlHelper.kt\norg/jetbrains/letsPlot/core/util/PlotHtmlHelper\n*L\n154#1:263,2\n*E\n"})
public final class PlotHtmlHelper {
    @NotNull
    public static final PlotHtmlHelper INSTANCE = new PlotHtmlHelper();
    @NotNull
    private static final Logger LOG = PortableLogging.INSTANCE.logger(Reflection.getOrCreateKotlinClass(PlotHtmlHelper.class));
    @NotNull
    private static final String ATT_SCRIPT_KIND = "data-lets-plot-script";
    @NotNull
    private static final String SCRIPT_KIND_LIB_LOADING = "library";
    @NotNull
    private static final String SCRIPT_KIND_PLOT = "plot";

    private PlotHtmlHelper() {
    }

    @NotNull
    public final String scriptUrl(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        boolean dev = StringsKt.contains$default((CharSequence)version, (CharSequence)"dev", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
        return dev ? "http://127.0.0.1:8080/js-package/build/dist/js/developmentExecutable/lets-plot.js" : "https://cdn.jsdelivr.net/gh/JetBrains/lets-plot@v" + version + "/js-package/distr/lets-plot.min.js";
    }

    @NotNull
    public final String getDynamicConfigureHtml(@NotNull String scriptUrl, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        String outputId = RandomString.INSTANCE.randomString(6);
        String successMessage = verbose ? StringsKt.trimMargin$default((String)("\n            |   var div = document.createElement(\"div\");\n            |   div.style.color = 'darkblue';\n            |   div.textContent = 'Lets-Plot JS successfully loaded.';\n            |   document.getElementById(\"" + outputId + "\").appendChild(div);\n            "), null, (int)1, null) : "";
        return StringsKt.trimMargin$default((String)("\n            |   <div id=\"" + outputId + "\"></div>\n            |   <script type=\"text/javascript\" data-lets-plot-script=\"library\">\n            |       if(!window.letsPlotCallQueue) {\n            |           window.letsPlotCallQueue = [];\n            |       }; \n            |       window.letsPlotCall = function(f) {\n            |           window.letsPlotCallQueue.push(f);\n            |       };\n            |       (function() {\n            |           var script = document.createElement(\"script\");\n            |           script.type = \"text/javascript\";\n            |           script.src = \"" + scriptUrl + "\";\n            |           script.onload = function() {\n            |               window.letsPlotCall = function(f) {f();};\n            |               window.letsPlotCallQueue.forEach(function(f) {f();});\n            |               window.letsPlotCallQueue = [];\n            |               \n            |               " + successMessage + "\n            |           };\n            |           script.onerror = function(event) {\n            |               window.letsPlotCall = function(f) {};\n            |               window.letsPlotCallQueue = [];\n            |               var div = document.createElement(\"div\");\n            |               div.style.color = 'darkred';\n            |               div.textContent = 'Error loading Lets-Plot JS';\n            |               document.getElementById(\"" + outputId + "\").appendChild(div);\n            |           };\n            |           var e = document.getElementById(\"" + outputId + "\");\n            |           e.appendChild(script);\n            |       })();\n            |   </script>\n        "), null, (int)1, null);
    }

    @NotNull
    public final String getDynamicDisplayHtmlForRawSpec(@NotNull Map<String, Object> plotSpec) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        return this.getDisplayHtmlForRawSpec(plotSpec, SizingPolicy.Companion.notebookCell(), true, false, false, false, false);
    }

    @NotNull
    public final String getStaticConfigureHtml(@NotNull String scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        return "<script type=\"text/javascript\" data-lets-plot-script=\"library\" src=\"" + scriptUrl + "\"></script>";
    }

    @NotNull
    public final String getStaticDisplayHtmlForRawSpec(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector size2, boolean removeComputationMessages2, boolean logComputationMessages) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        SizingPolicy sizingPolicy = size2 == null ? SizingPolicy.Companion.notebookCell() : SizingPolicy.Companion.fixed(size2.getX(), size2.getY());
        return this.getDisplayHtmlForRawSpec(plotSpec, sizingPolicy, false, false, false, removeComputationMessages2, logComputationMessages);
    }

    public static /* synthetic */ String getStaticDisplayHtmlForRawSpec$default(PlotHtmlHelper plotHtmlHelper, Map map2, DoubleVector doubleVector, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            doubleVector = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return plotHtmlHelper.getStaticDisplayHtmlForRawSpec(map2, doubleVector, bl, bl2);
    }

    @NotNull
    public final String getDisplayHtmlForRawSpec(@NotNull Map<String, Object> plotSpec, @NotNull SizingPolicy sizingPolicy, boolean dynamicScriptLoading, boolean forceImmediateRender, boolean responsive, boolean removeComputationMessages2, boolean logComputationMessages) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
        Map plotSpec2 = MonolithicCommon.processRawSpecs$default(MonolithicCommon.INSTANCE, plotSpec, false, 2, null);
        if (logComputationMessages) {
            Iterable $this$forEach$iv = PlotConfigUtil.INSTANCE.findComputationMessages(plotSpec2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                LOG.info((Function0<String>)((Function0)new Function0<String>(it){
                    final /* synthetic */ String $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "[when HTML generating] " + this.$it;
                    }
                }));
            }
        }
        if (removeComputationMessages2) {
            PlotConfigUtil.INSTANCE.removeComputationMessages(plotSpec2);
        }
        String plotSpecJs = JsObjectSupportCommon.INSTANCE.mapToJsObjectInitializer(plotSpec2);
        return this.getDisplayHtmlForProcessedSpecs(plotSpecJs, sizingPolicy, dynamicScriptLoading, forceImmediateRender, responsive);
    }

    private final String getDisplayHtmlForProcessedSpecs(String plotSpecAsJsObjectInitializer, SizingPolicy sizingPolicy, boolean dynamicScriptLoading, boolean forceImmediateRender, boolean responsive) {
        String outputId = RandomString.INSTANCE.randomString(6);
        return StringsKt.trimMargin$default((String)("\n        |   <div id=\"" + outputId + "\"></div>\n        |   <script type=\"text/javascript\" data-lets-plot-script=\"plot\">\n        |   \n        |   (function() {\n        |   // ----------\n        |   \n        |   const forceImmediateRender = " + forceImmediateRender + ";\n        |   const responsive = " + responsive + ";\n        |   \n        |   let sizing = {\n        |       width_mode: \"" + (Object)((Object)sizingPolicy.getWidthMode()) + "\",\n        |       height_mode: \"" + (Object)((Object)sizingPolicy.getHeightMode()) + "\",\n        |       width: " + sizingPolicy.getWidth() + ", \n        |       height: " + sizingPolicy.getHeight() + " \n        |   };\n        |   \n        |   const preferredWidth = document.body.dataset.letsPlotPreferredWidth;\n        |   if (preferredWidth !== undefined) {\n        |       sizing = {\n        |           width_mode: 'FIXED',\n        |           height_mode: 'SCALED',\n        |           width: parseFloat(preferredWidth)\n        |       };\n        |   }\n        |   \n        |   const containerDiv = document.getElementById(\"" + outputId + "\");\n        |   let fig = null;\n        |   \n        |   function renderPlot() {\n        |       if (fig === null) {\n        |           const plotSpec = " + plotSpecAsJsObjectInitializer + ";\n        |           " + (dynamicScriptLoading ? "window.letsPlotCall(function() { fig = LetsPlot.buildPlotFromProcessedSpecs(plotSpec, containerDiv, sizing); });" : "fig = LetsPlot.buildPlotFromProcessedSpecs(plotSpec, containerDiv, sizing);") + "\n        |       } else {\n        |           fig.updateView({});\n        |       }\n        |   }\n        |   \n        |   const renderImmediately = \n        |       forceImmediateRender || (\n        |           sizing.width_mode === 'FIXED' && \n        |           (sizing.height_mode === 'FIXED' || sizing.height_mode === 'SCALED')\n        |       );\n        |   \n        |   if (renderImmediately) {\n        |       renderPlot();\n        |   }\n        |   \n        |   if (!renderImmediately || responsive) {\n        |       // Set up observer for initial sizing or continuous monitoring\n        |       var observer = new ResizeObserver(function(entries) {\n        |           for (let entry of entries) {\n        |               if (entry.contentBoxSize && \n        |                   entry.contentBoxSize[0].inlineSize > 0) {\n        |                   if (!responsive && observer) {\n        |                       observer.disconnect();\n        |                       observer = null;\n        |                   }\n        |                   renderPlot();\n        |                   if (!responsive) {\n        |                       break;\n        |                   }\n        |               }\n        |           }\n        |       });\n        |       \n        |       observer.observe(containerDiv);\n        |   }\n        |   \n        |   // ----------\n        |   })();\n        |   \n        |   </script>\n    "), null, (int)1, null);
    }
}

