/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendJustification;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxesLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendsBlockInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxesLayout;", "", "outerBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "innerBounds", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;)V", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendsBlockInfo;", "legendsBlockInfo", "BoxWithLocation", "plot-builder"})
public final class LegendBoxesLayout {
    @NotNull
    private final DoubleRectangle outerBounds;
    @NotNull
    private final DoubleRectangle innerBounds;
    @NotNull
    private final LegendTheme theme;

    public LegendBoxesLayout(@NotNull DoubleRectangle outerBounds, @NotNull DoubleRectangle innerBounds, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)outerBounds, (String)"outerBounds");
        Intrinsics.checkNotNullParameter((Object)innerBounds, (String)"innerBounds");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.outerBounds = outerBounds;
        this.innerBounds = innerBounds;
        this.theme = theme;
    }

    @NotNull
    public final LegendsBlockInfo doLayout(@NotNull LegendsBlockInfo legendsBlockInfo) {
        Intrinsics.checkNotNullParameter((Object)legendsBlockInfo, (String)"legendsBlockInfo");
        LegendPosition legendPosition = this.theme.position();
        LegendJustification legendJustification = this.theme.justification();
        DoubleVector blockSize = legendsBlockInfo.size();
        DoubleVector legendOrigin = legendPosition.isFixed() ? LegendBoxesLayoutUtil.INSTANCE.overlayLegendOriginOutsidePlot(this.innerBounds, this.outerBounds, blockSize, legendPosition, legendJustification) : LegendBoxesLayoutUtil.INSTANCE.overlayLegendOriginInsidePlot(this.innerBounds, blockSize, legendPosition, legendJustification);
        return legendsBlockInfo.moveAll(legendOrigin);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxesLayout$BoxWithLocation;", "", "legendBox", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "getLegendBox", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "getLocation", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "bounds$plot_builder", "size", "size$plot_builder", "plot-builder"})
    public static final class BoxWithLocation {
        @NotNull
        private final LegendBoxInfo legendBox;
        @NotNull
        private final DoubleVector location;

        public BoxWithLocation(@NotNull LegendBoxInfo legendBox, @NotNull DoubleVector location2) {
            Intrinsics.checkNotNullParameter((Object)legendBox, (String)"legendBox");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            this.legendBox = legendBox;
            this.location = location2;
        }

        @NotNull
        public final LegendBoxInfo getLegendBox() {
            return this.legendBox;
        }

        @NotNull
        public final DoubleVector getLocation() {
            return this.location;
        }

        @NotNull
        public final DoubleVector size$plot_builder() {
            return this.legendBox.getSize$plot_builder();
        }

        @NotNull
        public final DoubleRectangle bounds$plot_builder() {
            return new DoubleRectangle(this.location, this.legendBox.getSize$plot_builder());
        }
    }
}

