/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetStripTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetsTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.facet.FixedScalesTilesLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.facet.FreeScalesTilesLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "layoutProviderByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "plotTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "facetsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;)V", "insets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "totalAddedHSize", "", "totalAddedVSize", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nFacetedPlotLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,293:1\n1#2:294\n1#2:329\n1490#3:295\n1520#3,3:296\n1523#3,3:306\n1238#3,2:311\n1855#3:313\n1864#3,3:314\n1856#3:317\n1241#3:318\n1603#3,9:319\n1855#3:328\n1856#3:330\n1612#3:331\n2661#3,7:332\n1549#3:339\n1620#3,3:340\n372#4,7:299\n453#4:309\n403#4:310\n*S KotlinDebug\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout\n*L\n85#1:329\n61#1:295\n61#1:296,3\n61#1:306,3\n62#1:311,2\n64#1:313\n65#1:314,3\n64#1:317\n62#1:318\n85#1:319,9\n85#1:328\n85#1:330\n85#1:331\n202#1:332,7\n230#1:339\n230#1:340,3\n61#1:299,7\n62#1:309\n62#1:310\n*E\n"})
public final class FacetedPlotLayout
implements PlotLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final List<TileLayoutProvider> layoutProviderByTile;
    @NotNull
    private final AxisTheme hAxisTheme;
    @NotNull
    private final AxisTheme vAxisTheme;
    @NotNull
    private final PlotTheme plotTheme;
    @NotNull
    private final FacetsTheme facetsTheme;
    private final double totalAddedHSize;
    private final double totalAddedVSize;
    @NotNull
    private final Insets insets;
    public static final int FACET_PADDING = 3;
    private static final double PANEL_PADDING = 10.0;

    public FacetedPlotLayout(@NotNull PlotFacets facets, @NotNull List<? extends TileLayoutProvider> layoutProviderByTile, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme, @NotNull PlotTheme plotTheme, @NotNull FacetsTheme facetsTheme) {
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        Intrinsics.checkNotNullParameter((Object)facetsTheme, (String)"facetsTheme");
        this.facets = facets;
        this.layoutProviderByTile = layoutProviderByTile;
        this.hAxisTheme = hAxisTheme;
        this.vAxisTheme = vAxisTheme;
        this.plotTheme = plotTheme;
        this.facetsTheme = facetsTheme;
        this.totalAddedHSize = 10.0 * (double)(this.facets.getColCount() - 1);
        this.totalAddedVSize = 10.0 * (double)(this.facets.getRowCount() - 1);
        this.insets = PlotLayoutUtil.INSTANCE.plotInsets$plot_builder(this.plotTheme.plotInset());
        if (!this.facets.isDefined()) {
            boolean bl = false;
            String string = "Undefined facets.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        void $this$reduce$iv;
        Object $i$f$mapValues22;
        PlotFacets.FacetTileInfo it;
        Map destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Thickness plotLayoutMargins = this.plotTheme.layoutMargins();
        DoubleVector tilesAreaSize = new DoubleVector(preferredSize.getX() - (this.insets.getLeft() + this.insets.getRight()), preferredSize.getY() - (this.insets.getTop() + this.insets.getBottom())).subtract(new DoubleVector(plotLayoutMargins.getWidth(), plotLayoutMargins.getHeight()));
        List<PlotFacets.FacetTileInfo> facetTiles = this.facets.tileInfos();
        Map facetColTabHeights = null;
        double facetRowTabWidth = 0.0;
        double totalAddedHeight = 0.0;
        double totalAddedWidth = 0.0;
        if (this.facetsTheme.horizontalFacetStrip().showStrip()) {
            void $this$mapValuesTo$iv$iv22;
            Iterable $this$mapValues$iv;
            Object object;
            Object value$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Iterable iterable = facetTiles;
            boolean $i$f$groupBy = false;
            void var15_13 = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it2;
                Object object2;
                PlotFacets.FacetTileInfo it3 = (PlotFacets.FacetTileInfo)element$iv$iv;
                boolean $i$a$-groupBy-FacetedPlotLayout$doLayout$32 = false;
                key$iv$iv = it3.getRow();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                PlotFacets.FacetTileInfo $i$a$-groupBy-FacetedPlotLayout$doLayout$32 = (PlotFacets.FacetTileInfo)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                object.add(it2.getColLabs());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues22 = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv22.entrySet();
            boolean $i$f$associateByTo2 = false;
            for (Iterator<Object> element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
                void it$iv$iv;
                key$iv$iv = (Map.Entry)((Object)element$iv$iv$iv);
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)((Object)element$iv$iv$iv);
                Object k = it$iv$iv.getKey();
                object = $this$getOrPut$iv$iv$iv;
                boolean bl2 = false;
                HashMap subColLabels = new HashMap();
                Iterable $this$forEach$iv = (Iterable)it.getValue();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    List colLabs = (List)element$iv;
                    boolean bl3 = false;
                    Iterable $this$forEachIndexed$iv = colLabs;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void colLab;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv;
                        int index2 = n;
                        boolean bl4 = false;
                        double labHeight2 = Companion.facetLabelSize((String)colLab, this.facetsTheme.horizontalFacetStrip(), (Function1<? super Thickness, Double>)((Function1)doLayout.3.1.1.labHeight.1.INSTANCE));
                        Map map2 = subColLabels;
                        Integer n2 = index2;
                        Double d = (Double)subColLabels.get(index2);
                        if (d == null) {
                            d = 0.0;
                        }
                        Double d2 = d;
                        Intrinsics.checkNotNull((Object)d2);
                        double d3 = ((Number)d2).doubleValue();
                        d2 = Math.max(labHeight2, d3);
                        map2.put(n2, d2);
                    }
                }
                Collection collection = subColLabels.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                List list2 = CollectionsKt.toList((Iterable)collection);
                object.put(k, list2);
            }
            facetColTabHeights = destination$iv$iv;
            $this$mapValues$iv = facetColTabHeights.values();
            $i$f$mapValues22 = Companion;
            double $this$mapValuesTo$iv$iv22 = 0.0;
            for (Iterable $this$associateByTo$iv$iv$iv2 : $this$mapValues$iv) {
                void p0;
                List $i$f$associateByTo2 = (List)$this$associateByTo$iv$iv$iv2;
                double d = $this$mapValuesTo$iv$iv22;
                boolean bl = false;
                double d4 = ((Companion)$i$f$mapValues22).facetColHeadTotalHeight((List<Double>)p0);
                $this$mapValuesTo$iv$iv22 = d + d4;
            }
            totalAddedHeight = $this$mapValuesTo$iv$iv22;
        } else {
            facetColTabHeights = MapsKt.emptyMap();
            totalAddedHeight = 0.0;
        }
        if (this.facetsTheme.verticalFacetStrip().showStrip()) {
            Double d;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterator<Object> element$iv$iv$iv;
            $i$f$mapValues22 = facetTiles;
            boolean $i$f$mapNotNull22 = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            element$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv$iv.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
                boolean bl = false;
                it = (PlotFacets.FacetTileInfo)element$iv$iv;
                boolean bl5 = false;
                if (it.getRowLab() == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterator $i$f$mapNotNull22 = ((Iterable)((List)destination$iv$iv2)).iterator();
            if (!$i$f$mapNotNull22.hasNext()) {
                d = null;
            } else {
                String it4 = (String)$i$f$mapNotNull22.next();
                boolean bl = false;
                double $i$f$mapNotNullTo2 = Companion.facetLabelSize(it4, this.facetsTheme.verticalFacetStrip(), (Function1<? super Thickness, Double>)((Function1)doLayout.6.1.INSTANCE));
                while ($i$f$mapNotNull22.hasNext()) {
                    String it5 = (String)$i$f$mapNotNull22.next();
                    $i$a$-maxOfOrNull-FacetedPlotLayout$doLayout$72 = false;
                    double element$iv$iv$iv2 = Companion.facetLabelSize(it5, this.facetsTheme.verticalFacetStrip(), (Function1<? super Thickness, Double>)((Function1)doLayout.6.1.INSTANCE));
                    $i$f$mapNotNullTo2 = Math.max($i$f$mapNotNullTo2, element$iv$iv$iv2);
                }
                d = $i$f$mapNotNullTo2;
            }
            facetRowTabWidth = d != null ? d : 0.0;
            totalAddedWidth = facetRowTabWidth + (double)3;
        } else {
            facetRowTabWidth = 0.0;
            totalAddedWidth = 0.0;
        }
        Function1 facetColHeadHeightGetter2 = (Function1)new Function1<PlotFacets.FacetTileInfo, Double>((Map<Integer, ? extends List<Double>>)facetColTabHeights, this){
            final /* synthetic */ Map<Integer, List<Double>> $facetColTabHeights;
            final /* synthetic */ FacetedPlotLayout this$0;
            {
                this.$facetColTabHeights = $facetColTabHeights;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull PlotFacets.FacetTileInfo facetTile) {
                double d;
                Intrinsics.checkNotNullParameter((Object)facetTile, (String)"facetTile");
                List<Double> list2 = this.$facetColTabHeights.get(facetTile.getRow());
                if (list2 != null) {
                    List<Double> list3 = list2;
                    Companion companion = FacetedPlotLayout.Companion;
                    List<Double> p0 = list3;
                    boolean bl = false;
                    d = companion.facetColHeadTotalHeight(p0);
                } else {
                    d = org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout$Companion.access$facetColHeadTotalHeight(FacetedPlotLayout.Companion, facetTile.getColLabs(), FacetedPlotLayout.access$getFacetsTheme$p(this.this$0).horizontalFacetStrip());
                }
                return d;
            }
        };
        DoubleVector labsTotalDim = new DoubleVector(totalAddedWidth, totalAddedHeight);
        tilesAreaSize = tilesAreaSize.subtract(labsTotalDim);
        List<TileLayoutInfo> layoutInfos = this.facets.getFreeHScale() || this.facets.getFreeVScale() ? FreeScalesTilesLayouter.INSTANCE.createTileLayoutInfos(tilesAreaSize, this.facets, this.layoutProviderByTile, this.totalAddedHSize, this.totalAddedVSize, coordProvider, this.hAxisTheme, this.vAxisTheme) : FixedScalesTilesLayouter.INSTANCE.createTileLayoutInfos(tilesAreaSize, this.facets, this.layoutProviderByTile, this.totalAddedHSize, this.totalAddedVSize, coordProvider, this.hAxisTheme, this.vAxisTheme);
        List<Double> geomOffsetByCol = FacetedPlotLayoutUtil.INSTANCE.geomOffsetsByCol(layoutInfos, facetTiles, 10.0, this.facets.getColCount());
        List<Double> geomOffsetByRow = FacetedPlotLayoutUtil.INSTANCE.geomOffsetsByRow(layoutInfos, facetTiles, this.facetsTheme.horizontalFacetStrip().showStrip(), 10.0, this.facets.getRowCount(), (Function1<? super PlotFacets.FacetTileInfo, Double>)facetColHeadHeightGetter2);
        ArrayList<DoubleRectangle> tileBoundsList = new ArrayList<DoubleRectangle>();
        ArrayList<DoubleRectangle> geomOuterBoundsList = new ArrayList<DoubleRectangle>();
        Iterator<PlotFacets.FacetTileInfo> it5 = facetTiles.iterator();
        int $i$a$-maxOfOrNull-FacetedPlotLayout$doLayout$72 = 0;
        while (it5.hasNext()) {
            int index = $i$a$-maxOfOrNull-FacetedPlotLayout$doLayout$72++;
            PlotFacets.FacetTileInfo facetTile = it5.next();
            TileLayoutInfo layoutInfo = layoutInfos.get(index);
            int col = facetTile.getCol();
            int row = facetTile.getRow();
            double geomX = ((Number)geomOffsetByCol.get(col)).doubleValue();
            double geomY = ((Number)geomOffsetByRow.get(row)).doubleValue();
            DoubleVector outerGeomSize = layoutInfo.getGeomOuterBounds().getDimension();
            double tileLabelWidth = facetTile.getRowLab() != null && this.facetsTheme.verticalFacetStrip().showStrip() ? facetRowTabWidth + (double)3 : 0.0;
            double axisWidth = facetTile.getHasVAxis() ? layoutInfo.axisThicknessY() : 0.0;
            double tileX = geomX - axisWidth;
            double tileWidth = outerGeomSize.getX() + axisWidth + tileLabelWidth;
            double tileLabelHeight = this.facetsTheme.horizontalFacetStrip().showStrip() ? ((Number)facetColHeadHeightGetter2.invoke((Object)facetTile)).doubleValue() : 0.0;
            double axisHeight = facetTile.getHasHAxis() ? layoutInfo.axisThicknessX() : 0.0;
            double tileY = geomY - tileLabelHeight;
            double tileHeight = outerGeomSize.getY() + tileLabelHeight + axisHeight;
            DoubleRectangle tileBounds = new DoubleRectangle(new DoubleVector(tileX, tileY), new DoubleVector(tileWidth, tileHeight));
            DoubleRectangle geomOuterBounds = new DoubleRectangle(new DoubleVector(geomX, geomY), outerGeomSize);
            tileBoundsList.add(tileBounds);
            geomOuterBoundsList.add(geomOuterBounds);
        }
        Iterable $i$a$-maxOfOrNull-FacetedPlotLayout$doLayout$72 = tileBoundsList;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b1;
            DoubleRectangle col = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle b0 = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = b0.union((DoubleRectangle)b1);
        }
        DoubleVector tilesAreaOrigin = ((DoubleRectangle)accumulator$iv).getOrigin();
        DoubleVector originDelta = tilesAreaOrigin.negate();
        DoubleVector tilesPaddingLeftTop = this.insets.getLeftTop();
        ArrayList<TileLayoutInfo> finalLayoutInfos = new ArrayList<TileLayoutInfo>();
        accumulator$iv = facetTiles.iterator();
        int n = 0;
        while (accumulator$iv.hasNext()) {
            Pair pair2;
            List list3;
            int index = n++;
            PlotFacets.FacetTileInfo facetTile = (PlotFacets.FacetTileInfo)accumulator$iv.next();
            TileLayoutInfo layoutInfo = layoutInfos.get(index);
            DoubleVector geomInnerBoundsOffset = layoutInfo.getGeomInnerBounds().getOrigin().subtract(layoutInfo.getGeomOuterBounds().getOrigin());
            DoubleVector geomContentBoundsOffset = layoutInfo.getGeomContentBounds().getOrigin().subtract(layoutInfo.getGeomOuterBounds().getOrigin());
            Object e = tileBoundsList.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DoubleRectangle tileBounds = (DoubleRectangle)e;
            Object e2 = geomOuterBoundsList.get(index);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            DoubleRectangle geomOuterBounds = (DoubleRectangle)e2;
            DoubleRectangle geomInnerBounds = new DoubleRectangle(geomOuterBounds.getOrigin().add(geomInnerBoundsOffset), layoutInfo.getGeomInnerBounds().getDimension());
            DoubleRectangle geomContentBounds = new DoubleRectangle(geomOuterBounds.getOrigin().add(geomContentBoundsOffset), layoutInfo.getGeomContentBounds().getDimension());
            boolean tileX = this.facetsTheme.horizontalFacetStrip().showStrip();
            if (tileX) {
                List list4 = (List)facetColTabHeights.get(facetTile.getRow());
                if (list4 == null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = facetTile.getColLabs();
                    boolean $i$f$map = false;
                    Iterable index2 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it6;
                        String tileHeight = (String)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl = false;
                        collection.add(Companion.facetLabelSize((String)it6, this.facetsTheme.horizontalFacetStrip(), (Function1<? super Thickness, Double>)((Function1)doLayout.xLabels.colHeights.1.1.INSTANCE)));
                    }
                    list4 = (List)destination$iv$iv3;
                }
                List colHeights2 = list4;
                list3 = CollectionsKt.zip((Iterable)facetTile.getColLabs(), (Iterable)colHeights2);
            } else if (!tileX) {
                list3 = CollectionsKt.emptyList();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List xLabels2 = list3;
            boolean colHeights2 = this.facetsTheme.verticalFacetStrip().showStrip();
            if (colHeights2) {
                if (facetTile.getRowLab() != null) {
                    String it7;
                    boolean bl = false;
                    pair2 = TuplesKt.to((Object)it7, (Object)facetRowTabWidth);
                } else {
                    pair2 = null;
                }
            } else if (!colHeights2) {
                pair2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair yLabel = pair2;
            DoubleRectangle doubleRectangle = tileBounds.add(originDelta);
            DoubleRectangle doubleRectangle2 = geomOuterBounds.add(originDelta);
            DoubleRectangle doubleRectangle3 = geomInnerBounds.add(originDelta);
            DoubleRectangle doubleRectangle4 = geomContentBounds.add(originDelta);
            AxisLayoutInfoQuad axisLayoutInfoQuad = layoutInfo.getAxisInfos();
            boolean bl = facetTile.getHasHAxis();
            boolean bl7 = facetTile.getHasVAxis();
            int n3 = facetTile.getTrueIndex();
            TileLayoutInfo newLayoutInfo = new TileLayoutInfo(tilesPaddingLeftTop, doubleRectangle, doubleRectangle2, doubleRectangle3, doubleRectangle4, axisLayoutInfoQuad, bl, bl7, xLabels2, (Pair<String, Double>)yLabel, n3);
            finalLayoutInfos.add(newLayoutInfo);
        }
        Insets plotInsets = new Insets(tilesPaddingLeftTop, this.insets.getRightBottom());
        return new PlotLayoutInfo((List<TileLayoutInfo>)finalLayoutInfos, plotInsets);
    }

    public static final /* synthetic */ FacetsTheme access$getFacetsTheme$p(FacetedPlotLayout $this) {
        return $this.facetsTheme;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001e\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0012J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout$Companion;", "", "()V", "FACET_PADDING", "", "PANEL_PADDING", "", "facetColHeadTotalHeight", "colLabHeights", "", "colLabs", "", "facetsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetStripTheme;", "facetLabelSize", "title", "theme", "marginSize", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "titleSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nFacetedPlotLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final double facetLabelSize(@NotNull String title, @NotNull FacetStripTheme theme, @NotNull Function1<? super Thickness, Double> marginSize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter(marginSize, (String)"marginSize");
            return this.titleSize(title, theme).getY() + ((Number)marginSize.invoke((Object)theme.stripMargins())).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        private final double facetColHeadTotalHeight(List<String> colLabs, FacetStripTheme facetsTheme) {
            double d;
            if (!((Collection)colLabs).isEmpty()) {
                Iterable iterable = colLabs;
                double d2 = 0.0;
                for (Object t : iterable) {
                    void it;
                    String string = (String)t;
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = Companion.facetLabelSize((String)it, facetsTheme, (Function1<? super Thickness, Double>)((Function1)facetColHeadTotalHeight.1.1.INSTANCE));
                    d2 = d3 + d4;
                }
                d = d2 + (double)3;
            } else {
                d = 0.0;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        public final double facetColHeadTotalHeight(@NotNull List<Double> colLabHeights) {
            void var2_2;
            Intrinsics.checkNotNullParameter(colLabHeights, (String)"colLabHeights");
            double labHeight2 = CollectionsKt.sumOfDouble((Iterable)colLabHeights);
            boolean bl = false;
            return labHeight2 > 0.0 ? labHeight2 + (double)3 : var2_2;
        }

        @NotNull
        public final DoubleVector titleSize(@NotNull String title, @NotNull FacetStripTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(title, PlotLabelSpecFactory.INSTANCE.facetText(theme));
        }

        public static final /* synthetic */ double access$facetColHeadTotalHeight(Companion $this, List colLabs, FacetStripTheme facetsTheme) {
            return $this.facetColHeadTotalHeight(colLabs, facetsTheme);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

