/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.core.commons.geometry.PolylineSimplifier;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001a\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\u000b\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\"\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/HexagonsHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper;", "myAesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "geometryFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lkotlin/jvm/functions/Function1;)V", "myResamplingPrecision", "", "createHexagons", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "createTooltips", "", "p", "hex", "plot-base"})
@SourceDebugExtension(value={"SMAP\nHexagonsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexagonsHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/HexagonsHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1603#2,9:81\n1855#2:90\n1856#2:92\n1612#2:93\n1#3:91\n1#3:94\n*S KotlinDebug\n*F\n+ 1 HexagonsHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/HexagonsHelper\n*L\n57#1:81,9\n57#1:90\n57#1:92\n57#1:93\n57#1:91\n*E\n"})
public final class HexagonsHelper
extends LinesHelper {
    @NotNull
    private final Aesthetics myAesthetics;
    @NotNull
    private final Function1<DataPointAesthetics, List<DoubleVector>> geometryFactory;
    private double myResamplingPrecision;

    public HexagonsHelper(@NotNull Aesthetics myAesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, @NotNull Function1<? super DataPointAesthetics, ? extends List<DoubleVector>> geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)myAesthetics, (String)"myAesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter(geometryFactory, (String)"geometryFactory");
        super(pos, coord, ctx2);
        this.myAesthetics = myAesthetics;
        this.geometryFactory = geometryFactory;
        this.myResamplingPrecision = 0.95;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LinePath> createHexagons() {
        int pointCount = this.myAesthetics.dataPointCount();
        List hexagons = new ArrayList();
        for (int index = 0; index < pointCount; ++index) {
            List clientHex;
            List list2;
            void $this$mapNotNullTo$iv$iv;
            List it;
            List hex;
            DataPointAesthetics p = this.myAesthetics.dataPointAt(index);
            if ((List)this.geometryFactory.invoke((Object)p) == null) continue;
            if (this.getMyResamplingEnabled()) {
                List list3;
                AdaptiveResampler.Companion companion = AdaptiveResampler.Companion;
                double d = this.myResamplingPrecision;
                List<DoubleVector> polyHex2 = companion.resample(hex, d, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(this, p){
                    final /* synthetic */ HexagonsHelper this$0;
                    final /* synthetic */ DataPointAesthetics $p;
                    {
                        this.this$0 = $receiver;
                        this.$p = $p;
                        super(1);
                    }

                    @Nullable
                    public final DoubleVector invoke(@NotNull DoubleVector it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.this$0.toClient(it, this.$p);
                    }
                }));
                it = PolylineSimplifier.Companion.douglasPeucker(polyHex2).setWeightLimit(0.25).getPoints();
                boolean bl = false;
                if (it.size() != 1) {
                    System.out.println((Object)("HexagonsHelper: expected a single path, but got " + it.size()));
                }
                if ((list3 = (List)CollectionsKt.firstOrNull(it)) == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List simplified = list3;
                LinePath element = LinePath.Companion.polygon(simplified);
                LinesHelper.decorate$default(this, element, p, true, null, 8, null);
                hexagons.add(element);
                this.createTooltips(p, simplified);
                continue;
            }
            Iterable $this$mapNotNull$iv = hex;
            boolean $i$f$mapNotNull = false;
            Iterable bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DoubleVector it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                DoubleVector it2 = (DoubleVector)element$iv$iv;
                boolean bl3 = false;
                if (this.toClient(it2, p) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            it = list2 = (List)destination$iv$iv;
            boolean bl5 = false;
            if ((it.size() == 7 ? list2 : null) == null) continue;
            clientHex = clientHex;
            LinePath element = LinePath.Companion.polygon(clientHex);
            LinesHelper.decorate$default(this, element, p, true, null, 8, null);
            hexagons.add(element);
            this.createTooltips(p, clientHex);
        }
        return hexagons;
    }

    private final void createTooltips(DataPointAesthetics p, List<DoubleVector> hex) {
        this.getCtx$plot_base().getTargetCollector().addPolygon(hex, p.index(), new GeomTargetCollector.TooltipParams(null, null, null, (List)HintColorUtil.INSTANCE.createColorMarkerMapper(null, this.getCtx$plot_base()).invoke((Object)p), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
    }
}

