/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser.core;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInCharsHandler;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInStartsWithCharsHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadingParser
extends AbstractBlockParser {
    final Heading block = new Heading();

    public HeadingParser(int level) {
        this.block.setLevel(level);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.block.getText(), this.block);
    }

    @Override
    public void closeBlock(ParserState state) {
    }

    static class HeadingOptions {
        final boolean noAtxSpace;
        final boolean noEmptyHeadingWithoutSpace;
        final boolean noLeadSpace;
        final boolean canInterruptItemParagraph;
        final int setextMarkerLength;

        public HeadingOptions(DataHolder options) {
            this.noAtxSpace = Parser.HEADING_NO_ATX_SPACE.get(options);
            this.noEmptyHeadingWithoutSpace = Parser.HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE.get(options);
            this.noLeadSpace = Parser.HEADING_NO_LEAD_SPACE.get(options);
            this.canInterruptItemParagraph = Parser.HEADING_CAN_INTERRUPT_ITEM_PARAGRAPH.get(options);
            this.setextMarkerLength = Parser.HEADING_SETEXT_MARKER_LENGTH.get(options);
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final HeadingOptions options;
        private final HeadingParsing myParsing;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new HeadingOptions(options);
            this.myParsing = new HeadingParsing(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4 || this.options.noLeadSpace && state.getIndent() >= 1) {
                return BlockStart.none();
            }
            if (state.getActiveBlockParser() instanceof FencedCodeBlockParser) {
                return BlockStart.none();
            }
            if (!this.options.canInterruptItemParagraph) {
                boolean inParagraphListItem;
                BlockParser matched = matchedBlockParser.getBlockParser();
                boolean inParagraph = matched.isParagraphParser();
                boolean bl = inParagraphListItem = inParagraph && matched.getBlock().getParent() instanceof ListItem && matched.getBlock() == matched.getBlock().getParent().getFirstChild();
                if (inParagraphListItem) {
                    return BlockStart.none();
                }
            }
            BasedSequence line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence paragraph = matchedBlockParser.getParagraphContent();
            BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
            Matcher matcher = this.myParsing.ATX_HEADING.matcher(trySequence);
            if (matcher.find()) {
                int newOffset = nextNonSpace + matcher.group(0).length();
                int openingStart = matcher.start();
                int openingEnd = matcher.end();
                BasedSequence openingMarker = (BasedSequence)trySequence.subSequence(openingStart, openingEnd).trim();
                int level = openingMarker.length();
                BlockContent content = new BlockContent();
                content.add((BasedSequence)state.getLineWithEOL().subSequence(newOffset), state.getIndent());
                BasedSequence headerText = (BasedSequence)trySequence.subSequence(openingEnd);
                BasedSequence closingMarker = null;
                matcher = this.myParsing.ATX_TRAILING.matcher(headerText);
                if (matcher.find()) {
                    int closingStart = matcher.start();
                    int closingEnd = matcher.end();
                    closingMarker = (BasedSequence)headerText.subSequence(closingStart, closingEnd).trim();
                    headerText = headerText.subSequence(0, closingStart);
                }
                HeadingParser headingParser = new HeadingParser(level);
                headingParser.block.setOpeningMarker(openingMarker);
                headingParser.block.setText((BasedSequence)headerText.trim());
                headingParser.block.setClosingMarker(closingMarker);
                headingParser.block.setCharsFromContent();
                return BlockStart.of(headingParser).atIndex(line.length());
            }
            matcher = this.myParsing.SETEXT_HEADING.matcher(trySequence);
            if (matcher.find()) {
                if (paragraph != null) {
                    int level = matcher.group(0).charAt(0) == '=' ? 1 : 2;
                    BlockContent content = new BlockContent();
                    content.addAll(matchedBlockParser.getParagraphLines(), matchedBlockParser.getParagraphEolLengths());
                    BasedSequence headingText = (BasedSequence)content.getContents().trim();
                    BasedSequence closingMarker = (BasedSequence)line.trim();
                    HeadingParser headingParser = new HeadingParser(level);
                    headingParser.block.setText(headingText);
                    headingParser.block.setClosingMarker(closingMarker);
                    headingParser.block.setCharsFromContent();
                    return BlockStart.of(headingParser).atIndex(line.length()).replaceActiveBlockParser();
                }
                return BlockStart.none();
            }
            return BlockStart.none();
        }
    }

    static class HeadingLeadInHandler {
        static final SpecialLeadInHandler HANDLER_NO_SPACE = SpecialLeadInStartsWithCharsHandler.create('#');
        static final SpecialLeadInHandler HANDLER_SPACE = SpecialLeadInCharsHandler.create('#');

        HeadingLeadInHandler() {
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            HashSet set = new HashSet();
            set.add(BlockQuoteParser.Factory.class);
            return set;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return new HashSet(Arrays.asList(FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @Nullable
        public SpecialLeadInHandler getLeadInHandler(@NotNull DataHolder options) {
            boolean noAtxSpace = Parser.ESCAPE_HEADING_NO_ATX_SPACE.get(options) != false || Parser.HEADING_NO_ATX_SPACE.get(options) != false;
            return noAtxSpace ? HeadingLeadInHandler.HANDLER_NO_SPACE : HeadingLeadInHandler.HANDLER_SPACE;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }

    static class HeadingParsing
    extends Parsing {
        private final Pattern ATX_HEADING;
        private final Pattern ATX_TRAILING;
        private final Pattern SETEXT_HEADING;

        public HeadingParsing(DataHolder options) {
            super(options);
            this.ATX_HEADING = Parser.HEADING_NO_ATX_SPACE.get(options) != false ? Pattern.compile("^#{1,6}(?:[ \t]*|$)") : (Parser.HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE.get(options) != false ? Pattern.compile("^#{1,6}(?:[ \t]*(?=[^ \t#])|[ \t]+$)") : Pattern.compile("^#{1,6}(?:[ \t]+|$)"));
            this.ATX_TRAILING = Parser.HEADING_NO_ATX_SPACE.get(options) != false ? Pattern.compile("[ \t]*#+[ \t]*$") : Pattern.compile("(^| |\t)[ \t]*#+[ \t]*$");
            int minLength = Parser.HEADING_SETEXT_MARKER_LENGTH.get(options);
            this.SETEXT_HEADING = minLength <= 1 ? Pattern.compile("^(?:=+|-+)[ \t]*$") : Pattern.compile("^(?:={" + minLength + ",}|-{" + minLength + ",})[ \t]*$");
        }
    }
}

