/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.misc.Utils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeLinkResolver
implements LinkResolver {
    private final String docRelativeURL;
    private final String docRootURL;
    private final String[] relativeParts;

    public MergeLinkResolver(LinkResolverBasicContext context) {
        String docRelativeURL = Formatter.DOC_RELATIVE_URL.get(context.getOptions());
        String docRootURL = Formatter.DOC_ROOT_URL.get(context.getOptions());
        this.docRelativeURL = docRelativeURL;
        this.docRootURL = docRootURL;
        docRelativeURL = Utils.removePrefix(docRelativeURL, '/');
        this.relativeParts = docRelativeURL.split("/");
    }

    @Override
    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverBasicContext context, @NotNull ResolvedLink link) {
        if (node instanceof Image || node instanceof Link || node instanceof Reference) {
            Object url = link.getUrl();
            if (this.docRelativeURL.isEmpty() && this.docRootURL.isEmpty()) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("http://") || ((String)url).startsWith("https://") || ((String)url).startsWith("ftp://") || ((String)url).startsWith("sftp://")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("file:/")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (((String)url).startsWith("/")) {
                if (this.docRootURL != null && !this.docRootURL.isEmpty()) {
                    url = (!this.docRootURL.startsWith("/") ? "/" : "") + this.docRootURL + (String)url;
                    return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
                }
            } else if (!((String)url).matches("^(?:[a-z]+:|#|\\?)")) {
                String pageRef = url;
                String suffix = "";
                int pos = ((String)url).indexOf(35);
                if (pos == 0) {
                    return link.withStatus(LinkStatus.VALID);
                }
                if (pos > 0) {
                    suffix = ((String)url).substring(pos);
                    pageRef = ((String)url).substring(0, pos);
                } else if (((String)url).contains("?")) {
                    pos = ((String)url).indexOf("?");
                    suffix = ((String)url).substring(pos);
                    pageRef = ((String)url).substring(0, pos);
                }
                String[] pathParts = pageRef.split("/");
                int docParts = this.relativeParts.length;
                int iMax = pathParts.length;
                StringBuilder resolved = new StringBuilder();
                String sep = "";
                for (int i = 0; i < iMax; ++i) {
                    String part = pathParts[i];
                    if (part.equals(".")) continue;
                    if (part.equals("..")) {
                        if (docParts == 0) {
                            return link;
                        }
                        --docParts;
                        continue;
                    }
                    resolved.append(sep);
                    resolved.append(part);
                    sep = "/";
                }
                sep = this.docRelativeURL.startsWith("/") ? "/" : "";
                StringBuilder resolvedPath = new StringBuilder();
                iMax = docParts;
                for (int i = 0; i < iMax; ++i) {
                    resolvedPath.append(sep);
                    resolvedPath.append(this.relativeParts[i]);
                    sep = "/";
                }
                resolvedPath.append('/').append((CharSequence)resolved).append(suffix);
                String resolvedUri = resolvedPath.toString();
                return link.withStatus(LinkStatus.VALID).withUrl(resolvedUri);
            }
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public LinkResolver apply(@NotNull LinkResolverBasicContext context) {
            return new MergeLinkResolver(context);
        }
    }
}

