/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TaskListNodeRenderer
implements NodeRenderer {
    public static final AttributablePart TASK_ITEM_PARAGRAPH = new AttributablePart("TASK_ITEM_PARAGRAPH");
    final String doneMarker;
    final String notDoneMarker;
    private final String tightItemClass;
    private final String looseItemClass;
    private final String itemDoneClass;
    private final String itemNotDoneClass;
    final String paragraphClass;
    private final ListOptions listOptions;

    public TaskListNodeRenderer(DataHolder options) {
        this.doneMarker = TaskListExtension.ITEM_DONE_MARKER.get(options);
        this.notDoneMarker = TaskListExtension.ITEM_NOT_DONE_MARKER.get(options);
        this.tightItemClass = TaskListExtension.TIGHT_ITEM_CLASS.get(options);
        this.looseItemClass = TaskListExtension.LOOSE_ITEM_CLASS.get(options);
        this.itemDoneClass = TaskListExtension.ITEM_DONE_CLASS.get(options);
        this.itemNotDoneClass = TaskListExtension.ITEM_NOT_DONE_CLASS.get(options);
        this.paragraphClass = TaskListExtension.PARAGRAPH_CLASS.get(options);
        this.listOptions = ListOptions.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<TaskListItem>(TaskListItem.class, this::render));
        return set;
    }

    void render(TaskListItem node, NodeRendererContext context, HtmlWriter html) {
        String itemDoneStatusClass;
        BasedSequence sourceText = context.getHtmlOptions().sourcePositionParagraphLines || node.getFirstChild() == null ? node.getChars() : node.getFirstChild().getChars();
        String string = itemDoneStatusClass = node.isItemDoneMarker() ? this.itemDoneClass : this.itemNotDoneClass;
        if (this.listOptions.isTightListItem(node)) {
            if (!this.tightItemClass.isEmpty()) {
                html.attr("class", this.tightItemClass);
            }
            if (!itemDoneStatusClass.isEmpty() && !itemDoneStatusClass.equals(this.tightItemClass)) {
                html.attr("class", itemDoneStatusClass);
            }
            ((HtmlWriter)html.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"li", () -> {
                html.raw(node.isItemDoneMarker() ? this.doneMarker : this.notDoneMarker);
                context.renderChildren(node);
            });
        } else {
            if (!this.looseItemClass.isEmpty()) {
                html.attr("class", this.looseItemClass);
            }
            if (!itemDoneStatusClass.isEmpty() && !itemDoneStatusClass.equals(this.looseItemClass)) {
                html.attr("class", itemDoneStatusClass);
            }
            html.withAttr(CoreNodeRenderer.LOOSE_LIST_ITEM).tagIndent("li", () -> {
                if (!this.paragraphClass.isEmpty()) {
                    html.attr("class", this.paragraphClass);
                }
                html.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset()).withAttr(TASK_ITEM_PARAGRAPH).tagLine((CharSequence)"p", () -> {
                    html.raw(node.isItemDoneMarker() ? this.doneMarker : this.notDoneMarker);
                    context.renderChildren(node);
                });
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new TaskListNodeRenderer(options);
        }
    }
}

