/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FootnoteNodeRenderer
implements PhasedNodeRenderer {
    private final FootnoteRepository footnoteRepository;
    private final FootnoteOptions options;
    private final boolean recheckUndefinedReferences;

    public FootnoteNodeRenderer(DataHolder options) {
        this.options = new FootnoteOptions(options);
        this.footnoteRepository = FootnoteExtension.FOOTNOTES.get(options);
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
        this.footnoteRepository.resolveFootnoteOrdinals();
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<Footnote>(Footnote.class, this::render), new NodeRenderingHandler<FootnoteBlock>(FootnoteBlock.class, this::render)));
    }

    @Override
    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        set.add(RenderingPhase.BODY_BOTTOM);
        return set;
    }

    @Override
    public void renderDocument(@NotNull NodeRendererContext context, @NotNull HtmlWriter html, @NotNull Document document, @NotNull RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor(new VisitHandler<Footnote>(Footnote.class, node -> {
                FootnoteBlock footonoteBlock;
                if (!node.isDefined() && (footonoteBlock = node.getFootnoteBlock(this.footnoteRepository)) != null) {
                    this.footnoteRepository.addFootnoteReference(footonoteBlock, (Footnote)node);
                    node.setFootnoteBlock(footonoteBlock);
                    hadNewFootnotes[0] = true;
                }
            }));
            visitor.visit(document);
            if (hadNewFootnotes[0]) {
                this.footnoteRepository.resolveFootnoteOrdinals();
            }
        }
        if (phase == RenderingPhase.BODY_BOTTOM && this.footnoteRepository.getReferencedFootnoteBlocks().size() > 0) {
            ((HtmlWriter)html.attr("class", "footnotes")).withAttr().tagIndent("div", () -> {
                html.tagVoidLine("hr");
                html.tagIndent("ol", () -> {
                    for (FootnoteBlock footnoteBlock : this.footnoteRepository.getReferencedFootnoteBlocks()) {
                        int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
                        html.attr("id", "fn-" + footnoteOrdinal);
                        html.withAttr().tagIndent("li", () -> {
                            context.renderChildren(footnoteBlock);
                            int iMax = footnoteBlock.getFootnoteReferences();
                            for (int i = 0; i < iMax; ++i) {
                                html.attr("href", "#fnref-" + footnoteOrdinal + (i == 0 ? "" : String.format(Locale.US, "-%d", i)));
                                if (!this.options.footnoteBackLinkRefClass.isEmpty()) {
                                    html.attr("class", this.options.footnoteBackLinkRefClass);
                                }
                                ((HtmlWriter)html.line()).withAttr().tag("a");
                                html.raw(this.options.footnoteBackRefString);
                                html.tag("/a");
                            }
                        });
                    }
                });
            });
        }
    }

    private void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(Footnote node, NodeRendererContext context, HtmlWriter html) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            html.raw("[^");
            context.renderChildren(node);
            html.raw("]");
        } else {
            int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
            int i = node.getReferenceOrdinal();
            html.attr("id", "fnref-" + footnoteOrdinal + (i == 0 ? "" : String.format(Locale.US, "-%d", i)));
            html.srcPos(node.getChars()).withAttr().tag("sup", false, false, () -> {
                if (!this.options.footnoteLinkRefClass.isEmpty()) {
                    html.attr("class", this.options.footnoteLinkRefClass);
                }
                html.attr("href", "#fn-" + footnoteOrdinal);
                html.withAttr().tag("a");
                html.raw(this.options.footnoteRefPrefix + footnoteOrdinal + this.options.footnoteRefSuffix);
                html.tag("/a");
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new FootnoteNodeRenderer(options);
        }
    }
}

