/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public enum Depth {
    UNKNOWN("unknown"),
    INFINITY("infinity"),
    IMMEDIATES("immediates"),
    FILES("files"),
    EMPTY("empty"),
    EXCLUDE("exclude");

    @NotNull
    private static final Map<String, Depth> ourAllDepths;
    @NonNls
    @NotNull
    private final String myName;

    private Depth(String name) {
        if (name == null) {
            Depth.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @NonNls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            Depth.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = SvnBundle.message(switch (this) {
            case INFINITY -> "label.depth.infinity";
            case IMMEDIATES -> "label.depth.immediates";
            case FILES -> "label.depth.files";
            case EMPTY -> "label.depth.empty";
            case EXCLUDE -> "label.depth.exclude";
            default -> "label.depth.unknown";
        }, new Object[0]);
        if (string == null) {
            Depth.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull Depth depth) {
        if (depth == null) {
            Depth.$$$reportNull$$$0(3);
        }
        ourAllDepths.put(depth.myName, depth);
    }

    @NotNull
    public static Depth from(@NonNls @NotNull String depthName) {
        Depth result;
        if (depthName == null) {
            Depth.$$$reportNull$$$0(4);
        }
        if ((result = ourAllDepths.get(depthName)) == null) {
            throw new IllegalArgumentException("Unknown depth " + depthName);
        }
        Depth depth = result;
        if (depth == null) {
            Depth.$$$reportNull$$$0(5);
        }
        return depth;
    }

    @NotNull
    public static Depth allOrFiles(boolean recursive) {
        Depth depth = recursive ? INFINITY : FILES;
        if (depth == null) {
            Depth.$$$reportNull$$$0(6);
        }
        return depth;
    }

    @NotNull
    public static Depth allOrEmpty(boolean recursive) {
        Depth depth = recursive ? INFINITY : EMPTY;
        if (depth == null) {
            Depth.$$$reportNull$$$0(7);
        }
        return depth;
    }

    public static boolean isRecursive(@Nullable Depth depth) {
        return depth == null || depth == INFINITY || depth == UNKNOWN;
    }

    static {
        ourAllDepths = new HashMap<String, Depth>();
        for (Depth action : Depth.values()) {
            Depth.register(action);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/Depth";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depth";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depthName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/Depth";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allOrFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allOrEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

