/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.collaboration.auth.OAuthCallbackHandlerBase;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import io.netty.handler.codec.http.HttpRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthRequest;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthService;
import org.jetbrains.qodana.registry.QodanaRegistry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthCallbackHandler;", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase;", "<init>", "()V", "oauthService", "Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthService;", "handleOAuthResult", "Lcom/intellij/collaboration/auth/OAuthCallbackHandlerBase$AcceptCodeHandleResult;", "oAuthResult", "Lcom/intellij/collaboration/auth/services/OAuthService$OAuthResult;", "isOriginAllowed", "Lorg/jetbrains/ide/HttpRequestHandler$OriginCheckResult;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "intellij.qodana"})
public final class QodanaCloudOAuthCallbackHandler
extends OAuthCallbackHandlerBase {
    @NotNull
    protected QodanaCloudOAuthService oauthService() {
        return QodanaCloudOAuthService.Companion.getInstance();
    }

    @NotNull
    protected OAuthCallbackHandlerBase.AcceptCodeHandleResult handleOAuthResult(@NotNull OAuthService.OAuthResult<?> oAuthResult) {
        Intrinsics.checkNotNullParameter(oAuthResult, (String)"oAuthResult");
        OAuthRequest oAuthRequest = oAuthResult.getRequest();
        QodanaCloudOAuthRequest qodanaCloudOAuthRequest = oAuthRequest instanceof QodanaCloudOAuthRequest ? (QodanaCloudOAuthRequest)oAuthRequest : null;
        if (qodanaCloudOAuthRequest == null) {
            throw new RuntimeException("No auth in process");
        }
        QodanaCloudOAuthRequest currentOAuthRequest = qodanaCloudOAuthRequest;
        Url frontendUrl = Urls.newFromEncoded((String)currentOAuthRequest.getFrontendUrl());
        Url url = QodanaRegistry.INSTANCE.isQodanaLicenseAgreementCallbackEnabled() ? frontendUrl.resolve("ideauth").addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"port", (Object)String.valueOf(currentOAuthRequest.getPort())))) : frontendUrl;
        Intrinsics.checkNotNull((Object)url);
        Url redirectUrl = url;
        return (OAuthCallbackHandlerBase.AcceptCodeHandleResult)new OAuthCallbackHandlerBase.AcceptCodeHandleResult.Redirect(redirectUrl);
    }

    @NotNull
    protected HttpRequestHandler.OriginCheckResult isOriginAllowed(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.oauthService().currentOAuthRequest() == null) {
            return HttpRequestHandler.OriginCheckResult.FORBID;
        }
        return HttpRequestHandler.OriginCheckResult.ALLOW;
    }
}

