/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference.graph;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnit;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitGraph;
import org.jetbrains.plugins.groovy.intentions.style.inference.graph.InferenceUnitNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0007J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0019R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraphBuilder;", "", "<init>", "()V", "relations", "", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnit;", "registered", "", "fixedInstantiations", "", "Lcom/intellij/psi/PsiType;", "directUnits", "addRelation", "left", "right", "register", "unit", "unitNode", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitNode;", "setDirect", "setType", "type", "build", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraph;", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nInferenceUnitGraphBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferenceUnitGraphBuilder.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraphBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1056#2:75\n*S KotlinDebug\n*F\n+ 1 InferenceUnitGraphBuilder.kt\norg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitGraphBuilder\n*L\n56#1:75\n*E\n"})
public final class InferenceUnitGraphBuilder {
    @NotNull
    private final List<Pair<InferenceUnit, InferenceUnit>> relations = new ArrayList();
    @NotNull
    private final Set<InferenceUnit> registered = new LinkedHashSet();
    @NotNull
    private final Map<InferenceUnit, PsiType> fixedInstantiations = new LinkedHashMap();
    @NotNull
    private final Set<InferenceUnit> directUnits = new LinkedHashSet();

    @NotNull
    public final InferenceUnitGraphBuilder addRelation(@NotNull InferenceUnit left, @NotNull InferenceUnit right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.register(left);
        this.register(right);
        this.relations.add((Pair<InferenceUnit, InferenceUnit>)TuplesKt.to((Object)left, (Object)right));
        return this;
    }

    @NotNull
    public final InferenceUnitGraphBuilder register(@NotNull InferenceUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.registered.add(unit);
        return this;
    }

    @NotNull
    public final InferenceUnitGraphBuilder register(@NotNull InferenceUnitNode unitNode) {
        Intrinsics.checkNotNullParameter((Object)unitNode, (String)"unitNode");
        if (unitNode.getDirect()) {
            this.setDirect(unitNode.getCore());
        }
        this.setType(unitNode.getCore(), unitNode.getTypeInstantiation());
        return this;
    }

    @NotNull
    public final InferenceUnitGraphBuilder setDirect(@NotNull InferenceUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.register(unit);
        this.directUnits.add(unit);
        return this;
    }

    @NotNull
    public final InferenceUnitGraphBuilder setType(@NotNull InferenceUnit unit, @NotNull PsiType type) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.register(unit);
        this.fixedInstantiations.put(unit, type);
        return this;
    }

    @NotNull
    public final InferenceUnitGraph build() {
        ArrayList<InferenceUnitNode> inferenceNodes = new ArrayList<InferenceUnitNode>();
        List superTypesMap = new ArrayList();
        List subTypesMap = new ArrayList();
        Iterable $this$sortedBy$iv232 = this.registered;
        boolean $i$f$sortedBy = false;
        List registeredUnits = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv232, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                InferenceUnit it = (InferenceUnit)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getInitialTypeParameter().getName());
                it = (InferenceUnit)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getInitialTypeParameter().getName())));
            }
        });
        int $this$sortedBy$iv232 = registeredUnits.size();
        int n = 0;
        while (n < $this$sortedBy$iv232) {
            int n2 = n++;
            boolean bl = false;
            superTypesMap.add((Set)new LinkedHashSet());
            subTypesMap.add((Set)new LinkedHashSet());
        }
        Map unitIndexMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)registeredUnits, (Iterable)((Iterable)CollectionsKt.getIndices((Collection)registeredUnits))));
        for (Pair<InferenceUnit, InferenceUnit> pair : this.relations) {
            InferenceUnit left = (InferenceUnit)pair.component1();
            InferenceUnit right = (InferenceUnit)pair.component2();
            ((Set)subTypesMap.get(((Number)MapsKt.getValue((Map)unitIndexMap, (Object)left)).intValue())).add(() -> InferenceUnitGraphBuilder.build$lambda$2(inferenceNodes, unitIndexMap, right));
            ((Set)superTypesMap.get(((Number)MapsKt.getValue((Map)unitIndexMap, (Object)right)).intValue())).add(() -> InferenceUnitGraphBuilder.build$lambda$3(inferenceNodes, unitIndexMap, left));
        }
        for (Map.Entry entry : unitIndexMap.entrySet()) {
            InferenceUnit unit = (InferenceUnit)entry.getKey();
            int index = ((Number)entry.getValue()).intValue();
            Set set = (Set)superTypesMap.get(index);
            Set set2 = (Set)subTypesMap.get(index);
            PsiType psiType = this.fixedInstantiations.get(unit);
            if (psiType == null) {
                PsiType psiType2 = PsiTypes.nullType();
                psiType = psiType2;
                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"nullType(...)");
            }
            inferenceNodes.add(new InferenceUnitNode(unit, set, set2, psiType, this.directUnits.contains(unit)));
        }
        return new InferenceUnitGraph((List<InferenceUnitNode>)inferenceNodes);
    }

    private static final InferenceUnitNode build$lambda$2(ArrayList $inferenceNodes, Map $unitIndexMap, InferenceUnit $right) {
        Object e = $inferenceNodes.get(((Number)MapsKt.getValue((Map)$unitIndexMap, (Object)$right)).intValue());
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (InferenceUnitNode)e;
    }

    private static final InferenceUnitNode build$lambda$3(ArrayList $inferenceNodes, Map $unitIndexMap, InferenceUnit $left) {
        Object e = $inferenceNodes.get(((Number)MapsKt.getValue((Map)$unitIndexMap, (Object)$left)).intValue());
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (InferenceUnitNode)e;
    }
}

