/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.util.function.Consumer;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.Descriptor;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.holders.NonCodeMembersHolder;

final class CustomMembersHolderImpl
implements CustomMembersHolder {
    private final FList<Descriptor> myDeclarations;

    CustomMembersHolderImpl(FList<Descriptor> declarations) {
        this.myDeclarations = declarations;
    }

    @Override
    public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
        return NonCodeMembersHolder.generateMembers(ContainerUtil.reverse(this.myDeclarations), descriptor.justGetPlaceFile()).processMembers(descriptor, processor, state);
    }

    @Override
    public void consumeClosureDescriptors(GroovyClassDescriptor descriptor, Consumer<? super ClosureDescriptor> consumer) {
        NonCodeMembersHolder.generateMembers(ContainerUtil.reverse(this.myDeclarations), descriptor.justGetPlaceFile()).consumeClosureDescriptors(descriptor, consumer);
    }
}

